/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.client.hud;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.init.TheLastSwordModItems;

@Mod.EventBusSubscriber(modid="the_last_sword", value={Dist.CLIENT})
public class DragonArmorOverlay {
    private static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("the_last_sword:textures/screens/dragon_armor_overlay.png");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderGuiPre(RenderGuiEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91066_.f_92062_) {
            return;
        }
        if (!TheLastSwordConfiguration.getDragonArmorEnableHudSafely()) {
            return;
        }
        if (!DragonArmorOverlay.isWearingFullDragonArmor((Player)player)) {
            return;
        }
        int w = event.getWindow().m_85445_();
        int h = event.getWindow().m_85446_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        event.getGuiGraphics().m_280163_(OVERLAY_TEXTURE, 0, 0, 0.0f, 0.0f, w, h, w, h);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static boolean isWearingFullDragonArmor(Player player) {
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        return !helmet.m_41619_() && helmet.m_150930_((Item)TheLastSwordModItems.DRAGON_ARMOR_HELMET.get()) && !chestplate.m_41619_() && chestplate.m_150930_((Item)TheLastSwordModItems.DRAGON_ARMOR_CHESTPLATE.get()) && !leggings.m_41619_() && leggings.m_150930_((Item)TheLastSwordModItems.DRAGON_ARMOR_LEGGINGS.get()) && !boots.m_41619_() && boots.m_150930_((Item)TheLastSwordModItems.DRAGON_ARMOR_BOOTS.get());
    }
}

