/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.client.hud;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ModernButton {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final Component label;
    private final Runnable onClick;

    public ModernButton(int x, int y, int width, int height, Component label, Runnable onClick) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.label = label;
        this.onClick = onClick;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, Font font) {
        boolean hovering = mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        int bgColor = hovering ? -11890462 : -13882324;
        int borderColor = -16777216;
        int textColor = -1;
        guiGraphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, bgColor);
        guiGraphics.m_280509_(this.x, this.y, this.x + this.width, this.y + 1, borderColor);
        guiGraphics.m_280509_(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height, borderColor);
        guiGraphics.m_280509_(this.x, this.y, this.x + 1, this.y + this.height, borderColor);
        guiGraphics.m_280509_(this.x + this.width - 1, this.y, this.x + this.width, this.y + this.height, borderColor);
        int textWidth = font.m_92852_((FormattedText)this.label);
        int textX = this.x + (this.width - textWidth) / 2;
        int textY = this.y + (this.height - 8) / 2 + 1;
        guiGraphics.m_280614_(font, this.label, textX, textY, textColor, false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height)) {
            this.onClick.run();
            return true;
        }
        return false;
    }
}

