/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.client.model;

import com.mojang.math.Transformation;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PerspectiveModelState {
    public static final PerspectiveModelState DEFAULT_ITEM = new PerspectiveModelState();
    private final Transformation gui;
    private final Transformation ground;
    private final Transformation fixed;
    private final Transformation firstPersonLeft;
    private final Transformation firstPersonRight;
    private final Transformation thirdPersonLeft;
    private final Transformation thirdPersonRight;
    private final Transformation head;

    public PerspectiveModelState() {
        Vector3f defaultTranslation = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f defaultScale = new Vector3f(1.0f, 1.0f, 1.0f);
        Quaternionf defaultRotation = new Quaternionf();
        this.gui = new Transformation(defaultTranslation, defaultRotation, defaultScale, defaultRotation);
        this.ground = new Transformation(defaultTranslation, defaultRotation, defaultScale, defaultRotation);
        this.fixed = new Transformation(defaultTranslation, defaultRotation, defaultScale, defaultRotation);
        this.firstPersonLeft = new Transformation(defaultTranslation, defaultRotation, defaultScale, defaultRotation);
        this.firstPersonRight = new Transformation(defaultTranslation, defaultRotation, defaultScale, defaultRotation);
        this.thirdPersonLeft = new Transformation(defaultTranslation, defaultRotation, defaultScale, defaultRotation);
        this.thirdPersonRight = new Transformation(defaultTranslation, defaultRotation, defaultScale, defaultRotation);
        this.head = new Transformation(defaultTranslation, defaultRotation, defaultScale, defaultRotation);
    }

    public PerspectiveModelState(Transformation gui, Transformation ground, Transformation fixed, Transformation firstPersonLeft, Transformation firstPersonRight, Transformation thirdPersonLeft, Transformation thirdPersonRight, Transformation head) {
        this.gui = gui;
        this.ground = ground;
        this.fixed = fixed;
        this.firstPersonLeft = firstPersonLeft;
        this.firstPersonRight = firstPersonRight;
        this.thirdPersonLeft = thirdPersonLeft;
        this.thirdPersonRight = thirdPersonRight;
        this.head = head;
    }

    @Nullable
    public Transformation getTransform(ItemDisplayContext context) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ItemDisplayContext.GUI -> this.gui;
            case ItemDisplayContext.GROUND -> this.ground;
            case ItemDisplayContext.FIXED -> this.fixed;
            case ItemDisplayContext.FIRST_PERSON_LEFT_HAND -> this.firstPersonLeft;
            case ItemDisplayContext.FIRST_PERSON_RIGHT_HAND -> this.firstPersonRight;
            case ItemDisplayContext.THIRD_PERSON_LEFT_HAND -> this.thirdPersonLeft;
            case ItemDisplayContext.THIRD_PERSON_RIGHT_HAND -> this.thirdPersonRight;
            case ItemDisplayContext.HEAD -> this.head;
            case ItemDisplayContext.NONE -> null;
        };
    }

    public static PerspectiveModelState createForTheLastEndSword() {
        Transformation guiTransform = new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.0f), new Quaternionf());
        Transformation groundTransform = new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternionf(), new Vector3f(0.5f, 0.5f, 0.5f), new Quaternionf());
        Transformation firstPersonRight = new Transformation(new Vector3f(0.1f, 0.2f, 0.1f), new Quaternionf().rotateY((float)Math.toRadians(-90.0)).rotateZ((float)Math.toRadians(25.0)), new Vector3f(1.0f, 1.0f, 1.0f), new Quaternionf());
        Transformation firstPersonLeft = new Transformation(new Vector3f(0.1f, 0.2f, 0.1f), new Quaternionf().rotateY((float)Math.toRadians(90.0)).rotateZ((float)Math.toRadians(-25.0)), new Vector3f(1.0f, 1.0f, 1.0f), new Quaternionf());
        Transformation thirdPersonRight = new Transformation(new Vector3f(0.0f, 0.4f, 0.0f), new Quaternionf().rotateY((float)Math.toRadians(-90.0)).rotateZ((float)Math.toRadians(55.0)), new Vector3f(1.0f, 1.0f, 1.0f), new Quaternionf());
        Transformation thirdPersonLeft = new Transformation(new Vector3f(0.0f, 0.4f, 0.0f), new Quaternionf().rotateY((float)Math.toRadians(90.0)).rotateZ((float)Math.toRadians(-55.0)), new Vector3f(1.0f, 1.0f, 1.0f), new Quaternionf());
        return new PerspectiveModelState(guiTransform, groundTransform, guiTransform, firstPersonLeft, firstPersonRight, thirdPersonLeft, thirdPersonRight, guiTransform);
    }
}

