/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.compat;

import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CompatCheck {
    private static boolean alexsCavesDetected = false;
    private static boolean cataclysmDetected = false;
    private static boolean jeiDetected = false;
    private static boolean touhouLittleMaidDetected = false;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        alexsCavesDetected = ModList.get().isLoaded("alexscaves");
        cataclysmDetected = ModList.get().isLoaded("cataclysm");
        jeiDetected = ModList.get().isLoaded("jei");
        touhouLittleMaidDetected = ModList.get().isLoaded("touhou_little_maid");
    }

    public static boolean UnsafeGetHealthCompatCheck() {
        return CompatCheck.CheckAlexCaves();
    }

    public static boolean CheckAlexCaves() {
        return alexsCavesDetected;
    }

    public static boolean isCataclysmLoaded() {
        return cataclysmDetected;
    }

    public static boolean isJEILoaded() {
        return jeiDetected;
    }

    public static boolean isJEILoadedEarly() {
        return ModList.get().isLoaded("jei");
    }

    public static boolean isTouhouLittleMaidLoaded() {
        return touhouLittleMaidDetected;
    }

    public static boolean isTouhouLittleMaidEntity(LivingEntity entity) {
        if (!touhouLittleMaidDetected) {
            return false;
        }
        return entity.getClass().getName().equals("com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid");
    }
}

