/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.compat.cataclysm;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.compat.cataclysm.CataclysmMedal;

public class CataclysmMedals {

    public static class ScyllaMedal
    extends CataclysmMedal {
        public ScyllaMedal() {
            super("scylla_medal");
        }

        @Override
        public String getDefaultBoundEntityId() {
            return "cataclysm:scylla";
        }

        @Override
        public String getDefaultBoundEntityDisplayName() {
            return "entity.cataclysm.scylla";
        }

        public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
            super.m_6883_(stack, world, entity, slot, selected);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!world.f_46443_) {
                    // empty if block
                }
            }
        }

        public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
            ItemStack stack = player.m_21120_(hand);
            if (player.m_36335_().m_41519_(stack.m_41720_())) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                if (serverLevel.m_46471_()) {
                    if (serverLevel.m_46470_()) {
                        serverLevel.m_8606_(6000, 0, false, false);
                    } else {
                        serverLevel.m_8606_(0, 6000, true, true);
                    }
                } else {
                    serverLevel.m_8606_(0, 6000, true, false);
                }
                player.m_36335_().m_41524_(stack.m_41720_(), 600);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }

        public void onOwnerAttack(Player owner, ItemStack stack, LivingEntity target) {
            Level world = owner.m_9236_();
            if (world.f_46443_) {
                return;
            }
            MobEffect moistureEffect = this.getMoistureEffect();
            if (moistureEffect != null) {
                MobEffectInstance currentEffect = target.m_21124_(moistureEffect);
                int newAmplifier = currentEffect != null ? Math.min(currentEffect.m_19564_() + 1, 4) : 0;
                target.m_7292_(new MobEffectInstance(moistureEffect, 60, newAmplifier));
            }
            if (moistureEffect != null && target.m_21023_(moistureEffect)) {
                boolean isRaining = world.m_46471_();
                boolean isThundering = world.m_46470_();
                if (isRaining || isThundering) {
                    double triggerChance;
                    double d = triggerChance = isThundering ? 0.5 : 0.25;
                    if (world.f_46441_.m_188500_() < triggerChance) {
                        int moistureLevel = target.m_21124_(moistureEffect).m_19564_() + 1;
                        float lightningDamage = (float)moistureLevel * 5.0f;
                        LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(world);
                        if (lightning != null) {
                            lightning.m_6027_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                            lightning.m_20874_(false);
                            world.m_7967_((Entity)lightning);
                            target.m_6469_(world.m_269111_().m_269548_(), lightningDamage);
                        }
                    }
                }
            }
        }

        private MobEffect getMoistureEffect() {
            try {
                return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("cataclysm", "wetness"));
            }
            catch (Exception ignored) {
                return null;
            }
        }

        @Override
        public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
            super.m_7373_(stack, world, tooltip, flag);
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.scylla_medal"));
        }
    }

    public static class TheLeviathanMedal
    extends CataclysmMedal {
        public TheLeviathanMedal() {
            super("the_leviathan_medal");
        }

        @Override
        public String getDefaultBoundEntityId() {
            return "cataclysm:the_leviathan";
        }

        @Override
        public String getDefaultBoundEntityDisplayName() {
            return "entity.cataclysm.the_leviathan";
        }

        public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
            super.m_6883_(stack, world, entity, slot, selected);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!world.f_46443_) {
                    if (!player.m_21023_(MobEffects.f_19592_) || player.m_21124_(MobEffects.f_19592_).m_19564_() < 2) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19592_, 60, 2, false, false));
                    }
                    if (!player.m_21023_(MobEffects.f_19593_) || player.m_21124_(MobEffects.f_19593_).m_19564_() < 2) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 60, 2, false, false));
                    }
                }
            }
        }

        @Override
        public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
            super.m_7373_(stack, world, tooltip, flag);
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.the_leviathan_medal"));
        }
    }

    public static class TheHarbingerMedal
    extends CataclysmMedal {
        public TheHarbingerMedal() {
            super("the_harbinger_medal");
        }

        @Override
        public String getDefaultBoundEntityId() {
            return "cataclysm:the_harbinger";
        }

        @Override
        public String getDefaultBoundEntityDisplayName() {
            return "entity.cataclysm.the_harbinger";
        }

        public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
            super.m_6883_(stack, world, entity, slot, selected);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!world.f_46443_ && player.m_21023_(MobEffects.f_19615_)) {
                    player.m_21195_(MobEffects.f_19615_);
                }
            }
        }

        @Override
        public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
            super.m_7373_(stack, world, tooltip, flag);
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.harbinger_medal"));
        }
    }

    public static class NetheriteMonstrosityMedal
    extends CataclysmMedal {
        public NetheriteMonstrosityMedal() {
            super("netherite_monstrosity_medal");
        }

        @Override
        public String getDefaultBoundEntityId() {
            return "cataclysm:netherite_monstrosity";
        }

        @Override
        public String getDefaultBoundEntityDisplayName() {
            return "entity.cataclysm.netherite_monstrosity";
        }

        public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
            super.m_6883_(stack, world, entity, slot, selected);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!world.f_46443_) {
                    if (!player.m_21023_(MobEffects.f_19607_) || player.m_21124_(MobEffects.f_19607_).m_19564_() < 2) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 60, 2, false, false));
                    }
                    if (player.m_6060_() && (!player.m_21023_(MobEffects.f_19605_) || player.m_21124_(MobEffects.f_19605_).m_19564_() < 0)) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 60, 0, false, false));
                    }
                }
            }
        }

        @Override
        public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
            super.m_7373_(stack, world, tooltip, flag);
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.netherite_monstrosity_medal"));
        }
    }

    public static class MaledictusMedal
    extends CataclysmMedal {
        public MaledictusMedal() {
            super("maledictus_medal");
        }

        @Override
        public String getDefaultBoundEntityId() {
            return "cataclysm:maledictus";
        }

        @Override
        public String getDefaultBoundEntityDisplayName() {
            return "entity.cataclysm.maledictus";
        }

        @Override
        public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
            super.m_7373_(stack, world, tooltip, flag);
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.maledictus_medal"));
        }
    }

    public static class IgnisMedal
    extends CataclysmMedal {
        public IgnisMedal() {
            super("ignis_medal");
        }

        @Override
        public String getDefaultBoundEntityId() {
            return "cataclysm:ignis";
        }

        @Override
        public String getDefaultBoundEntityDisplayName() {
            return "entity.cataclysm.ignis";
        }

        @Override
        public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
            super.m_7373_(stack, world, tooltip, flag);
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.ignis_medal"));
        }
    }

    public static class EnderGuardianMedal
    extends CataclysmMedal {
        public EnderGuardianMedal() {
            super("ender_guardian_medal");
        }

        @Override
        public String getDefaultBoundEntityId() {
            return "cataclysm:ender_guardian";
        }

        @Override
        public String getDefaultBoundEntityDisplayName() {
            return "entity.cataclysm.ender_guardian";
        }

        @Override
        public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
            super.m_7373_(stack, world, tooltip, flag);
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.ender_guardian_medal"));
        }
    }

    public static class AncientRemnantMedal
    extends CataclysmMedal {
        public AncientRemnantMedal() {
            super("ancient_remnant_medal");
        }

        @Override
        public String getDefaultBoundEntityId() {
            return "cataclysm:ancient_remnant";
        }

        @Override
        public String getDefaultBoundEntityDisplayName() {
            return "entity.cataclysm.ancient_remnant";
        }

        public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
            super.m_6883_(stack, world, entity, slot, selected);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!world.f_46443_) {
                    MobEffect curseOfDesertEffect = this.getCurseOfDesertEffect();
                    if (curseOfDesertEffect != null && player.m_21023_(curseOfDesertEffect)) {
                        player.m_21195_(curseOfDesertEffect);
                    }
                    if (player.m_21023_(MobEffects.f_19597_)) {
                        player.m_21195_(MobEffects.f_19597_);
                    }
                    this.handleShiftActiveSkill(player, stack);
                }
            }
        }

        private void handleShiftActiveSkill(Player player, ItemStack stack) {
            if (player.m_6047_() && !this.isOnCooldown(player, stack)) {
                List nearbyLivingEntities = player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_(5.0));
                for (LivingEntity entity : nearbyLivingEntities) {
                    if (entity == player || !entity.m_6084_()) continue;
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2));
                }
                List nearbyProjectiles = player.m_9236_().m_45976_(Projectile.class, player.m_20191_().m_82400_(5.0));
                for (Projectile projectile : nearbyProjectiles) {
                    double deltaZ;
                    double deltaY;
                    double deltaX;
                    double distance;
                    if (!projectile.m_6084_() || !((distance = Math.sqrt((deltaX = projectile.m_20185_() - player.m_20185_()) * deltaX + (deltaY = projectile.m_20186_() - player.m_20186_()) * deltaY + (deltaZ = projectile.m_20189_() - player.m_20189_()) * deltaZ)) > 0.0)) continue;
                    double force = 2.0;
                    deltaX = deltaX / distance * force;
                    deltaY = deltaY / distance * force + 0.3;
                    deltaZ = deltaZ / distance * force;
                    projectile.m_20334_(deltaX, deltaY, deltaZ);
                }
            }
        }

        private boolean isOnCooldown(Player player, ItemStack stack) {
            return player.m_36335_().m_41519_(stack.m_41720_());
        }

        private void setCooldown(Player player, ItemStack stack, int ticks) {
            player.m_36335_().m_41524_(stack.m_41720_(), ticks);
        }

        public void onOwnerAttacked(Player owner, ItemStack stack, LivingEntity attacker) {
            if (owner.m_6047_() && !this.isOnCooldown(owner, stack)) {
                MobEffect stunEffect;
                MobEffect curseOfDesertEffect = this.getCurseOfDesertEffect();
                if (curseOfDesertEffect != null) {
                    attacker.m_7292_(new MobEffectInstance(curseOfDesertEffect, 200, 0));
                }
                if ((stunEffect = this.getStunEffect()) != null) {
                    attacker.m_7292_(new MobEffectInstance(stunEffect, 200, 0));
                }
                this.setCooldown(owner, stack, 200);
            }
        }

        private MobEffect getCurseOfDesertEffect() {
            try {
                return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("cataclysm", "curse_of_desert"));
            }
            catch (Exception ignored) {
                return null;
            }
        }

        private MobEffect getStunEffect() {
            try {
                return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("cataclysm", "stun"));
            }
            catch (Exception ignored) {
                return null;
            }
        }

        @Override
        public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
            super.m_7373_(stack, world, tooltip, flag);
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.ancient_remnant_medal"));
        }
    }
}

