/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.compat.cataclysm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.the_last_sword.compat.CompatCheck;
import net.the_last_sword.configuration.TheLastSwordConfigManager;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.util.TheLastSwordLogger;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CataclysmRecipeConfigGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, MedalRecipeData> MEDAL_MAPPING = new HashMap<String, MedalRecipeData>();

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CataclysmRecipeConfigGenerator.handleCataclysmRecipeGeneration());
    }

    public static void handleCataclysmRecipeGeneration() {
        boolean shouldGenerate;
        boolean bl = shouldGenerate = CompatCheck.isCataclysmLoaded() && TheLastSwordConfiguration.isCataclysmCompatEnabled();
        if (shouldGenerate && !CataclysmRecipeConfigGenerator.cataclysmRecipesExistInConfig()) {
            TheLastSwordLogger.info("Detected Cataclysm mod with compatibility enabled, generating recipes to config directory");
            CataclysmRecipeConfigGenerator.generateCataclysmRecipesToConfig();
        } else if (!shouldGenerate && CataclysmRecipeConfigGenerator.cataclysmRecipesExistInConfig()) {
            TheLastSwordLogger.info("Cataclysm compatibility disabled, removing recipes from config directory");
            CataclysmRecipeConfigGenerator.removeCataclysmRecipesFromConfig();
        }
    }

    private static boolean cataclysmRecipesExistInConfig() {
        Path recipesDir = TheLastSwordConfigManager.getRecipesDirectory();
        if (!Files.exists(recipesDir, new LinkOption[0])) {
            return false;
        }
        for (String medalName : MEDAL_MAPPING.keySet()) {
            String fileName = "dragon_crystal_smithing_" + medalName + ".json";
            Path recipeFile = recipesDir.resolve(fileName);
            if (!Files.exists(recipeFile, new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    public static void generateCataclysmRecipesToConfig() {
        Path recipesDir = TheLastSwordConfigManager.getRecipesDirectory();
        if (!Files.exists(recipesDir, new LinkOption[0])) {
            TheLastSwordLogger.warn("Config recipes directory does not exist, cannot generate Cataclysm recipes");
            return;
        }
        CataclysmRecipeConfigGenerator.removeReplacedDragonEggRecipes(recipesDir);
        for (Map.Entry<String, MedalRecipeData> entry : MEDAL_MAPPING.entrySet()) {
            String medalName = entry.getKey();
            MedalRecipeData data = entry.getValue();
            JsonObject recipe = CataclysmRecipeConfigGenerator.createCataclysmMedalRecipe(medalName, data);
            String fileName = "dragon_crystal_smithing_" + medalName + ".json";
            Path recipeFile = recipesDir.resolve(fileName);
            try (FileWriter writer = new FileWriter(recipeFile.toFile());){
                GSON.toJson((JsonElement)recipe, (Appendable)writer);
                TheLastSwordLogger.info("Generated Cataclysm recipe to config: " + fileName);
            }
            catch (IOException e) {
                TheLastSwordLogger.error("Failed to generate Cataclysm recipe: " + fileName, e);
            }
        }
        TheLastSwordLogger.info("Generated " + MEDAL_MAPPING.size() + " Cataclysm medal recipes to config directory");
    }

    public static void removeCataclysmRecipesFromConfig() {
        Path recipesDir = TheLastSwordConfigManager.getRecipesDirectory();
        if (!Files.exists(recipesDir, new LinkOption[0])) {
            return;
        }
        for (String medalName : MEDAL_MAPPING.keySet()) {
            String fileName = "dragon_crystal_smithing_" + medalName + ".json";
            Path recipeFile = recipesDir.resolve(fileName);
            try {
                if (!Files.exists(recipeFile, new LinkOption[0])) continue;
                Files.delete(recipeFile);
                TheLastSwordLogger.info("Removed Cataclysm recipe from config: " + fileName);
            }
            catch (IOException e) {
                TheLastSwordLogger.error("Failed to remove Cataclysm recipe: " + fileName, e);
            }
        }
        CataclysmRecipeConfigGenerator.restoreReplacedDragonEggRecipes(recipesDir);
        TheLastSwordLogger.info("Removed Cataclysm medal recipes and restored dragon egg recipes in config directory");
    }

    private static void removeReplacedDragonEggRecipes(Path recipesDir) {
        HashSet<Integer> replacedLevels = new HashSet<Integer>();
        for (MedalRecipeData data : MEDAL_MAPPING.values()) {
            replacedLevels.add(data.inputLevel);
        }
        Iterator<MedalRecipeData> iterator = replacedLevels.iterator();
        while (iterator.hasNext()) {
            int level = (Integer)((Object)iterator.next());
            String fileName = "dragon_crystal_smithing_level_" + level + ".json";
            Path recipeFile = recipesDir.resolve(fileName);
            try {
                if (!Files.exists(recipeFile, new LinkOption[0])) continue;
                Files.delete(recipeFile);
                TheLastSwordLogger.info("Removed dragon egg recipe: " + fileName);
            }
            catch (IOException e) {
                TheLastSwordLogger.error("Failed to remove dragon egg recipe: " + fileName, e);
            }
        }
        TheLastSwordLogger.info("Removed dragon egg recipes for levels: " + replacedLevels);
    }

    private static void restoreReplacedDragonEggRecipes(Path recipesDir) {
        HashSet<Integer> replacedLevels = new HashSet<Integer>();
        for (MedalRecipeData data : MEDAL_MAPPING.values()) {
            replacedLevels.add(data.inputLevel);
        }
        Iterator<MedalRecipeData> iterator = replacedLevels.iterator();
        while (iterator.hasNext()) {
            int level = (Integer)((Object)iterator.next());
            String fileName = "dragon_crystal_smithing_level_" + level + ".json";
            Path targetFile = recipesDir.resolve(fileName);
            try {
                InputStream inputStream = CataclysmRecipeConfigGenerator.class.getClassLoader().getResourceAsStream("assets/the_last_sword/dragon_crystal_smithing_recipes/" + fileName);
                try {
                    if (inputStream != null) {
                        Files.copy(inputStream, targetFile, StandardCopyOption.REPLACE_EXISTING);
                        TheLastSwordLogger.info("Restored dragon egg recipe: " + fileName);
                        continue;
                    }
                    TheLastSwordLogger.warn("Could not find original dragon egg recipe in assets: " + fileName);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                TheLastSwordLogger.error("Failed to restore dragon egg recipe: " + fileName, e);
            }
        }
        TheLastSwordLogger.info("Restored dragon egg recipes for levels: " + replacedLevels);
    }

    private static JsonObject createCataclysmMedalRecipe(String medalName, MedalRecipeData data) {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "the_last_sword:dragon_crystal_smithing");
        JsonObject template = new JsonObject();
        template.addProperty("item", "the_last_sword:dragon_crystal_upgrade_template");
        recipe.add("template", (JsonElement)template);
        JsonObject input = new JsonObject();
        input.addProperty("item", data.inputItem);
        recipe.add("input", (JsonElement)input);
        recipe.addProperty("inputLevel", (Number)data.inputLevel);
        JsonObject addition = new JsonObject();
        addition.addProperty("item", "the_last_sword:" + medalName);
        recipe.add("addition", (JsonElement)addition);
        JsonObject result = new JsonObject();
        result.addProperty("item", data.resultItem);
        result.addProperty("level", (Number)data.resultLevel);
        recipe.add("result", (JsonElement)result);
        return recipe;
    }

    static {
        MEDAL_MAPPING.put("ender_guardian_medal", new MedalRecipeData("the_last_sword:dragon_crystal_sword", 2, "the_last_sword:dragon_crystal_sword", 3));
        MEDAL_MAPPING.put("the_harbinger_medal", new MedalRecipeData("the_last_sword:dragon_crystal_sword", 2, "the_last_sword:dragon_crystal_sword", 3));
        MEDAL_MAPPING.put("netherite_monstrosity_medal", new MedalRecipeData("the_last_sword:dragon_crystal_sword", 3, "the_last_sword:dragon_crystal_sword", 4));
        MEDAL_MAPPING.put("the_leviathan_medal", new MedalRecipeData("the_last_sword:dragon_crystal_sword", 3, "the_last_sword:dragon_crystal_sword", 4));
        MEDAL_MAPPING.put("ancient_remnant_medal", new MedalRecipeData("the_last_sword:dragon_crystal_sword", 3, "the_last_sword:dragon_crystal_sword", 4));
        MEDAL_MAPPING.put("maledictus_medal", new MedalRecipeData("the_last_sword:dragon_crystal_sword", 4, "the_last_sword:dragon_crystal_sword", 5));
        MEDAL_MAPPING.put("ignis_medal", new MedalRecipeData("the_last_sword:dragon_crystal_sword", 4, "the_last_sword:dragon_crystal_sword", 5));
        MEDAL_MAPPING.put("scylla_medal", new MedalRecipeData("the_last_sword:dragon_crystal_sword", 4, "the_last_sword:dragon_crystal_sword", 5));
    }

    private static class MedalRecipeData {
        final String inputItem;
        final int inputLevel;
        final String resultItem;
        final int resultLevel;

        MedalRecipeData(String inputItem, int inputLevel, String resultItem, int resultLevel) {
            this.inputItem = inputItem;
            this.inputLevel = inputLevel;
            this.resultItem = resultItem;
            this.resultLevel = resultLevel;
        }
    }
}

