/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.compat.jei;

import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.the_last_sword.TheLastSwordMod;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.compat.jei.TheLastSwordJeiPlugin;
import net.the_last_sword.init.TheLastSwordModMenus;
import net.the_last_sword.network.JEISyncPacket;
import net.the_last_sword.recipe.DragonCrystalSmithingRecipe;
import net.the_last_sword.world.inventory.DragonCrystalSmithingTableGuiMenu;

public class DragonCrystalSmithingRecipeTransferHandler
implements IRecipeTransferHandler<DragonCrystalSmithingTableGuiMenu, DragonCrystalSmithingRecipe> {
    private IRecipeTransferHandlerHelper transferHelper;

    public Class<? extends DragonCrystalSmithingTableGuiMenu> getContainerClass() {
        return DragonCrystalSmithingTableGuiMenu.class;
    }

    public Optional<MenuType<DragonCrystalSmithingTableGuiMenu>> getMenuType() {
        return Optional.of((MenuType)TheLastSwordModMenus.DRAGON_CRYSTAL_SMITHING_TABLE_GUI.get());
    }

    public RecipeType<DragonCrystalSmithingRecipe> getRecipeType() {
        return TheLastSwordJeiPlugin.DRAGON_CRYSTAL_SMITHING_TYPE;
    }

    public DragonCrystalSmithingRecipeTransferHandler(IRecipeTransferHandlerHelper transferHelper) {
        this.transferHelper = transferHelper;
    }

    public IRecipeTransferError transferRecipe(DragonCrystalSmithingTableGuiMenu container, DragonCrystalSmithingRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        IRecipeTransferError error = this.checkRequiredItems(container, player, recipe);
        if (error != null) {
            return error;
        }
        if (doTransfer) {
            this.transferItems(container, recipe, player);
            container.checkRecipe();
            container.m_38946_();
        }
        return null;
    }

    private IRecipeTransferError checkRequiredItems(DragonCrystalSmithingTableGuiMenu container, Player player, DragonCrystalSmithingRecipe recipe) {
        if (!this.hasItemInContainerOrInventory(container, player, recipe.getTemplate().m_43908_(), 0, -1)) {
            return this.transferHelper.createUserErrorWithTooltip((Component)Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.missing.template"));
        }
        if (!this.hasItemWithLevelInContainerOrInventory(container, player, recipe.getInput().m_43908_(), 1, recipe.inputLevel)) {
            return this.transferHelper.createUserErrorWithTooltip((Component)Component.m_237110_((String)"jei.tooltip.error.recipe.transfer.missing.input.level", (Object[])new Object[]{recipe.inputLevel}));
        }
        if (!this.hasItemInContainerOrInventory(container, player, recipe.getAddition().m_43908_(), 2, -1)) {
            return this.transferHelper.createUserErrorWithTooltip((Component)Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.missing.addition"));
        }
        return null;
    }

    private boolean hasRequiredItems(DragonCrystalSmithingTableGuiMenu container, Player player, DragonCrystalSmithingRecipe recipe) {
        return this.checkRequiredItems(container, player, recipe) == null;
    }

    private boolean hasItemInContainerOrInventory(DragonCrystalSmithingTableGuiMenu container, Player player, ItemStack[] possibleItems, int containerSlot, int requiredLevel) {
        ItemStack containerStack = container.m_38853_(containerSlot).m_7993_();
        if (!containerStack.m_41619_()) {
            for (ItemStack possibleItem : possibleItems) {
                if (!ItemStack.m_41656_((ItemStack)containerStack, (ItemStack)possibleItem)) continue;
                if (requiredLevel < 0) {
                    return true;
                }
                int itemLevel = this.getItemLevel(containerStack);
                if (itemLevel != requiredLevel) continue;
                return true;
            }
        }
        if (requiredLevel < 0) {
            return this.hasItem(player, possibleItems);
        }
        return this.hasItemWithLevel(player, possibleItems, requiredLevel);
    }

    private boolean hasItemWithLevelInContainerOrInventory(DragonCrystalSmithingTableGuiMenu container, Player player, ItemStack[] possibleItems, int containerSlot, int requiredLevel) {
        return this.hasItemInContainerOrInventory(container, player, possibleItems, containerSlot, requiredLevel);
    }

    private boolean hasItem(Player player, ItemStack[] possibleItems) {
        for (ItemStack possibleItem : possibleItems) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack invStack = player.m_150109_().m_8020_(i);
                if (invStack.m_41619_() || !ItemStack.m_41656_((ItemStack)invStack, (ItemStack)possibleItem) || invStack.m_41613_() < 1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasItemWithLevel(Player player, ItemStack[] possibleItems, int requiredLevel) {
        for (ItemStack possibleItem : possibleItems) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                int itemLevel;
                ItemStack invStack = player.m_150109_().m_8020_(i);
                if (invStack.m_41619_() || !ItemStack.m_41656_((ItemStack)invStack, (ItemStack)possibleItem) || (itemLevel = this.getItemLevel(invStack)) != requiredLevel) continue;
                return true;
            }
        }
        return false;
    }

    private int getItemLevel(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("level")) {
            return itemStack.m_41783_().m_128451_("level");
        }
        if (itemStack.getCapability(ItemCapability.LEVEL_CAPABILITY).isPresent()) {
            return itemStack.getCapability(ItemCapability.LEVEL_CAPABILITY).map(cap -> cap.getLevel()).orElse(0);
        }
        return 0;
    }

    private void transferItems(DragonCrystalSmithingTableGuiMenu container, DragonCrystalSmithingRecipe recipe, Player player) {
        boolean anySlotChanged;
        ItemStack slot2Item;
        ItemStack slot1Item;
        boolean[] slotsChanged = new boolean[3];
        ItemStack slot0Item = container.m_38853_(0).m_7993_();
        if (slot0Item.m_41619_()) {
            this.findAndPlaceItem(container, player, recipe.getTemplate().m_43908_(), 0, -1);
            slotsChanged[0] = true;
        }
        if ((slot1Item = container.m_38853_(1).m_7993_()).m_41619_()) {
            this.findAndPlaceItemWithLevel(container, player, recipe.getInput().m_43908_(), 1, recipe.inputLevel);
            slotsChanged[1] = true;
        }
        if ((slot2Item = container.m_38853_(2).m_7993_()).m_41619_()) {
            this.findAndPlaceItem(container, player, recipe.getAddition().m_43908_(), 2, -1);
            slotsChanged[2] = true;
        }
        container.m_38946_();
        boolean bl = anySlotChanged = slotsChanged[0] || slotsChanged[1] || slotsChanged[2];
        if (anySlotChanged && container.world != null && container.world.m_5776_()) {
            ItemStack syncSlot0 = container.m_38853_(0).m_7993_();
            ItemStack syncSlot1 = container.m_38853_(1).m_7993_();
            ItemStack syncSlot2 = container.m_38853_(2).m_7993_();
            TheLastSwordMod.PACKET_HANDLER.sendToServer((Object)new JEISyncPacket(container.x, container.y, container.z, syncSlot0, syncSlot1, syncSlot2));
        }
    }

    private void findAndPlaceItem(DragonCrystalSmithingTableGuiMenu container, Player player, ItemStack[] possibleItems, int targetSlot, int requiredLevel) {
        for (ItemStack possibleItem : possibleItems) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                int itemLevel;
                ItemStack invStack = player.m_150109_().m_8020_(i);
                if (invStack.m_41619_() || !ItemStack.m_41656_((ItemStack)invStack, (ItemStack)possibleItem) || requiredLevel >= 0 && (itemLevel = this.getItemLevel(invStack)) != requiredLevel) continue;
                ItemStack singleItem = invStack.m_41777_();
                singleItem.m_41764_(1);
                container.m_38853_(targetSlot).m_269060_(singleItem);
                container.m_38853_(targetSlot).m_6654_();
                invStack.m_41774_(1);
                if (invStack.m_41619_()) {
                    player.m_150109_().m_6836_(i, ItemStack.f_41583_);
                }
                return;
            }
        }
    }

    private void findAndPlaceItemWithLevel(DragonCrystalSmithingTableGuiMenu container, Player player, ItemStack[] possibleItems, int targetSlot, int requiredLevel) {
        this.findAndPlaceItem(container, player, possibleItems, targetSlot, requiredLevel);
    }
}

