/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.compat.jei;

import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.the_last_sword.compat.jei.DragonCrystalSmithingCategory;
import net.the_last_sword.compat.jei.DragonCrystalSmithingRecipeTransferHandler;
import net.the_last_sword.compat.jei.JEIRecipeSyncHandler;
import net.the_last_sword.init.TheLastSwordModBlocks;
import net.the_last_sword.recipe.ConfigDragonCrystalSmithingManager;
import net.the_last_sword.recipe.DragonCrystalSmithingRecipe;
import net.the_last_sword.util.TheLastSwordLogger;

@JeiPlugin
public class TheLastSwordJeiPlugin
implements IModPlugin {
    private static IJeiRuntime jeiRuntime;
    private static boolean syncHandlerRegistered;
    public static final RecipeType<DragonCrystalSmithingRecipe> DRAGON_CRYSTAL_SMITHING_TYPE;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("the_last_sword", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new DragonCrystalSmithingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ConfigDragonCrystalSmithingManager.reloadRecipes();
        List<DragonCrystalSmithingRecipe> recipes = ConfigDragonCrystalSmithingManager.getAllRecipes();
        List sortedRecipes = recipes.stream().sorted((recipe1, recipe2) -> Integer.compare(recipe1.inputLevel, recipe2.inputLevel)).collect(Collectors.toList());
        TheLastSwordLogger.info("Registering {} Dragon Crystal Smithing recipes in JEI", sortedRecipes.size());
        registration.addRecipes(DRAGON_CRYSTAL_SMITHING_TYPE, sortedRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TheLastSwordModBlocks.DRAGON_CRYSTAL_SMITHING_TABLE.get()), new RecipeType[]{DRAGON_CRYSTAL_SMITHING_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new DragonCrystalSmithingRecipeTransferHandler(registration.getTransferHelper()), DRAGON_CRYSTAL_SMITHING_TYPE);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        block5: {
            TheLastSwordJeiPlugin.jeiRuntime = jeiRuntime;
            JEIRecipeSyncHandler.setJeiRuntime(jeiRuntime);
            if (!syncHandlerRegistered) {
                try {
                    FMLJavaModLoadingContext modLoadingContext = FMLJavaModLoadingContext.get();
                    if (modLoadingContext != null) {
                        modLoadingContext.getModEventBus().register(JEIRecipeSyncHandler.class);
                        syncHandlerRegistered = true;
                        TheLastSwordLogger.info("Successfully registered JEI recipe sync handler to mod event bus");
                        break block5;
                    }
                    TheLastSwordLogger.warn("FMLJavaModLoadingContext not available during JEI runtime initialization, config sync may not work properly");
                }
                catch (Exception e) {
                    TheLastSwordLogger.error("Failed to register JEI recipe sync handler to mod event bus: {}", e.getMessage());
                }
            } else {
                TheLastSwordLogger.info("JEI recipe sync handler already registered");
            }
        }
    }

    public static void reloadJeiRecipes() {
        if (jeiRuntime != null) {
            try {
                List<DragonCrystalSmithingRecipe> recipes = ConfigDragonCrystalSmithingManager.getAllRecipes();
                List sortedRecipes = recipes.stream().sorted((recipe1, recipe2) -> Integer.compare(recipe1.inputLevel, recipe2.inputLevel)).collect(Collectors.toList());
                jeiRuntime.getRecipeManager().addRecipes(DRAGON_CRYSTAL_SMITHING_TYPE, sortedRecipes);
                TheLastSwordLogger.info("JEI recipes reloaded successfully, total recipes: {}", sortedRecipes.size());
            }
            catch (Exception e) {
                TheLastSwordLogger.error("Failed to reload JEI recipes: {}", e.getMessage());
            }
        }
    }

    static {
        syncHandlerRegistered = false;
        DRAGON_CRYSTAL_SMITHING_TYPE = RecipeType.create((String)"the_last_sword", (String)"dragon_crystal_smithing", DragonCrystalSmithingRecipe.class);
    }
}

