/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.configuration;

import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.the_last_sword.compat.CompatCheck;
import net.the_last_sword.compat.cataclysm.CataclysmRecipeConfigGenerator;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigUpdateHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean lastCataclysmConfigState = false;

    @SubscribeEvent
    public static void onConfigReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getModId().equals("the_last_sword")) {
            ConfigUpdateHandler.handleCataclysmConfigChange();
        }
    }

    @SubscribeEvent
    public static void onConfigLoading(ModConfigEvent.Loading event) {
        if (event.getConfig().getModId().equals("the_last_sword")) {
            lastCataclysmConfigState = CompatCheck.isCataclysmLoaded() && TheLastSwordConfiguration.isCataclysmCompatEnabled();
            CataclysmRecipeConfigGenerator.handleCataclysmRecipeGeneration();
        }
    }

    private static void handleCataclysmConfigChange() {
        boolean currentState;
        boolean bl = currentState = CompatCheck.isCataclysmLoaded() && TheLastSwordConfiguration.isCataclysmCompatEnabled();
        if (currentState != lastCataclysmConfigState) {
            CataclysmRecipeConfigGenerator.handleCataclysmRecipeGeneration();
            lastCataclysmConfigState = currentState;
            LOGGER.info("[THE LAST SWORD]: Recipe configuration changed. Use '/reload' command to apply changes.");
        }
    }
}

