/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class TheLastSwordConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_UNSAFE_CODE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_RADICAL_LOGIC;
    public static ForgeConfigSpec.ConfigValue<Double> INCREASE_VALUE;
    public static ForgeConfigSpec.ConfigValue<Double> INCREASE_VALUE_HIGH_LEVEL;
    public static ForgeConfigSpec.ConfigValue<Boolean> BLOCK_CANCEL_USE;
    public static ForgeConfigSpec.ConfigValue<Boolean> ATTACK_VILLAGERS;
    public static ForgeConfigSpec.ConfigValue<Boolean> ATTACK_ANIMALS;
    public static ForgeConfigSpec.ConfigValue<Boolean> ATTACK_TAMED;
    public static ForgeConfigSpec.ConfigValue<Boolean> ATTACK_PLAYERS;
    public static ForgeConfigSpec.ConfigValue<Boolean> ATTACK_GOLEMS;
    public static ForgeConfigSpec.ConfigValue<Boolean> ATTACK_NEUTRAL;
    public static ForgeConfigSpec.ConfigValue<Integer> DRAGON_SWORD_SUMMON_COOLDOWN;
    public static ForgeConfigSpec.ConfigValue<Double> DRAGON_SWORD_SHIELD_MULTIPLIER;
    public static ForgeConfigSpec.ConfigValue<Double> ABSOLUTE_DESTRUCTION_MULTIPLIER;
    public static ForgeConfigSpec.ConfigValue<Double> THE_LAST_END_SWORD_SHIELD_MULTIPLIER;
    public static ForgeConfigSpec.ConfigValue<Boolean> ALLOW_FLYING;
    public static ForgeConfigSpec.ConfigValue<Boolean> SUPER_DESTROY;
    public static ForgeConfigSpec.ConfigValue<Integer> MINING_RADIUS;
    public static ForgeConfigSpec.ConfigValue<Integer> THE_LAST_END_SWORD_SUMMON_COOLDOWN;
    public static ForgeConfigSpec.ConfigValue<Double> ARMOR_LEVEL_ARMOR_INCREASE;
    public static ForgeConfigSpec.ConfigValue<Double> ARMOR_LEVEL_TOUGHNESS_INCREASE;
    public static ForgeConfigSpec.ConfigValue<Double> ARMOR_LEVEL_HEALTH_INCREASE;
    public static ForgeConfigSpec.ConfigValue<Boolean> ENABLE_NIGHT_VISION;
    public static ForgeConfigSpec.ConfigValue<Integer> JUSTIFIED_DEFENCE_TICK;
    public static ForgeConfigSpec.ConfigValue<Double> ARMOR_LEVEL_JUSTIFIED_DEFENCE_INCREASE;
    public static ForgeConfigSpec.ConfigValue<Double> DRAGON_ARMOR_LEVEL_ARMOR_INCREASE;
    public static ForgeConfigSpec.ConfigValue<Double> DRAGON_ARMOR_LEVEL_TOUGHNESS_INCREASE;
    public static ForgeConfigSpec.ConfigValue<Double> DRAGON_ARMOR_LEVEL_HEALTH_INCREASE;
    public static ForgeConfigSpec.ConfigValue<Boolean> DRAGON_ARMOR_ENABLE_NIGHT_VISION;
    public static ForgeConfigSpec.ConfigValue<Double> DRAGON_ARMOR_LEVEL_JUSTIFIED_DEFENCE_INCREASE;
    public static ForgeConfigSpec.ConfigValue<Integer> DRAGON_ARMOR_MAX_ENERGY;
    public static ForgeConfigSpec.ConfigValue<Boolean> DRAGON_ARMOR_ENABLE_HUD;
    public static final ForgeConfigSpec.ConfigValue<Double> CUSTOM_HEALTH_DAMAGE_REDUCTION;
    public static final ForgeConfigSpec.ConfigValue<Double> MAX_DAMAGE_PER_HIT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ALL_THINGS_END;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_BATTLE_MUSIC;
    public static final ForgeConfigSpec.ConfigValue<Double> SWORD_WRAITH_HEALTH_PER_LEVEL;
    public static final ForgeConfigSpec.ConfigValue<Double> SWORD_WRAITH_ATTACK_PER_LEVEL;
    public static final ForgeConfigSpec.ConfigValue<Double> SWORD_WRAITH_HEALTH_PER_HIGH_LEVEL;
    public static final ForgeConfigSpec.ConfigValue<Double> SWORD_WRAITH_ATTACK_PER_HIGH_LEVEL;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SWORD_WRAITH_FRIENDLY_FIRE_PROTECTION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SWORD_WRAITH_AS_THE_LAST_END_ENTITY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SWORD_WRAITH_ABSOLUTE_DESTRUCTION_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Double> SWORD_WRAITH_ABSOLUTE_DESTRUCTION_MULTIPLIER_LOW;
    public static final ForgeConfigSpec.ConfigValue<Double> SWORD_WRAITH_ABSOLUTE_DESTRUCTION_MULTIPLIER_MID;
    public static final ForgeConfigSpec.ConfigValue<Double> SWORD_WRAITH_ABSOLUTE_DESTRUCTION_MULTIPLIER_HIGH;
    public static final ForgeConfigSpec.ConfigValue<Boolean> VOID_ENCHANTMENT_PARTICLE_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<Double> VOID_ENCHANTMENT_DAMAGE_PERCENTAGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> PHASING_BREAK_BLOCKS_ON_END;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DROP_DRAGON_EGG;
    public static final ForgeConfigSpec.ConfigValue<Boolean> MULTIPLE_DRAGON_EGGS;
    public static final ForgeConfigSpec.ConfigValue<Integer> DRAGON_EGG_RADIUS;
    public static final ForgeConfigSpec.ConfigValue<Integer> DRAGON_EGG_AMOUNT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GIVE_EGG_TO_ABSENT_PLAYERS;
    public static final ForgeConfigSpec.ConfigValue<Integer> MAX_DRAGON_LEVEL;
    public static final ForgeConfigSpec.ConfigValue<Double> DRAGON_HEALTH_INCREASE_VALUE;
    public static final ForgeConfigSpec.ConfigValue<Double> DRAGON_HEALTH_INCREASE_VALUE_HIGH_LEVEL;
    public static final ForgeConfigSpec.ConfigValue<Double> DRAGON_ARMOR_INCREASE_VALUE;
    public static final ForgeConfigSpec.ConfigValue<Double> DRAGON_ARMOR_INCREASE_VALUE_HIGH_LEVEL;
    public static final ForgeConfigSpec.ConfigValue<Double> DRAGON_ATTACK_INCREASE_VALUE;
    public static final ForgeConfigSpec.ConfigValue<Double> DRAGON_ATTACK_INCREASE_VALUE_HIGH_LEVEL;
    public static final ForgeConfigSpec.ConfigValue<Boolean> HEAL_NEGATION;
    public static ForgeConfigSpec.ConfigValue<Integer> REVIVE_BAN_TIME;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DIE_MESSAGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> THE_LAST_END_DEAD_PARTICLE_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_CATACLYSM_COMPAT;

    public static double getIncreaseValueSafely() {
        try {
            return INCREASE_VALUE != null ? (Double)INCREASE_VALUE.get() : 200.0;
        }
        catch (IllegalStateException e) {
            return 200.0;
        }
    }

    public static double getIncreaseValueHighLevelSafely() {
        try {
            return INCREASE_VALUE_HIGH_LEVEL != null ? (Double)INCREASE_VALUE_HIGH_LEVEL.get() : 1024.0;
        }
        catch (IllegalStateException e) {
            return 1024.0;
        }
    }

    public static boolean getAllowFlyingSafely() {
        try {
            return ALLOW_FLYING != null ? (Boolean)ALLOW_FLYING.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static boolean getAttackVillagersSafely() {
        try {
            return ATTACK_VILLAGERS != null ? (Boolean)ATTACK_VILLAGERS.get() : false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean getAttackAnimalsSafely() {
        try {
            return ATTACK_ANIMALS != null ? (Boolean)ATTACK_ANIMALS.get() : false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean getAttackTamedSafely() {
        try {
            return ATTACK_TAMED != null ? (Boolean)ATTACK_TAMED.get() : false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean getAttackPlayersSafely() {
        try {
            return ATTACK_PLAYERS != null ? (Boolean)ATTACK_PLAYERS.get() : false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean getAttackGolemsSafely() {
        try {
            return ATTACK_GOLEMS != null ? (Boolean)ATTACK_GOLEMS.get() : false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean getAttackNeutralSafely() {
        try {
            return ATTACK_NEUTRAL != null ? (Boolean)ATTACK_NEUTRAL.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static double getAbsoluteDestructionMultiplierSafely() {
        try {
            return ABSOLUTE_DESTRUCTION_MULTIPLIER != null ? (Double)ABSOLUTE_DESTRUCTION_MULTIPLIER.get() : 0.5;
        }
        catch (IllegalStateException e) {
            return 0.5;
        }
    }

    public static double getDragonSwordShieldMultiplierSafely() {
        try {
            return DRAGON_SWORD_SHIELD_MULTIPLIER != null ? (Double)DRAGON_SWORD_SHIELD_MULTIPLIER.get() : 0.05;
        }
        catch (IllegalStateException e) {
            return 0.01;
        }
    }

    public static double getTheLastEndSwordShieldMultiplierSafely() {
        try {
            return THE_LAST_END_SWORD_SHIELD_MULTIPLIER != null ? (Double)THE_LAST_END_SWORD_SHIELD_MULTIPLIER.get() : 0.05;
        }
        catch (IllegalStateException e) {
            return 0.05;
        }
    }

    public static boolean getBlockCancelUseSafely() {
        try {
            return BLOCK_CANCEL_USE != null ? (Boolean)BLOCK_CANCEL_USE.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static int getMiningRadiusSafely() {
        try {
            return MINING_RADIUS != null ? (Integer)MINING_RADIUS.get() : 3;
        }
        catch (IllegalStateException e) {
            return 3;
        }
    }

    public static double getCustomHealthDamageReductionSafely() {
        try {
            return CUSTOM_HEALTH_DAMAGE_REDUCTION != null ? (Double)CUSTOM_HEALTH_DAMAGE_REDUCTION.get() : 0.05;
        }
        catch (IllegalStateException e) {
            return 0.05;
        }
    }

    public static boolean getEnableUnsafeCodeSafely() {
        try {
            return ENABLE_UNSAFE_CODE != null ? (Boolean)ENABLE_UNSAFE_CODE.get() : false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean getEnableRadicalLogicSafely() {
        try {
            return ENABLE_RADICAL_LOGIC != null ? (Boolean)ENABLE_RADICAL_LOGIC.get() : false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean getEnableAggressiveHealthDetectionSafely() {
        try {
            return ENABLE_RADICAL_LOGIC != null ? (Boolean)ENABLE_RADICAL_LOGIC.get() : false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean getHealNegationSafely() {
        try {
            return HEAL_NEGATION != null ? (Boolean)HEAL_NEGATION.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static double getArmorLevelArmorIncreaseSafely() {
        try {
            return ARMOR_LEVEL_ARMOR_INCREASE != null ? (Double)ARMOR_LEVEL_ARMOR_INCREASE.get() : 2.0;
        }
        catch (IllegalStateException e) {
            return 2.0;
        }
    }

    public static double getArmorLevelToughnessIncreaseSafely() {
        try {
            return ARMOR_LEVEL_TOUGHNESS_INCREASE != null ? (Double)ARMOR_LEVEL_TOUGHNESS_INCREASE.get() : 2.0;
        }
        catch (IllegalStateException e) {
            return 2.0;
        }
    }

    public static double getArmorLevelHealthIncreaseSafely() {
        try {
            return ARMOR_LEVEL_HEALTH_INCREASE != null ? (Double)ARMOR_LEVEL_HEALTH_INCREASE.get() : 1.0;
        }
        catch (IllegalStateException e) {
            return 1.0;
        }
    }

    public static boolean getEnableNightVisionSafely() {
        try {
            return ENABLE_NIGHT_VISION != null ? (Boolean)ENABLE_NIGHT_VISION.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static double getDragonArmorLevelArmorIncreaseSafely() {
        try {
            return DRAGON_ARMOR_LEVEL_ARMOR_INCREASE != null ? (Double)DRAGON_ARMOR_LEVEL_ARMOR_INCREASE.get() : 4.0;
        }
        catch (IllegalStateException e) {
            return 4.0;
        }
    }

    public static double getDragonArmorLevelToughnessIncreaseSafely() {
        try {
            return DRAGON_ARMOR_LEVEL_TOUGHNESS_INCREASE != null ? (Double)DRAGON_ARMOR_LEVEL_TOUGHNESS_INCREASE.get() : 4.0;
        }
        catch (IllegalStateException e) {
            return 4.0;
        }
    }

    public static double getDragonArmorLevelHealthIncreaseSafely() {
        try {
            return DRAGON_ARMOR_LEVEL_HEALTH_INCREASE != null ? (Double)DRAGON_ARMOR_LEVEL_HEALTH_INCREASE.get() : 2.0;
        }
        catch (IllegalStateException e) {
            return 2.0;
        }
    }

    public static boolean getDragonArmorEnableNightVisionSafely() {
        try {
            return DRAGON_ARMOR_ENABLE_NIGHT_VISION != null ? (Boolean)DRAGON_ARMOR_ENABLE_NIGHT_VISION.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static double getDragonArmorLevelJustifiedDefenceIncreaseSafely() {
        try {
            return DRAGON_ARMOR_LEVEL_JUSTIFIED_DEFENCE_INCREASE != null ? (Double)DRAGON_ARMOR_LEVEL_JUSTIFIED_DEFENCE_INCREASE.get() : 2.0;
        }
        catch (IllegalStateException e) {
            return 2.0;
        }
    }

    public static boolean getEnableAllThingsEndSafely() {
        try {
            return ENABLE_ALL_THINGS_END != null ? (Boolean)ENABLE_ALL_THINGS_END.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static int getReviveBanTimeSafely() {
        try {
            return REVIVE_BAN_TIME != null ? (Integer)REVIVE_BAN_TIME.get() : 5;
        }
        catch (IllegalStateException e) {
            return 5;
        }
    }

    public static boolean getTheLastEndDeadParticleEffectsSafely() {
        try {
            return THE_LAST_END_DEAD_PARTICLE_EFFECTS != null ? (Boolean)THE_LAST_END_DEAD_PARTICLE_EFFECTS.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static boolean isCataclysmCompatEnabled() {
        try {
            return ENABLE_CATACLYSM_COMPAT != null ? (Boolean)ENABLE_CATACLYSM_COMPAT.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static double getSwordWraithHealthPerLevelSafely() {
        try {
            return SWORD_WRAITH_HEALTH_PER_LEVEL != null ? (Double)SWORD_WRAITH_HEALTH_PER_LEVEL.get() : 100.0;
        }
        catch (IllegalStateException e) {
            return 100.0;
        }
    }

    public static double getSwordWraithAttackPerLevelSafely() {
        try {
            return SWORD_WRAITH_ATTACK_PER_LEVEL != null ? (Double)SWORD_WRAITH_ATTACK_PER_LEVEL.get() : 5.0;
        }
        catch (IllegalStateException e) {
            return 5.0;
        }
    }

    public static double getSwordWraithHealthPerHighLevelSafely() {
        try {
            return SWORD_WRAITH_HEALTH_PER_HIGH_LEVEL != null ? (Double)SWORD_WRAITH_HEALTH_PER_HIGH_LEVEL.get() : 200.0;
        }
        catch (IllegalStateException e) {
            return 200.0;
        }
    }

    public static double getSwordWraithAttackPerHighLevelSafely() {
        try {
            return SWORD_WRAITH_ATTACK_PER_HIGH_LEVEL != null ? (Double)SWORD_WRAITH_ATTACK_PER_HIGH_LEVEL.get() : 10.0;
        }
        catch (IllegalStateException e) {
            return 10.0;
        }
    }

    public static boolean getSwordWraithFriendlyFireProtectionSafely() {
        try {
            return SWORD_WRAITH_FRIENDLY_FIRE_PROTECTION != null ? (Boolean)SWORD_WRAITH_FRIENDLY_FIRE_PROTECTION.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static boolean getSwordWraithAsEndEntitySafely() {
        try {
            return SWORD_WRAITH_AS_THE_LAST_END_ENTITY != null ? (Boolean)SWORD_WRAITH_AS_THE_LAST_END_ENTITY.get() : false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean getSwordWraithAbsoluteDestructionDamageSafely() {
        try {
            return SWORD_WRAITH_ABSOLUTE_DESTRUCTION_DAMAGE != null ? (Boolean)SWORD_WRAITH_ABSOLUTE_DESTRUCTION_DAMAGE.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static double getSwordWraithAbsoluteDestructionMultiplierLowSafely() {
        try {
            return SWORD_WRAITH_ABSOLUTE_DESTRUCTION_MULTIPLIER_LOW != null ? (Double)SWORD_WRAITH_ABSOLUTE_DESTRUCTION_MULTIPLIER_LOW.get() : 0.1;
        }
        catch (IllegalStateException e) {
            return 0.1;
        }
    }

    public static double getSwordWraithAbsoluteDestructionMultiplierMidSafely() {
        try {
            return SWORD_WRAITH_ABSOLUTE_DESTRUCTION_MULTIPLIER_MID != null ? (Double)SWORD_WRAITH_ABSOLUTE_DESTRUCTION_MULTIPLIER_MID.get() : 0.5;
        }
        catch (IllegalStateException e) {
            return 0.5;
        }
    }

    public static double getSwordWraithAbsoluteDestructionMultiplierHighSafely() {
        try {
            return SWORD_WRAITH_ABSOLUTE_DESTRUCTION_MULTIPLIER_HIGH != null ? (Double)SWORD_WRAITH_ABSOLUTE_DESTRUCTION_MULTIPLIER_HIGH.get() : 1.0;
        }
        catch (IllegalStateException e) {
            return 1.0;
        }
    }

    public static int getDragonSwordSummonCooldownSafely() {
        try {
            return DRAGON_SWORD_SUMMON_COOLDOWN != null ? (Integer)DRAGON_SWORD_SUMMON_COOLDOWN.get() : 1200;
        }
        catch (IllegalStateException e) {
            return 1200;
        }
    }

    public static int getTheLastEndSwordSummonCooldownSafely() {
        try {
            return THE_LAST_END_SWORD_SUMMON_COOLDOWN != null ? (Integer)THE_LAST_END_SWORD_SUMMON_COOLDOWN.get() : 600;
        }
        catch (IllegalStateException e) {
            return 600;
        }
    }

    public static int getDragonArmorMaxEnergySafely() {
        try {
            return DRAGON_ARMOR_MAX_ENERGY != null ? (Integer)DRAGON_ARMOR_MAX_ENERGY.get() : 0x100000;
        }
        catch (IllegalStateException e) {
            return 0x100000;
        }
    }

    public static boolean getPhasingBreakBlocksOnEndSafely() {
        try {
            return PHASING_BREAK_BLOCKS_ON_END != null ? (Boolean)PHASING_BREAK_BLOCKS_ON_END.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static boolean getDragonArmorEnableHudSafely() {
        try {
            return DRAGON_ARMOR_ENABLE_HUD != null ? (Boolean)DRAGON_ARMOR_ENABLE_HUD.get() : true;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    static {
        ENABLE_UNSAFE_CODE = BUILDER.comment("Allow unsafe code in this mod to be enabled, which will enhance the mod's strength but at the cost of lower robustness.").define("Enable Unsafe Code", false);
        ENABLE_RADICAL_LOGIC = BUILDER.comment(new String[]{"This will enable radical code logic that provides broader defensive and offensive capabilities.", "It will cause more compatibility disruption than Unsafe code, but can achieve power far beyond normal mods."}).define("Enable Radical Logic", false);
        BUILDER.push("Items");
        BUILDER.push("Sword");
        BUILDER.push("Generic");
        INCREASE_VALUE = BUILDER.comment("Damage increased per level of upgrade when level<6.").define("Increase Value", (Object)200.0);
        INCREASE_VALUE_HIGH_LEVEL = BUILDER.comment("Damage increased per level of upgrade when level>=6.").define("Increase Value High Level", (Object)1024.0);
        BLOCK_CANCEL_USE = BUILDER.comment("Cancel sword right-click usage by blocking with shield").define("Block Cancel Use", true);
        ATTACK_VILLAGERS = BUILDER.comment("Allows attacking villagers.").define("Attack Villagers", false);
        ATTACK_ANIMALS = BUILDER.comment("Allows attacking animals.").define("Attack Animals", false);
        ATTACK_TAMED = BUILDER.comment("Allows attacking tamed entities.").define("Attack Tamed", false);
        ATTACK_PLAYERS = BUILDER.comment("Allows attacking players.").define("Attack Players", false);
        ATTACK_GOLEMS = BUILDER.comment("Allows attacking golems.").define("Attack Golems", false);
        ATTACK_NEUTRAL = BUILDER.comment("Allows attacking neutral mobs.").define("Attack Neutral", true);
        BUILDER.pop();
        BUILDER.push("Dragon Sword");
        DRAGON_SWORD_SUMMON_COOLDOWN = BUILDER.comment(new String[]{"Cooldown time for Dragon Sword summoning mode in ticks", "20 ticks = 1 second, so 1200 ticks = 60 seconds", "This cooldown applies when summoning or recalling wraiths with Dragon Sword"}).defineInRange("Summon Cooldown", 1200, 0, Integer.MAX_VALUE);
        DRAGON_SWORD_SHIELD_MULTIPLIER = BUILDER.comment(new String[]{"Multiplier for the absorption shield when recalling Dragon Sword Wraith", "The shield strength is calculated as: wraith remaining health * multiplier"}).define("Shield Multiplier", (Object)0.05);
        BUILDER.pop();
        BUILDER.push("The Last End Sword");
        ABSOLUTE_DESTRUCTION_MULTIPLIER = BUILDER.comment("Multiplier for absolute destruction damage (extra damage * multiplier).").define("Absolute Destruction Multiplier", (Object)0.5);
        THE_LAST_END_SWORD_SHIELD_MULTIPLIER = BUILDER.comment("Multiplier for the absorption shield when recalling The Last End Sword Wraith.").define("Shield Multiplier", (Object)0.05);
        ALLOW_FLYING = BUILDER.comment("Allows players to fly when holding The Last End Sword.").define("Allow Flying", true);
        SUPER_DESTROY = BUILDER.comment("Force destruction of all blocks.").define("Super Destroy", true);
        MINING_RADIUS = BUILDER.comment("Mining radius for Powerful Mining Mode. Default: 3 (7x7x7 area)").defineInRange("Mining Radius", 3, 1, 12);
        THE_LAST_END_SWORD_SUMMON_COOLDOWN = BUILDER.comment(new String[]{"Cooldown time for The Last End Sword summoning mode in ticks", "20 ticks = 1 second, so 600 ticks = 30 seconds", "This cooldown applies when summoning or recalling wraiths with The Last End Sword"}).defineInRange("Summon Cooldown", 600, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Armor");
        BUILDER.push("Dragon Crystal Armor");
        ARMOR_LEVEL_ARMOR_INCREASE = BUILDER.comment("Defense increase per armor level.").define("Defense Increase Per Level", (Object)2.0);
        ARMOR_LEVEL_TOUGHNESS_INCREASE = BUILDER.comment("Toughness increase per armor level.").define("Toughness Increase Per Level", (Object)2.0);
        ARMOR_LEVEL_HEALTH_INCREASE = BUILDER.comment("Max health increase per armor level.").define("Health Increase Per Level", (Object)1.0);
        ENABLE_NIGHT_VISION = BUILDER.comment("Enables night vision effect when wearing the helmet.").define("Enable Night Vision", true);
        JUSTIFIED_DEFENCE_TICK = BUILDER.comment("Change recovery speed of Justified Defence Shield.").define("Justified Defence Tick", (Object)100);
        ARMOR_LEVEL_JUSTIFIED_DEFENCE_INCREASE = BUILDER.comment("Justified Defence increase per armor level.").define("Justified Defence Increase Per Level", (Object)1.0);
        BUILDER.pop();
        BUILDER.push("Dragon Armor");
        DRAGON_ARMOR_LEVEL_ARMOR_INCREASE = BUILDER.comment("Defense increase per armor level (Dragon Armor).").define("Defense Increase Per Level", (Object)4.0);
        DRAGON_ARMOR_LEVEL_TOUGHNESS_INCREASE = BUILDER.comment("Toughness increase per armor level (Dragon Armor).").define("Toughness Increase Per Level", (Object)4.0);
        DRAGON_ARMOR_LEVEL_HEALTH_INCREASE = BUILDER.comment("Max health increase per armor level (Dragon Armor).").define("Health Increase Per Level", (Object)4.0);
        DRAGON_ARMOR_ENABLE_NIGHT_VISION = BUILDER.comment("Enables night vision effect when wearing the helmet (Dragon Armor).").define("Enable Night Vision", true);
        DRAGON_ARMOR_LEVEL_JUSTIFIED_DEFENCE_INCREASE = BUILDER.comment("Justified Defence increase per armor level (Dragon Armor).").define("Justified Defence Increase Per Level", (Object)2.0);
        DRAGON_ARMOR_MAX_ENERGY = BUILDER.comment("Maximum energy storage capacity for each Dragon Armor piece (FE).").defineInRange("Max Energy Capacity", 0x100000, 0, Integer.MAX_VALUE);
        DRAGON_ARMOR_ENABLE_HUD = BUILDER.comment("Enable the HUD effect when wearing full Dragon Armor set.").define("Enable HUD Overlay", true);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Entities");
        BUILDER.push("The Last End Entity");
        CUSTOM_HEALTH_DAMAGE_REDUCTION = BUILDER.comment("Maximum percentage of health that can be lost per hit for entities with custom health.").defineInRange("Custom Health Damage Reduction", 0.05, 0.0, 1.0);
        MAX_DAMAGE_PER_HIT = BUILDER.comment(new String[]{"Maximum absolute damage that can be dealt per hit to protected entities.", "Set to 0 to disable this damage limit."}).defineInRange("Max Damage Per Hit", 20.0, 0.0, Double.MAX_VALUE);
        ENABLE_ALL_THINGS_END = BUILDER.comment(new String[]{"Enable automatic All Things End state activation when detecting powerful attacks.", "When enabled, entities will automatically activate All Things End state when:", "1. Health value doesn't match the real health (powerful health manipulation detected)", "2. Entity is directly removed/killed (instant kill attempt detected)", "This provides adaptive defense against extremely powerful attacks."}).define("Enable All Things End Auto Trigger", true);
        BUILDER.pop();
        BUILDER.push("The Last End Sword Wraith");
        ENABLE_BATTLE_MUSIC = BUILDER.comment("Enable or disable the music played when The Last End Sword Wraith in battle.").define("Enable Spawn Music", true);
        BUILDER.pop();
        BUILDER.push("Sword Wraith");
        SWORD_WRAITH_HEALTH_PER_LEVEL = BUILDER.comment(new String[]{"Health increase per sword level for generic sword wraiths (Level 1-5)", "This value will be multiplied by the sword's level to calculate bonus health."}).defineInRange("Health Per Level", 100.0, 0.0, Double.MAX_VALUE);
        SWORD_WRAITH_ATTACK_PER_LEVEL = BUILDER.comment(new String[]{"Attack damage increase per sword level for generic sword wraiths (Level 1-5)", "This value will be multiplied by the sword's level to calculate bonus attack damage."}).defineInRange("Attack Per Level", 5.0, 0.0, Double.MAX_VALUE);
        SWORD_WRAITH_HEALTH_PER_HIGH_LEVEL = BUILDER.comment(new String[]{"Health increase per sword level for high-level sword wraiths (Level 6+)", "This value will be multiplied by the sword's level to calculate bonus health."}).defineInRange("Health Per High Level", 200.0, 0.0, Double.MAX_VALUE);
        SWORD_WRAITH_ATTACK_PER_HIGH_LEVEL = BUILDER.comment(new String[]{"Attack damage increase per sword level for high-level sword wraiths (Level 6+)", "This value will be multiplied by the sword's level to calculate bonus attack damage."}).defineInRange("Attack Per High Level", 10.0, 0.0, Double.MAX_VALUE);
        SWORD_WRAITH_FRIENDLY_FIRE_PROTECTION = BUILDER.comment(new String[]{"Enable friendly fire protection for sword wraiths from allies", "When enabled, prevents owners and allies from damaging sword wraiths", "Note: Sword wraiths will never attack their owners or allies regardless of this setting"}).define("Friendly Fire Protection", true);
        SWORD_WRAITH_AS_THE_LAST_END_ENTITY = BUILDER.comment(new String[]{"Treat sword wraiths as The Last End Entities with defence levels", "When enabled, summoned wraiths will be registered with defense system based on weapon level", "Defense level mapping: 1-5 weapon level = defence level 1, 6-12 = level 2, 13 = level 2"}).define("Sword Wraith As End Entity", true);
        SWORD_WRAITH_ABSOLUTE_DESTRUCTION_DAMAGE = BUILDER.comment(new String[]{"Enable absolute destruction damage for non-TheLastEndEntity wraiths", "When enabled AND 'Sword Wraith As End Entity' is enabled, wraiths deal bonus absolute destruction damage", "Damage scales with weapon level: 1-5 = 10% attack damage, 6-12 = 50%, 13+ = 100%", "Requires 'Sword Wraith As End Entity' to be enabled to take effect"}).define("Sword Wraith Absolute Destruction Damage", true);
        SWORD_WRAITH_ABSOLUTE_DESTRUCTION_MULTIPLIER_LOW = BUILDER.comment(new String[]{"Absolute destruction damage multiplier for weapon levels 1-5", "Percentage of wraith's attack damage dealt as additional absolute destruction damage", "Default: 0.10 (10% of attack damage)"}).defineInRange("Sword Wraith Absolute Destruction Multiplier (Lv1-5)", 0.1, 0.0, 10.0);
        SWORD_WRAITH_ABSOLUTE_DESTRUCTION_MULTIPLIER_MID = BUILDER.comment(new String[]{"Absolute destruction damage multiplier for weapon levels 6-12", "Percentage of wraith's attack damage dealt as additional absolute destruction damage", "Default: 0.50 (50% of attack damage)"}).defineInRange("Sword Wraith Absolute Destruction Multiplier (Lv6-12)", 0.5, 0.0, 10.0);
        SWORD_WRAITH_ABSOLUTE_DESTRUCTION_MULTIPLIER_HIGH = BUILDER.comment(new String[]{"Absolute destruction damage multiplier for weapon level 13+", "Percentage of wraith's attack damage dealt as additional absolute destruction damage", "Default: 1.00 (100% of attack damage)"}).defineInRange("Sword Wraith Absolute Destruction Multiplier (Lv13+)", 1.0, 0.0, 10.0);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Functions");
        BUILDER.push("Absolute Destruction Damage");
        HEAL_NEGATION = BUILDER.comment("MOBS are prohibited from restoring health").define("Heal Negation", true);
        REVIVE_BAN_TIME = BUILDER.comment("Time (in seconds) to prevent entities killed by The Last End Death from respawning. Set to 0 to disable this feature.").defineInRange("Revive Ban Time", 5, 0, Integer.MAX_VALUE);
        DIE_MESSAGE = BUILDER.comment("Enable or disable message when The Last End Death.").define("Enable Die Message", true);
        THE_LAST_END_DEAD_PARTICLE_EFFECTS = BUILDER.comment("Enable or disable particle effects when The Last End Death.").define("Enable The Last End Dead Particle Effects", true);
        BUILDER.pop();
        BUILDER.push("Buff");
        BUILDER.push("Void Enchanting");
        VOID_ENCHANTMENT_PARTICLE_EFFECTS = BUILDER.comment("Control whether to render particle effects").define("Particle Effects", false);
        VOID_ENCHANTMENT_DAMAGE_PERCENTAGE = BUILDER.comment("The percentage increase in damage by Buff").define("Damage Percentage", (Object)0.2);
        BUILDER.pop();
        BUILDER.push("Phasing");
        PHASING_BREAK_BLOCKS_ON_END = BUILDER.comment(new String[]{"Whether to break suffocating blocks when Phasing effect ends", "This prevents the player from being stuck in blocks after phasing through walls"}).define("Break Blocks On End", true);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Ender Dragon Egg");
        DROP_DRAGON_EGG = BUILDER.comment("Controls whether the Ender Dragon drops a dragon egg upon death.").define("Drop Dragon Egg", true);
        MULTIPLE_DRAGON_EGGS = BUILDER.comment("Controls whether multiple dragon eggs are given to players who dealt significant damage.").define("Multiple Dragon Eggs", true);
        DRAGON_EGG_RADIUS = BUILDER.comment("Radius to check for players to give dragon eggs").define("Dragon Egg Radius", (Object)64);
        DRAGON_EGG_AMOUNT = BUILDER.comment("Amount of dragon eggs to give per player").define("Dragon Egg Amount", (Object)1);
        GIVE_EGG_TO_ABSENT_PLAYERS = BUILDER.comment("Give dragon eggs to players who caused damage but are not present at death").define("Give Egg To Absent Players", true);
        BUILDER.pop();
        BUILDER.push("Stronger Ender Dragon");
        MAX_DRAGON_LEVEL = BUILDER.comment("Maximum level for Ender Dragon").define("Maximum Dragon Level", (Object)13);
        DRAGON_HEALTH_INCREASE_VALUE = BUILDER.comment("Health increase per level of Ender Dragon when level < 6").define("Dragon Health Increase Value", (Object)200.0);
        DRAGON_HEALTH_INCREASE_VALUE_HIGH_LEVEL = BUILDER.comment("Health increase per level of Ender Dragon when level >= 6").define("Dragon Health Increase Value High Level", (Object)1024.0);
        DRAGON_ARMOR_INCREASE_VALUE = BUILDER.comment("Armor increase per level of Ender Dragon when level < 6").define("Dragon Armor Increase Value", (Object)2.0);
        DRAGON_ARMOR_INCREASE_VALUE_HIGH_LEVEL = BUILDER.comment("Armor increase per level of Ender Dragon when level >= 6").define("Dragon Armor Increase Value High Level", (Object)4.0);
        DRAGON_ATTACK_INCREASE_VALUE = BUILDER.comment("Attack increase per level of Ender Dragon when level < 6").define("Dragon Attack Increase Value", (Object)6.0);
        DRAGON_ATTACK_INCREASE_VALUE_HIGH_LEVEL = BUILDER.comment("Attack increase per level of Ender Dragon when level >= 6").define("Dragon Attack Increase Value High Level", (Object)12.0);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Compat Mods");
        BUILDER.push("Cataclysm");
        ENABLE_CATACLYSM_COMPAT = BUILDER.comment(new String[]{"Enable Cataclysm mod recipe compatibility replacement.", "When enabled, Cataclysm boss medals will be used as upgrade materials for The Last Sword."}).define("Enable Cataclysm Recipe Replacement", true);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

