/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.defence;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.defence.DefenceManager;

@Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CustomHealthSavedData
extends SavedData {
    private final Map<UUID, CompoundTag> recordsNBT = new HashMap<UUID, CompoundTag>();

    private CustomHealthSavedData() {
    }

    public static CustomHealthSavedData get(ServerLevel level) {
        return (CustomHealthSavedData)level.m_8895_().m_164861_(CustomHealthSavedData::load, CustomHealthSavedData::new, "the_last_sword_custom_health");
    }

    private static CustomHealthSavedData load(CompoundTag root) {
        CustomHealthSavedData data = new CustomHealthSavedData();
        CompoundTag all = root.m_128469_("Records");
        for (String k : all.m_128431_()) {
            data.recordsNBT.put(UUID.fromString(k), all.m_128469_(k));
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag root) {
        CompoundTag all = new CompoundTag();
        this.recordsNBT.forEach((id, tag) -> all.m_128365_(id.toString(), (Tag)tag));
        root.m_128365_("Records", (Tag)all);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistData(ServerLevel level) {
        CustomHealthSavedData store = CustomHealthSavedData.get(level);
        Class<DefenceManager> clazz = DefenceManager.class;
        synchronized (DefenceManager.class) {
            store.recordsNBT.clear();
            Map<UUID, CompoundTag> latest = DefenceManager.exportRecords();
            store.recordsNBT.putAll(latest);
            store.m_77762_();
            DefenceManager.markSaved();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadToManager(ServerLevel level) {
        CustomHealthSavedData store = CustomHealthSavedData.get(level);
        Class<DefenceManager> clazz = DefenceManager.class;
        synchronized (DefenceManager.class) {
            DefenceManager.importRecords(store.recordsNBT);
            DefenceManager.markSaved();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        ServerPlayer sp;
        Player player = e.getEntity();
        if (player instanceof ServerPlayer && (player = (sp = (ServerPlayer)player).m_9236_()) instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)player;
            if (DefenceManager.needsSave()) {
                CustomHealthSavedData.persistData(lvl);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent e) {
        if (!DefenceManager.needsSave()) {
            return;
        }
        e.getServer().m_129785_().forEach(CustomHealthSavedData::persistData);
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load e) {
        LevelAccessor levelAccessor = e.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)levelAccessor;
            CustomHealthSavedData.loadToManager(lvl);
        }
    }
}

