/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.entity;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.init.TheLastSwordModEntities;
import net.the_last_sword.item.DragonCrystalSword;
import net.the_last_sword.util.EntityUtil;

public class DragonCrystalSwordProjectile
extends ThrowableProjectile
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Items.f_42415_);
    private final UUID shooterUUID;
    private double baseDamage;
    private int knockback;
    private boolean isCrit;
    private boolean hasHitGround = false;

    public DragonCrystalSwordProjectile(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)TheLastSwordModEntities.DRAGON_CRYSTAL_SWORD_PROJECTILE.get(), world);
        this.shooterUUID = null;
        this.baseDamage = DragonCrystalSword.getProjectilePhysicalDamage();
        this.knockback = 1;
        this.isCrit = false;
    }

    public DragonCrystalSwordProjectile(EntityType<? extends DragonCrystalSwordProjectile> type, Level world) {
        super(type, world);
        this.shooterUUID = null;
        this.baseDamage = DragonCrystalSword.getProjectilePhysicalDamage();
        this.knockback = 1;
        this.isCrit = false;
    }

    public DragonCrystalSwordProjectile(EntityType<? extends DragonCrystalSwordProjectile> type, LivingEntity entity, Level world, UUID shooterUUID) {
        super(type, entity, world);
        this.shooterUUID = shooterUUID;
        this.baseDamage = DragonCrystalSword.getProjectilePhysicalDamage();
        this.knockback = 1;
        this.isCrit = false;
    }

    protected void m_8097_() {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity target = entityHitResult.m_82443_();
        if (EntityUtil.isOwnerOrAllyOrPet(target, this.shooterUUID, this.m_19749_())) {
            return;
        }
        if (!EntityUtil.shouldAttack(target)) {
            return;
        }
        if (target instanceof LivingEntity) {
            ServerLevel serverLevel;
            LightningBolt lightning;
            Level mainHandItem;
            LivingEntity livingTarget = (LivingEntity)target;
            DamageSource projectileDamageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268739_), (Entity)this, this.m_19749_());
            livingTarget.m_6469_(projectileDamageSource, (float)this.baseDamage);
            Entity entity = this.m_19749_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                mainHandItem = player.m_21205_();
                mainHandItem.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(swordLevel -> {
                    int level = swordLevel.getLevel();
                    double increaseValue = TheLastSwordConfiguration.getIncreaseValueSafely();
                    double increaseValueHighLevel = TheLastSwordConfiguration.getIncreaseValueHighLevelSafely();
                    double extraDamage = (level < 6 ? increaseValue : increaseValueHighLevel) * (double)level;
                    if (extraDamage > 0.0) {
                        DamageSource lightningDamageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268450_), (Entity)this, this.m_19749_());
                        livingTarget.m_6469_(lightningDamageSource, (float)extraDamage);
                    }
                });
            }
            if ((mainHandItem = this.m_9236_()) instanceof ServerLevel && (lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)(serverLevel = (ServerLevel)mainHandItem))) != null) {
                lightning.m_20219_(Vec3.m_82539_((Vec3i)BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_())));
                lightning.m_20874_(true);
                serverLevel.m_7967_((Entity)lightning);
            }
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        ServerLevel serverLevel;
        LightningBolt lightning;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && (lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)(serverLevel = (ServerLevel)level))) != null) {
            BlockPos pos = blockHitResult.m_82425_();
            lightning.m_20219_(Vec3.m_82539_((Vec3i)pos));
            lightning.m_20874_(true);
            serverLevel.m_7967_((Entity)lightning);
        }
        this.hasHitGround = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasHitGround) {
            this.m_146870_();
        }
    }

    protected float m_7139_() {
        return 0.03f;
    }

    public static DragonCrystalSwordProjectile shoot(Level world, LivingEntity entity, RandomSource random, UUID shooterUUID) {
        DragonCrystalSwordProjectile projectile = new DragonCrystalSwordProjectile((EntityType<? extends DragonCrystalSwordProjectile>)((EntityType)TheLastSwordModEntities.DRAGON_CRYSTAL_SWORD_PROJECTILE.get()), entity, world, shooterUUID);
        Vec3 viewVector = entity.m_20252_(1.0f);
        projectile.m_6686_(viewVector.f_82479_, viewVector.f_82480_, viewVector.f_82481_, 3.0f, 0.0f);
        projectile.m_20225_(true);
        projectile.baseDamage = DragonCrystalSword.getProjectilePhysicalDamage();
        projectile.knockback = 1;
        projectile.isCrit = false;
        world.m_7967_((Entity)projectile);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + 0.5f);
        return projectile;
    }
}

