/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.entity;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.entity.PurpleLightingEntity;
import net.the_last_sword.init.TheLastSwordModEntities;
import net.the_last_sword.init.TheLastSwordModItems;
import net.the_last_sword.item.DragonSword;
import net.the_last_sword.util.EntityUtil;

public class DragonSwordProjectile
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)TheLastSwordModItems.DRAGON_CRYSTAL.get());
    private final UUID shooterUUID;

    public DragonSwordProjectile(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)TheLastSwordModEntities.DRAGON_SWORD_PROJECTILE.get(), world);
        this.shooterUUID = null;
    }

    public DragonSwordProjectile(EntityType<? extends DragonSwordProjectile> type, Level world) {
        super(type, world);
        this.shooterUUID = null;
    }

    public DragonSwordProjectile(EntityType<? extends DragonSwordProjectile> type, LivingEntity entity, Level world, UUID shooterUUID) {
        super(type, entity, world);
        this.shooterUUID = shooterUUID;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        Entity target = entityHitResult.m_82443_();
        if (this.m_19749_() == null) {
            return;
        }
        if (EntityUtil.isOwnerOrAllyOrPet(target, this.shooterUUID, this.m_19749_())) {
            return;
        }
        if (!EntityUtil.shouldAttack(target)) {
            return;
        }
        super.m_5790_(entityHitResult);
        if (target instanceof LivingEntity) {
            Player player;
            Level mainHandItem;
            Item item;
            LivingEntity livingTarget = (LivingEntity)target;
            Entity entity = this.m_19749_();
            if (entity instanceof Player && (item = (mainHandItem = (player = (Player)entity).m_21205_()).m_41720_()) instanceof DragonSword) {
                DragonSword dragonSword = (DragonSword)item;
                float basePhysicalDamage = dragonSword.getBasePhysicalDamage();
                if (basePhysicalDamage > 0.0f) {
                    DamageSource physicalDamageSource = livingTarget.m_269291_().m_269075_(player);
                    livingTarget.m_6469_(physicalDamageSource, basePhysicalDamage);
                }
                mainHandItem.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(swordLevel -> {
                    int level = swordLevel.getLevel();
                    double increaseValue = TheLastSwordConfiguration.getIncreaseValueSafely();
                    double increaseValueHighLevel = TheLastSwordConfiguration.getIncreaseValueHighLevelSafely();
                    double extraDamage = (level < 6 ? increaseValue : increaseValueHighLevel) * (double)level;
                    if (extraDamage > 0.0) {
                        DamageSource dragonBreathDamageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268482_), (Entity)this, this.m_19749_());
                        livingTarget.m_6469_(dragonBreathDamageSource, (float)extraDamage);
                    }
                });
            }
            if ((mainHandItem = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)mainHandItem;
                PurpleLightingEntity purpleLightingEntity = new PurpleLightingEntity((EntityType<PurpleLightingEntity>)((EntityType)TheLastSwordModEntities.PURPLE_LIGHTING.get()), (Level)_level);
                purpleLightingEntity.m_20219_(Vec3.m_82539_((Vec3i)BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_())));
                purpleLightingEntity.m_20874_(true);
                _level.m_7967_((Entity)purpleLightingEntity);
            }
        }
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            PurpleLightingEntity purpleLightingEntity = new PurpleLightingEntity((EntityType<PurpleLightingEntity>)((EntityType)TheLastSwordModEntities.PURPLE_LIGHTING.get()), (Level)_level);
            purpleLightingEntity.m_20219_(Vec3.m_82539_((Vec3i)BlockPos.m_274561_((double)blockHitResult.m_82425_().m_123341_(), (double)blockHitResult.m_82425_().m_123342_(), (double)blockHitResult.m_82425_().m_123343_())));
            purpleLightingEntity.m_20874_(true);
            _level.m_7967_((Entity)purpleLightingEntity);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_36703_) {
            this.m_146870_();
        }
    }

    public static DragonSwordProjectile shoot(Level world, LivingEntity entity, RandomSource random, UUID shooterUUID) {
        DragonSwordProjectile entityarrow = new DragonSwordProjectile((EntityType<? extends DragonSwordProjectile>)((EntityType)TheLastSwordModEntities.DRAGON_SWORD_PROJECTILE.get()), entity, world, shooterUUID);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, 4.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(100.0);
        entityarrow.m_36735_(2);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + 1.0f);
        return entityarrow;
    }
}

