/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.entity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.client.hud.LostWraithBossBar;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.entity.TheLastEndEntity;
import net.the_last_sword.entity.ai.LostWraithAI;
import net.the_last_sword.init.TheLastSwordModEntities;
import net.the_last_sword.init.TheLastSwordModItems;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LostWraithEntity
extends TheLastEndEntity {
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(LostWraithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private String prevAnim = "";

    public LostWraithEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<LostWraithEntity>)((EntityType)TheLastSwordModEntities.LOST_WRAITH.get()), world);
    }

    public LostWraithEntity(EntityType<LostWraithEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 200;
        this.m_21557_(false);
        this.m_21530_();
        this.setEndLevel(1);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION, (Object)"empty");
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.wither_skeleton.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.wither_skeleton.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.wither_skeleton.death"));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 200.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        return builder;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setEndLevel(1);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("LEVEL", 1);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData result = super.m_6518_(world, difficulty, reason, livingdata, tag);
        if (!this.m_9236_().f_46443_) {
            this.setEndLevel(1);
            this.setIsSpawned(false);
            this.setAnimation("init");
            this.setAnimationTick(0);
            this.faceNearestPlayer();
        }
        return result;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.85f;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.shouldPlayDeathAnimation()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("death"));
            return PlayState.CONTINUE;
        }
        if (!this.getIsSpawned()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("init"));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (this.shouldPlayDeathAnimation()) {
            return PlayState.STOP;
        }
        String currentAnim = this.getSyncedAnimation();
        if (!currentAnim.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !currentAnim.equals(this.prevAnim) && !currentAnim.equals("empty")) {
            if (!currentAnim.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(currentAnim));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.setAnimation("empty");
                event.getController().forceAnimationReset();
            }
        } else if (currentAnim.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = currentAnim;
        return PlayState.CONTINUE;
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    protected boolean shouldPlayDeathAnimation() {
        return this.getIsDead();
    }

    private void faceNearestPlayer() {
        Player nearestPlayer = this.m_9236_().m_45930_((Entity)this, 32.0);
        if (nearestPlayer != null) {
            this.faceTarget((LivingEntity)nearestPlayer);
        }
    }

    private void faceTarget(LivingEntity target) {
        if (target == null || !target.m_6084_()) {
            return;
        }
        double deltaX = target.m_20185_() - this.m_20185_();
        double deltaZ = target.m_20189_() - this.m_20189_();
        double deltaY = target.m_20186_() + (double)target.m_20206_() * 0.5 - (this.m_20186_() + (double)this.m_20206_() * 0.5);
        double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        float yaw = (float)(Math.atan2(-deltaX, deltaZ) * 180.0 / Math.PI);
        float pitch = (float)(Math.atan2(-deltaY, horizontalDistance) * 180.0 / Math.PI);
        this.m_146922_(yaw);
        this.m_146926_(pitch);
        this.f_20885_ = yaw;
        this.f_20883_ = yaw;
    }

    private void sendDeathTalkToNearbyPlayers() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        List nearbyPlayers = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(32.0));
        if (!nearbyPlayers.isEmpty()) {
            String translationKey = "talk.lost_wraith.death";
            MutableComponent talkMessage = Component.m_237115_((String)translationKey);
            MutableComponent prefixedMessage = Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"entity.the_last_sword.lost_wraith")).m_7220_((Component)Component.m_237113_((String)"] ")).m_130940_(ChatFormatting.DARK_PURPLE).m_7220_((Component)talkMessage.m_6881_().m_130940_(ChatFormatting.WHITE));
            for (Player player : nearbyPlayers) {
                player.m_213846_((Component)prefixedMessage);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.getIsDead()) {
                if (this.getDeathTime() == 0) {
                    this.sendDeathTalkToNearbyPlayers();
                    this.setAnimation("death");
                    this.dropDeathLoop();
                    this.m_21226_();
                }
                LostWraithAI.cleanupRemovedEntity(this.m_20148_());
                if (this.getDeathTime() >= 50) {
                    this.safeRemove();
                }
                return;
            }
            if (!this.getIsSpawned()) {
                String currentAnim = this.getSyncedAnimation();
                if (currentAnim.equals("spawn")) {
                    int animTick = this.getAnimationTick();
                    this.setAnimationTick(animTick + 1);
                    if (animTick >= 110) {
                        this.setIsSpawned(true);
                        this.setAnimation("empty");
                        this.setAnimationTick(0);
                        if (!DefenceManager.isTracked((LivingEntity)this)) {
                            DefenceManager.register((LivingEntity)this, 1);
                        }
                        if (this.m_9236_().f_46443_) {
                            LostWraithBossBar.showBossBar(this);
                        }
                    }
                }
                return;
            }
            LostWraithAI.handleTick(this);
        } else if (this.m_9236_().f_46443_ && this.getIsSpawned()) {
            LostWraithBossBar.updateBossBar(this);
        }
        this.m_6210_();
    }

    public void activate() {
        if (!this.m_9236_().f_46443_ && !this.getIsSpawned()) {
            this.setAnimation("spawn");
            this.setAnimationTick(0);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42104_ && !this.getIsSpawned()) {
            if (!this.m_9236_().f_46443_) {
                this.activate();
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.sendActivationTalk(player);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11894_, this.m_5720_(), 1.0f, 1.0f);
                this.spawnActivationParticles();
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_41619_() && !this.getIsSpawned()) {
            if (!this.m_9236_().f_46443_) {
                this.sendRandomTalk(player);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    private void sendRandomTalk(Player player) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        Random random = new Random();
        int messageIndex = random.nextInt(7) + 1;
        String translationKey = "talk.lost_wraith.init_" + messageIndex;
        MutableComponent talkMessage = Component.m_237115_((String)translationKey);
        MutableComponent prefixedMessage = Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"entity.the_last_sword.lost_wraith")).m_7220_((Component)Component.m_237113_((String)"] ")).m_130940_(ChatFormatting.DARK_PURPLE).m_7220_((Component)talkMessage.m_6881_().m_130940_(ChatFormatting.WHITE));
        player.m_213846_((Component)prefixedMessage);
    }

    private void sendActivationTalk(Player player) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        String translationKey = "talk.lost_wraith.activation";
        MutableComponent talkMessage = Component.m_237115_((String)translationKey);
        MutableComponent prefixedMessage = Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"entity.the_last_sword.lost_wraith")).m_7220_((Component)Component.m_237113_((String)"] ")).m_130940_(ChatFormatting.DARK_PURPLE).m_7220_((Component)talkMessage.m_6881_().m_130940_(ChatFormatting.WHITE));
        player.m_213846_((Component)prefixedMessage);
    }

    private void spawnActivationParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            for (i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0, this.m_20186_() + this.f_19796_.m_188500_() * 2.0, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0, 1, d0, d1, d2, 0.1);
            }
            for (i = 0; i < 15; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 1.5, this.m_20186_() + this.f_19796_.m_188500_() * 1.5 + 0.5, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 1.5, 1, 0.0, 0.1, 0.0, 0.02);
            }
        }
    }

    @Override
    public void m_20334_(double x, double y, double z) {
        String currentAnim = this.getSyncedAnimation();
        if (currentAnim.equals("init")) {
            return;
        }
        super.m_20334_(x, y, z);
    }

    public boolean m_6469_(DamageSource damageSource, float damageAmount) {
        if (!this.getIsSpawned()) {
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268482_) || damageSource.m_276093_(DamageTypes.f_268515_) || damageSource.m_276093_(DamageTypes.f_268530_) || damageSource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        return super.m_6469_(damageSource, damageAmount);
    }

    public void m_6475_(DamageSource damageSource, float damageAmount) {
        float limitedDamage = Math.min(damageAmount, 5.0f);
        super.m_6475_(damageSource, limitedDamage);
    }

    @Override
    protected int getMaxLevel() {
        return 1;
    }

    @Override
    protected int getMinLevel() {
        return 1;
    }

    @Override
    public final void setEndLevel(int level) {
        super.setEndLevel(1);
    }

    @Override
    public void safeRemove() {
        if (this.m_9236_().f_46443_) {
            LostWraithBossBar.hideBossBar(this.m_20148_());
        }
        super.safeRemove();
    }

    private void dropDeathLoop() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack swordSoulStone = new ItemStack((ItemLike)TheLastSwordModItems.SWORD_SOUL_STONE.get());
            this.m_19983_(swordSoulStone);
        }
    }
}

