/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.util.EntityUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;

public abstract class TheLastEndEntity
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(TheLastEndEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ALL_THINGS_END = SynchedEntityData.m_135353_(TheLastEndEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SPAWNED = SynchedEntityData.m_135353_(TheLastEndEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIMATION_TICK = SynchedEntityData.m_135353_(TheLastEndEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ALLOW_MOVING = SynchedEntityData.m_135353_(TheLastEndEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_DEAD = SynchedEntityData.m_135353_(TheLastEndEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DEATH_TIME = SynchedEntityData.m_135353_(TheLastEndEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_REMOVED = SynchedEntityData.m_135353_(TheLastEndEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int localDeathTime = 0;

    protected TheLastEndEntity(EntityType<? extends TamableAnimal> type, Level world) {
        super(type, world);
    }

    protected int getMinLevel() {
        return 1;
    }

    protected int getMaxLevel() {
        return 13;
    }

    public int getAllThingsEndLevel() {
        return 13;
    }

    protected int getDeathDuration() {
        return 100;
    }

    public int mapToDefenseLevel() {
        int endLevel = this.getEndLevel();
        if (endLevel <= 5) {
            return 1;
        }
        if (endLevel <= 12) {
            return 2;
        }
        if (this.isAllThingsEnd()) {
            return 3;
        }
        return 2;
    }

    protected boolean canRegisterDefense() {
        return this.m_6084_() && !this.m_213877_() && !this.m_9236_().f_46443_;
    }

    public final int getEndLevel() {
        return (Integer)this.f_19804_.m_135370_(LEVEL);
    }

    public void setEndLevel(int level) {
        int newLevel;
        int oldLevel = this.getEndLevel();
        if (oldLevel != (newLevel = Math.max(this.getMinLevel(), Math.min(this.getMaxLevel(), level)))) {
            this.f_19804_.m_135381_(LEVEL, (Object)newLevel);
            this.updateDefenseLevel();
        }
    }

    private void ensureDefenseRegistration() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.canRegisterDefense()) {
            if (!DefenceManager.isTracked((LivingEntity)this)) {
                int defenseLevel = this.mapToDefenseLevel();
                DefenceManager.register((LivingEntity)this, defenseLevel);
            } else {
                this.updateDefenseLevel();
            }
        }
    }

    public void updateDefenseLevel() {
        int registeredLevel;
        if (!DefenceManager.isTracked((LivingEntity)this) || this.m_9236_().f_46443_) {
            return;
        }
        int currentDefenseLevel = this.mapToDefenseLevel();
        if (currentDefenseLevel != (registeredLevel = DefenceManager.getLevel((LivingEntity)this))) {
            DefenceManager.clear((LivingEntity)this);
            DefenceManager.register((LivingEntity)this, currentDefenseLevel);
        } else {
            DefenceManager.pullFromEntity((LivingEntity)this, currentDefenseLevel);
        }
    }

    public final boolean getIsSpawned() {
        return (Boolean)this.f_19804_.m_135370_(IS_SPAWNED);
    }

    public final void setIsSpawned(boolean spawned) {
        this.f_19804_.m_135381_(IS_SPAWNED, (Object)spawned);
    }

    public final int getAnimationTick() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_TICK);
    }

    public final void setAnimationTick(int tick) {
        this.f_19804_.m_135381_(ANIMATION_TICK, (Object)tick);
    }

    public final boolean getAllowMoving() {
        return (Boolean)this.f_19804_.m_135370_(ALLOW_MOVING);
    }

    public final void setAllowMoving(boolean allowMoving) {
        this.f_19804_.m_135381_(ALLOW_MOVING, (Object)allowMoving);
    }

    public final boolean getIsDead() {
        return (Boolean)this.f_19804_.m_135370_(IS_DEAD);
    }

    public final void setIsDead(boolean isDead) {
        this.f_19804_.m_135381_(IS_DEAD, (Object)isDead);
    }

    public final int getDeathTime() {
        if (this.m_9236_().f_46443_) {
            return (Integer)this.f_19804_.m_135370_(DEATH_TIME);
        }
        return this.localDeathTime;
    }

    public final void setDeathTime(int deathTime) {
        if (!this.m_9236_().f_46443_) {
            this.localDeathTime = deathTime;
        }
        this.f_19804_.m_135381_(DEATH_TIME, (Object)deathTime);
    }

    public final boolean getIsRemoved() {
        return (Boolean)this.f_19804_.m_135370_(IS_REMOVED);
    }

    public final void setIsRemoved(boolean isRemoved) {
        this.f_19804_.m_135381_(IS_REMOVED, (Object)isRemoved);
    }

    public final boolean isAllThingsEnd() {
        return (Boolean)this.f_19804_.m_135370_(ALL_THINGS_END);
    }

    public void setAllThingsEndState(boolean enabled) {
        boolean current = (Boolean)this.f_19804_.m_135370_(ALL_THINGS_END);
        if (current != enabled) {
            this.f_19804_.m_135381_(ALL_THINGS_END, (Object)enabled);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LEVEL, (Object)this.getMinLevel());
        this.f_19804_.m_135372_(ALL_THINGS_END, (Object)false);
        this.f_19804_.m_135372_(IS_SPAWNED, (Object)false);
        this.f_19804_.m_135372_(ANIMATION_TICK, (Object)0);
        this.f_19804_.m_135372_(ALLOW_MOVING, (Object)true);
        this.f_19804_.m_135372_(IS_DEAD, (Object)false);
        this.f_19804_.m_135372_(DEATH_TIME, (Object)0);
        this.f_19804_.m_135372_(IS_REMOVED, (Object)false);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("LEVEL")) {
            this.setEndLevel(tag.m_128451_("LEVEL"));
        }
        if (tag.m_128441_("ALL_THINGS_END")) {
            this.f_19804_.m_135381_(ALL_THINGS_END, (Object)tag.m_128471_("ALL_THINGS_END"));
        }
        if (tag.m_128441_("IS_SPAWNED")) {
            this.setIsSpawned(tag.m_128471_("IS_SPAWNED"));
        }
        if (tag.m_128441_("ANIMATION_TICK")) {
            this.setAnimationTick(tag.m_128451_("ANIMATION_TICK"));
        }
        if (tag.m_128441_("ALLOW_MOVING")) {
            this.setAllowMoving(tag.m_128471_("ALLOW_MOVING"));
        }
        if (tag.m_128441_("IS_DEAD")) {
            this.setIsDead(tag.m_128471_("IS_DEAD"));
        }
        if (tag.m_128441_("DEATH_TIME")) {
            int savedDeathTime = tag.m_128451_("DEATH_TIME");
            this.setDeathTime(savedDeathTime);
            this.localDeathTime = savedDeathTime;
        }
        if (tag.m_128441_("IS_REMOVED")) {
            this.setIsRemoved(tag.m_128471_("IS_REMOVED"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("LEVEL", this.getEndLevel());
        tag.m_128379_("ALL_THINGS_END", ((Boolean)this.f_19804_.m_135370_(ALL_THINGS_END)).booleanValue());
        tag.m_128379_("IS_SPAWNED", this.getIsSpawned());
        tag.m_128405_("ANIMATION_TICK", this.getAnimationTick());
        tag.m_128379_("ALLOW_MOVING", this.getAllowMoving());
        tag.m_128379_("IS_DEAD", this.getIsDead());
        tag.m_128405_("DEATH_TIME", this.getDeathTime());
        tag.m_128379_("IS_REMOVED", this.getIsRemoved());
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.getIsRemoved()) {
                this.safeRemove();
                return;
            }
            if (this.getIsDead()) {
                int currentDeathTime = this.getDeathTime();
                this.setDeathTime(currentDeathTime + 1);
                if (this.getDeathTime() >= this.getDeathDuration()) {
                    this.setIsRemoved(true);
                }
                return;
            }
            if (!DefenceManager.isTracked((LivingEntity)this)) {
                this.ensureDefenseRegistration();
            }
            this.checkDeathCondition();
        }
    }

    private void checkDeathCondition() {
        float currentHealth;
        if (DefenceManager.isTracked((LivingEntity)this) && !this.getIsDead() && (currentHealth = DefenceManager.getStoredHealth((LivingEntity)this)) <= 0.0f) {
            this.setIsDead(true);
            this.setDeathTime(0);
            this.setAllowMoving(false);
            DefenceManager.clear((LivingEntity)this);
        }
    }

    public void safeRemove() {
        Level level;
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundRemoveEntitiesPacket removePacket = new ClientboundRemoveEntitiesPacket(new int[]{this.m_19879_()});
            for (ServerPlayer player : serverLevel.m_7654_().m_6846_().m_11314_()) {
                player.f_8906_.m_9829_((Packet)removePacket);
            }
        }
        DefenceManager.clear((LivingEntity)this);
        EntityUtil.TheLastEndRemove((Entity)this, Entity.RemovalReason.KILLED);
    }

    public boolean m_20329_(Entity entity) {
        return false;
    }

    public float m_21233_() {
        if (DefenceManager.isTracked((LivingEntity)this)) {
            return DefenceManager.getStoredMax((LivingEntity)this);
        }
        return super.m_21233_();
    }

    public boolean m_7301_(MobEffectInstance effect) {
        if (effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
            return false;
        }
        return super.m_7301_(effect);
    }

    public boolean m_21224_() {
        return false;
    }

    public boolean m_6084_() {
        return !this.getIsDead();
    }

    public void m_6667_(DamageSource damageSource) {
    }

    public float m_21223_() {
        if (DefenceManager.isTracked((LivingEntity)this)) {
            return DefenceManager.getStoredHealth((LivingEntity)this);
        }
        return super.m_21223_();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_6021_(double x, double y, double z) {
    }

    public void m_20334_(double x, double y, double z) {
        if (!this.getAllowMoving()) {
            if (this.isInAir() && this.hasGroundBelow()) {
                super.m_20334_(x, y, z);
            } else {
                super.m_20334_(0.0, 0.0, 0.0);
            }
        } else {
            super.m_20334_(x, y, z);
        }
    }

    private boolean isInAir() {
        BlockPos currentPos = new BlockPos((int)this.m_20185_(), (int)(this.m_20186_() - 0.1), (int)this.m_20189_());
        return this.m_9236_().m_8055_(currentPos).m_60795_();
    }

    private boolean hasGroundBelow() {
        for (int i = 1; i <= 5; ++i) {
            BlockPos checkPos = new BlockPos((int)this.m_20185_(), (int)(this.m_20186_() - (double)i), (int)this.m_20189_());
            if (this.m_9236_().m_8055_(checkPos).m_60795_()) continue;
            return true;
        }
        return false;
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_203441_(FluidState fluidState) {
        return fluidState.m_205070_(FluidTags.f_13131_);
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_6842_(boolean invisible) {
        super.m_6842_(false);
    }

    public boolean m_20145_() {
        return false;
    }

    public boolean m_21525_() {
        return false;
    }

    public void m_21557_(boolean noAi) {
    }

    public boolean m_35506_() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }
}

