/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PlayMessages;
import net.the_last_sword.init.TheLastSwordModEntities;
import net.the_last_sword.util.TheLastSwordLogger;

@Mod.EventBusSubscriber
public class TheLastEndItemEntity
extends ItemEntity {
    public TheLastEndItemEntity(EntityType<? extends ItemEntity> type, Level level) {
        super(type, level);
    }

    public TheLastEndItemEntity(Level level, double x, double y, double z, ItemStack stack) {
        super(level, x, y, z, stack);
    }

    public TheLastEndItemEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends ItemEntity>)((EntityType)TheLastSwordModEntities.THE_LAST_END_ITEM_ENTITY.get()), level);
        this.m_6034_(spawnEntity.getPosX(), spawnEntity.getPosY(), spawnEntity.getPosZ());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isInVoid()) {
            this.teleportToSurfaceOrPlayer();
        }
    }

    private boolean isInVoid() {
        BlockPos pos = this.m_20183_();
        return this.m_9236_().m_46859_(pos) && this.m_9236_().m_46859_(pos.m_7495_());
    }

    private void teleportToSurfaceOrPlayer() {
        BlockPos surfacePos = this.findClosestSurfaceBlock();
        if (surfacePos != null) {
            this.m_6034_((double)surfacePos.m_123341_() + 0.5, surfacePos.m_123342_() + 1, (double)surfacePos.m_123343_() + 0.5);
        } else {
            Player nearestPlayer = this.m_9236_().m_45930_((Entity)this, 32.0);
            if (nearestPlayer != null) {
                this.m_6034_(nearestPlayer.m_20185_(), nearestPlayer.m_20186_() + 1.0, nearestPlayer.m_20189_());
            }
        }
    }

    private BlockPos findClosestSurfaceBlock() {
        BlockPos center = this.m_20183_();
        int range = 32;
        for (int y = center.m_123342_(); y < this.m_9236_().m_151558_(); ++y) {
            for (int x = center.m_123341_() - range; x <= center.m_123341_() + range; ++x) {
                for (int z = center.m_123343_() - range; z <= center.m_123343_() + range; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState blockState = this.m_9236_().m_8055_(pos);
                    BlockPos abovePos = pos.m_7494_();
                    if (!blockState.m_60804_((BlockGetter)this.m_9236_(), pos) || !this.m_9236_().m_46859_(abovePos)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public void m_142687_(Entity.RemovalReason reason) {
    }

    public void m_146871_() {
    }

    @SubscribeEvent
    public static void onItemExpire(ItemExpireEvent event) {
        if (event.getEntity() instanceof TheLastEndItemEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        try {
            List affectedEntities = event.getAffectedEntities();
            if (affectedEntities == null || affectedEntities.isEmpty()) {
                return;
            }
            boolean hasProtectedEntities = false;
            for (Entity entity : affectedEntities) {
                if (!(entity instanceof TheLastEndItemEntity)) continue;
                hasProtectedEntities = true;
                break;
            }
            if (!hasProtectedEntities) {
                return;
            }
            TheLastEndItemEntity.removeTheLastEndItemEntitiesSafely(affectedEntities);
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Error handling explosion event: {}", e.getMessage());
        }
    }

    private static void removeTheLastEndItemEntitiesSafely(List<Entity> affectedEntities) {
        try {
            Iterator<Entity> iterator = affectedEntities.iterator();
            while (iterator.hasNext()) {
                Entity entity2 = iterator.next();
                if (!(entity2 instanceof TheLastEndItemEntity)) continue;
                iterator.remove();
            }
        }
        catch (UnsupportedOperationException e1) {
            try {
                affectedEntities.removeIf(entity -> entity instanceof TheLastEndItemEntity);
            }
            catch (UnsupportedOperationException e2) {
                try {
                    ArrayList<Entity> toRemove = new ArrayList<Entity>();
                    for (Entity entity3 : affectedEntities) {
                        if (!(entity3 instanceof TheLastEndItemEntity)) continue;
                        toRemove.add(entity3);
                    }
                    affectedEntities.removeAll(toRemove);
                }
                catch (UnsupportedOperationException e3) {
                    try {
                        affectedEntities.clear();
                    }
                    catch (UnsupportedOperationException e4) {
                        TheLastSwordLogger.warn("Cannot modify immutable affected entities list");
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getState().m_60734_() == Blocks.f_50128_) {
            List entities = event.getLevel().m_45976_(TheLastEndItemEntity.class, new AABB(event.getPos()).m_82400_(1.0));
            entities.forEach(entity -> entity.m_32010_(0));
        }
    }
}

