/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.client.model.TheLastEndSwordWraithModel;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.entity.TheLastEndEntity;
import net.the_last_sword.entity.ai.TheLastEndSwordWraithAI;
import net.the_last_sword.init.TheLastSwordModEntities;
import net.the_last_sword.init.TheLastSwordModMobEffects;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TheLastEndSwordWraithEntity
extends TheLastEndEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(TheLastEndSwordWraithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(TheLastEndSwordWraithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(TheLastEndSwordWraithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final List<LivingEntity> targetList = new ArrayList<LivingEntity>();
    String prevAnim = "empty";

    public TheLastEndSwordWraithEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<? extends TheLastEndEntity>)((EntityType)TheLastSwordModEntities.THE_LAST_END_SWORD_WRAITH.get()), world);
    }

    public TheLastEndSwordWraithEntity(EntityType<? extends TheLastEndEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 50;
        this.m_21557_(false);
        this.m_274367_(0.6f);
        this.m_21530_();
    }

    @Override
    protected int getMaxLevel() {
        return 13;
    }

    @Override
    public int getAllThingsEndLevel() {
        return 13;
    }

    @Override
    public void setEndLevel(int level) {
        int oldLevel = this.getEndLevel();
        super.setEndLevel(level);
        int newLevel = this.getEndLevel();
        if (newLevel != oldLevel && !this.m_9236_().f_46443_) {
            if (DefenceManager.isTracked((LivingEntity)this)) {
                DefenceManager.pullFromEntity((LivingEntity)this, this.mapToDefenseLevel());
            }
            if (this.getIsSpawned()) {
                TheLastEndSwordWraithAI.handleLevelChange(this, oldLevel, newLevel);
            }
        }
    }

    @Override
    public void setAllThingsEndState(boolean enabled) {
        boolean current = this.isAllThingsEnd();
        super.setAllThingsEndState(enabled);
        if (current != enabled && !this.m_9236_().f_46443_) {
            if (enabled) {
                TheLastEndSwordWraithAI.onAllThingsEndUnlocked(this);
            } else {
                TheLastEndSwordWraithAI.onAllThingsEndLost(this);
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"the_last_end_sword_wraith");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("TEXTURE", this.getTexture());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("TEXTURE")) {
            this.setTexture(compound.m_128461_("TEXTURE"));
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal(this, 1.5, 2.0f, 32.0f, false){

            public boolean m_8036_() {
                if (TheLastEndSwordWraithEntity.this.m_5448_() != null && TheLastEndSwordWraithEntity.this.m_5448_().m_6084_()) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (TheLastEndSwordWraithEntity.this.m_5448_() != null && TheLastEndSwordWraithEntity.this.m_5448_().m_6084_()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ender_dragon.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ender_dragon.death"));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        if (!this.m_9236_().f_46443_) {
            if (this.getEndLevel() <= 0) {
                this.setEndLevel(1);
            }
            this.setAnimation("spawn");
            this.spawnSummonParticles();
        }
        return retval;
    }

    @Override
    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() == TheLastSwordModMobEffects.VOID_ENCHANTMENT.get();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.0f);
    }

    public double getAttackRange() {
        return this.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean hasTarget;
            if (this.getIsDead()) {
                if (this.getDeathTime() <= 1) {
                    this.setAnimation("death");
                    TheLastEndSwordWraithAI.cleanupRemovedEntity(this.m_20148_());
                }
                return;
            }
            if (!this.getIsSpawned()) {
                int animTick = this.getAnimationTick();
                this.setAnimationTick(animTick + 1);
                if (animTick >= 110) {
                    this.setIsSpawned(true);
                    this.setAnimation("idle");
                    this.setAnimationTick(0);
                }
            }
            TheLastEndSwordWraithAI.handleTick(this);
            boolean bl = hasTarget = this.m_5448_() != null;
            if (hasTarget && this.m_5448_().m_6084_() && this.f_19797_ % 20 == 0) {
                this.faceTarget(this.m_5448_());
            }
        }
        this.m_6210_();
    }

    private void faceTarget(LivingEntity target) {
        if (target == null || !target.m_6084_()) {
            return;
        }
        double deltaX = target.m_20185_() - this.m_20185_();
        double deltaZ = target.m_20189_() - this.m_20189_();
        double deltaY = target.m_20186_() + (double)target.m_20206_() * 0.5 - (this.m_20186_() + (double)this.m_20206_() * 0.5);
        double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        float yaw = (float)(Math.atan2(-deltaX, deltaZ) * 180.0 / Math.PI);
        float pitch = (float)(Math.atan2(-deltaY, horizontalDistance) * 180.0 / Math.PI);
        this.m_146922_(yaw);
        this.m_146926_(pitch);
        this.f_20885_ = yaw;
        this.f_20883_ = yaw;
    }

    private boolean shouldPlayDeathAnimation() {
        return this.getIsDead();
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.shouldPlayDeathAnimation()) {
            if (this.getDeathTime() == 1) {
                event.getController().forceAnimationReset();
                this.setAnimation("empty");
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("death"));
        }
        boolean hasTarget = this.m_5448_() != null;
        Vec3 deltaMovement = this.m_20184_();
        double horizontalSpeed = deltaMovement.m_165925_();
        boolean isMoving = horizontalSpeed > 0.001;
        boolean canMove = this.getAllowMoving();
        if (canMove && isMoving) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
        }
        if (hasTarget) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("battle_idle"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (this.shouldPlayDeathAnimation()) {
            return PlayState.STOP;
        }
        String currentAnim = this.getSyncedAnimation();
        if (!currentAnim.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !currentAnim.equals(this.prevAnim) && !currentAnim.equals("empty")) {
            if (!currentAnim.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(currentAnim));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.setAnimation("empty");
                event.getController().forceAnimationReset();
            }
        } else if (currentAnim.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = currentAnim;
        return PlayState.CONTINUE;
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 200.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.1);
        builder = builder.m_22268_((Attribute)ForgeMod.ENTITY_REACH.get(), 4.0);
        return builder;
    }

    public BakedGeoModel getCurrentBakedModel() {
        try {
            TheLastEndSwordWraithModel model = new TheLastEndSwordWraithModel();
            return model.getBakedModel(model.getModelResource(this));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    public void spawnSummonParticles() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        this.spawnExpandingSphere(serverLevel, x, y + 1.0, z);
        this.spawnCircleParticles(serverLevel, x, y + 0.1, z);
        this.spawnHexagramParticles(serverLevel, x, y + 0.2, z);
    }

    private void spawnExpandingSphere(ServerLevel world, double centerX, double centerY, double centerZ) {
        Random random = new Random();
        int particleCount = 200;
        for (int i = 0; i < particleCount; ++i) {
            double theta = random.nextDouble() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
            double radius = 0.5 + random.nextDouble() * 2.0;
            double offsetX = radius * Math.sin(phi) * Math.cos(theta);
            double offsetY = radius * Math.cos(phi);
            double offsetZ = radius * Math.sin(phi) * Math.sin(theta);
            double particleX = centerX + offsetX;
            double particleY = centerY + offsetY;
            double particleZ = centerZ + offsetZ;
            double speedX = offsetX * 0.3;
            double speedY = offsetY * 0.3;
            double speedZ = offsetZ * 0.3;
            world.m_8767_((ParticleOptions)ParticleTypes.f_123760_, particleX, particleY, particleZ, 1, speedX, speedY, speedZ, 0.1);
        }
    }

    private void spawnCircleParticles(ServerLevel world, double centerX, double centerY, double centerZ) {
        double radius = 3.0;
        int particleCount = 60;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double offsetX = radius * Math.cos(angle);
            double offsetZ = radius * Math.sin(angle);
            double particleX = centerX + offsetX;
            double particleZ = centerZ + offsetZ;
            world.m_8767_((ParticleOptions)ParticleTypes.f_123809_, particleX, centerY, particleZ, 3, 0.0, 0.5, 0.0, 0.05);
        }
    }

    private void spawnHexagramParticles(ServerLevel world, double centerX, double centerY, double centerZ) {
        double angle2;
        double angle1;
        int i;
        double radius = 1.5;
        for (i = 0; i < 3; ++i) {
            angle1 = Math.PI * 2 * (double)i / 3.0;
            angle2 = Math.PI * 2 * (double)(i + 1) / 3.0;
            this.drawLine(world, centerX, centerY, centerZ, radius, angle1, angle2, (ParticleOptions)ParticleTypes.f_123799_);
        }
        for (i = 0; i < 3; ++i) {
            angle1 = Math.PI * 2 * (double)i / 3.0 + 1.0471975511965976;
            angle2 = Math.PI * 2 * (double)(i + 1) / 3.0 + 1.0471975511965976;
            this.drawLine(world, centerX, centerY, centerZ, radius, angle1, angle2, (ParticleOptions)ParticleTypes.f_123799_);
        }
    }

    private void drawLine(ServerLevel world, double centerX, double centerY, double centerZ, double radius, double startAngle, double endAngle, ParticleOptions particleType) {
        double startX = centerX + radius * Math.cos(startAngle);
        double startZ = centerZ + radius * Math.sin(startAngle);
        double endX = centerX + radius * Math.cos(endAngle);
        double endZ = centerZ + radius * Math.sin(endAngle);
        int steps = 15;
        for (int i = 0; i <= steps; ++i) {
            double t = (double)i / (double)steps;
            double particleX = startX + t * (endX - startX);
            double particleZ = startZ + t * (endZ - startZ);
            world.m_8767_(particleType, particleX, centerY, particleZ, 2, 0.0, 0.3, 0.0, 0.02);
        }
    }
}

