/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.event;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.the_last_sword.configuration.TheLastSwordConfiguration;

@Mod.EventBusSubscriber
public class EnderDragonEvent {
    private static final String CHALLENGE_COUNT_KEY = "EnderDragonChallengeCount";
    private static final String PLAYER_UUID_LIST_KEY = "DragonAttackers";
    private static final String MODIFIER_ADDED_KEY = "ModifiersAdded";

    private static ChallengeData getChallengeData(ServerLevel level) {
        if (level.m_46472_() == Level.f_46430_) {
            DimensionDataStorage storage = level.m_8895_();
            return (ChallengeData)storage.m_164861_(ChallengeData::load, ChallengeData::new, "dragon_challenges");
        }
        return null;
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (event.getEntity() instanceof EnderDragon && event.getSource().m_7639_() instanceof Player) {
            EnderDragon dragon = (EnderDragon)event.getEntity();
            Player player = (Player)event.getSource().m_7639_();
            ServerLevel level = (ServerLevel)dragon.m_9236_();
            ChallengeData data = EnderDragonEvent.getChallengeData(level);
            if (data != null) {
                data.addAttacker(player.m_20148_());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        EnderDragon dragon;
        ServerLevel level;
        ChallengeData data;
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (event.getEntity() instanceof EnderDragon && (data = EnderDragonEvent.getChallengeData(level = (ServerLevel)(dragon = (EnderDragon)event.getEntity()).m_9236_())) != null) {
            data.incrementChallengeCount();
            if (((Boolean)TheLastSwordConfiguration.DROP_DRAGON_EGG.get()).booleanValue()) {
                int radius = (Integer)TheLastSwordConfiguration.DRAGON_EGG_RADIUS.get();
                int amount = (Integer)TheLastSwordConfiguration.DRAGON_EGG_AMOUNT.get();
                boolean giveAbsent = (Boolean)TheLastSwordConfiguration.GIVE_EGG_TO_ABSENT_PLAYERS.get();
                Set<UUID> attackerUUIDs = data.getAttackerUUIDs();
                HashSet<UUID> remainingUUIDs = new HashSet<UUID>(attackerUUIDs);
                for (Player player : level.m_6907_()) {
                    double distance;
                    if (!attackerUUIDs.contains(player.m_20148_()) || !((distance = player.m_20275_(dragon.m_20185_(), dragon.m_20186_(), dragon.m_20189_())) <= (double)(radius * radius))) continue;
                    ItemStack dragonEgg = new ItemStack((ItemLike)Blocks.f_50260_, amount);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)dragonEgg);
                    remainingUUIDs.remove(player.m_20148_());
                }
                if (giveAbsent) {
                    for (UUID uuid : remainingUUIDs) {
                        ServerPlayer absentPlayer = level.m_7654_().m_6846_().m_11259_(uuid);
                        if (absentPlayer == null) continue;
                        ItemStack dragonEgg = new ItemStack((ItemLike)Blocks.f_50260_, amount);
                        ItemHandlerHelper.giveItemToPlayer((Player)absentPlayer, (ItemStack)dragonEgg);
                    }
                }
                data.clearAttackers();
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (event.getEntity() instanceof EnderDragon) {
            CompoundTag dragonData;
            int challengeCount;
            ChallengeData data;
            EnderDragon dragon = (EnderDragon)event.getEntity();
            ServerLevel level = (ServerLevel)event.getLevel();
            if (level.m_46472_() == Level.f_46430_ && (data = EnderDragonEvent.getChallengeData(level)) != null && (challengeCount = data.getChallengeCount()) > 0 && !(dragonData = dragon.getPersistentData()).m_128471_(MODIFIER_ADDED_KEY)) {
                int cappedLevel = Math.min(challengeCount, (Integer)TheLastSwordConfiguration.MAX_DRAGON_LEVEL.get());
                Component displayName = dragon.m_5446_();
                String newName = displayName.getString() + " LV" + challengeCount;
                dragon.m_6593_((Component)Component.m_237113_((String)newName));
                EnderDragonEvent.applyDragonUpgrades(dragon, cappedLevel);
                dragonData.m_128379_(MODIFIER_ADDED_KEY, true);
            }
        }
    }

    private static void applyDragonUpgrades(EnderDragon dragon, int cappedLevel) {
        double healthIncrease = (double)cappedLevel * (cappedLevel < 6 ? (Double)TheLastSwordConfiguration.DRAGON_HEALTH_INCREASE_VALUE.get() : (Double)TheLastSwordConfiguration.DRAGON_HEALTH_INCREASE_VALUE_HIGH_LEVEL.get());
        AttributeInstance maxHealthAttr = dragon.m_21051_(Attributes.f_22276_);
        if (maxHealthAttr != null) {
            double newMaxHealth = maxHealthAttr.m_22115_() + healthIncrease;
            maxHealthAttr.m_22100_(newMaxHealth);
            dragon.m_21153_((float)newMaxHealth);
        }
        double armorIncrease = (double)cappedLevel * (cappedLevel < 6 ? (Double)TheLastSwordConfiguration.DRAGON_ARMOR_INCREASE_VALUE.get() : (Double)TheLastSwordConfiguration.DRAGON_ARMOR_INCREASE_VALUE_HIGH_LEVEL.get());
        EnderDragonEvent.addAttributeModifier(dragon, Attributes.f_22284_, armorIncrease, "dragon_armor_boost");
        double attackIncrease = (double)cappedLevel * (cappedLevel < 6 ? (Double)TheLastSwordConfiguration.DRAGON_ATTACK_INCREASE_VALUE.get() : (Double)TheLastSwordConfiguration.DRAGON_ATTACK_INCREASE_VALUE_HIGH_LEVEL.get());
        EnderDragonEvent.addAttributeModifier(dragon, Attributes.f_22281_, attackIncrease, "dragon_attack_boost");
    }

    private static void addAttributeModifier(EnderDragon dragon, Attribute attribute, double value, String name) {
        AttributeInstance attr = dragon.m_21051_(attribute);
        if (attr != null) {
            UUID modifierId = UUID.nameUUIDFromBytes(name.getBytes());
            AttributeModifier modifier = new AttributeModifier(modifierId, name, value, AttributeModifier.Operation.ADDITION);
            attr.m_22125_(modifier);
        }
    }

    public static class ChallengeData
    extends SavedData {
        private int challengeCount;
        private final Set<UUID> attackerUUIDs = new HashSet<UUID>();

        public ChallengeData() {
            this.challengeCount = 0;
        }

        public ChallengeData(CompoundTag tag) {
            this.challengeCount = tag.m_128451_(EnderDragonEvent.CHALLENGE_COUNT_KEY);
            ListTag uuidList = tag.m_128437_(EnderDragonEvent.PLAYER_UUID_LIST_KEY, 10);
            for (int i = 0; i < uuidList.size(); ++i) {
                CompoundTag uuidTag = uuidList.m_128728_(i);
                UUID uuid = uuidTag.m_128342_("UUID");
                this.attackerUUIDs.add(uuid);
            }
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            tag.m_128405_(EnderDragonEvent.CHALLENGE_COUNT_KEY, this.challengeCount);
            ListTag uuidList = new ListTag();
            for (UUID uuid : this.attackerUUIDs) {
                CompoundTag uuidTag = new CompoundTag();
                uuidTag.m_128362_("UUID", uuid);
                uuidList.add((Object)uuidTag);
            }
            tag.m_128365_(EnderDragonEvent.PLAYER_UUID_LIST_KEY, (Tag)uuidList);
            return tag;
        }

        public int getChallengeCount() {
            return this.challengeCount;
        }

        public void incrementChallengeCount() {
            ++this.challengeCount;
            this.m_77762_();
        }

        public Set<UUID> getAttackerUUIDs() {
            return this.attackerUUIDs;
        }

        public void addAttacker(UUID playerUUID) {
            this.attackerUUIDs.add(playerUUID);
            this.m_77762_();
        }

        public void clearAttackers() {
            this.attackerUUIDs.clear();
            this.m_77762_();
        }

        public static ChallengeData load(CompoundTag tag) {
            return new ChallengeData(tag);
        }
    }
}

