/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.init;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.TheLastSwordMod;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.client.hud.HudConfigScreen;
import net.the_last_sword.network.ChangeModeMessage;
import net.the_last_sword.network.OpenSummonWraithMessage;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class TheLastSwordModKeyMappings {
    public static final KeyMapping CHANGE_SWORD_MODE = new KeyMapping("key.the_last_sword.change_sword_mode", 341, "key.categories.the_last_sword");
    public static final KeyMapping OPEN_HUD_CONFIG = new KeyMapping("key.the_last_sword.hudconfig", 342, "key.categories.the_last_sword");
    public static final KeyMapping OPEN_SUMMON_GUI = new KeyMapping("key.the_last_sword.open_summon_gui", InputConstants.Type.KEYSYM, 90, "key.categories.the_last_sword");

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(CHANGE_SWORD_MODE);
        event.register(OPEN_HUD_CONFIG);
        event.register(OPEN_SUMMON_GUI);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class KeyEventListener {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (event.getAction() == 0) {
                if (event.getKey() == CHANGE_SWORD_MODE.getKey().m_84873_() && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().m_91403_() != null) {
                    TheLastSwordMod.PACKET_HANDLER.sendToServer((Object)new ChangeModeMessage());
                }
                if (event.getKey() == OPEN_HUD_CONFIG.getKey().m_84873_() && Minecraft.m_91087_().f_91080_ == null && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().m_91403_() != null) {
                    Minecraft.m_91087_().m_91152_((Screen)new HudConfigScreen());
                }
                if (event.getKey() == 90 && Minecraft.m_91087_().f_91080_ == null && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().m_91403_() != null) {
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    ItemStack mainHand = player.m_21205_();
                    ItemStack offHand = player.m_21206_();
                    if (KeyEventListener.isSummonableWeapon(mainHand)) {
                        TheLastSwordMod.PACKET_HANDLER.sendToServer((Object)new OpenSummonWraithMessage(0, 0));
                    } else if (KeyEventListener.isSummonableWeapon(offHand)) {
                        TheLastSwordMod.PACKET_HANDLER.sendToServer((Object)new OpenSummonWraithMessage(1, 0));
                    }
                }
            }
        }

        private static boolean isSummonableWeapon(ItemStack itemStack) {
            if (itemStack.m_41619_()) {
                return false;
            }
            return itemStack.getCapability(ItemCapability.MODE_CAPABILITY).map(modeCap -> {
                int maxModes = modeCap.getMaxModes();
                for (int i = 0; i < maxModes; ++i) {
                    String modeKey = modeCap.getModeTextKey(i);
                    if (!"item_tooltip.the_last_sword.summon_entity_mode".equals(modeKey)) continue;
                    return true;
                }
                return false;
            }).orElse(false);
        }
    }
}

