/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.item;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.TheLastSwordMod;
import net.the_last_sword.capability.DefaultLevel;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.init.TheLastSwordModItems;
import net.the_last_sword.item.TheLastEndArmorItems;

@Mod.EventBusSubscriber(modid="the_last_sword")
public abstract class DragonCrystalArmor
extends TheLastEndArmorItems {
    private static final ConcurrentHashMap<UUID, Boolean> CRYSTAL_GUARD_TIMERS = new ConcurrentHashMap();

    public DragonCrystalArmor(ArmorItem.Type type, Item.Properties props) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type t) {
                return (new int[]{814, 1184, 1110, 962})[t.m_266308_().m_20749_()];
            }

            public int m_7366_(ArmorItem.Type t) {
                int baseDefense = (new int[]{4, 6, 6, 4})[t.m_266308_().m_20749_()];
                return baseDefense;
            }

            public int m_6646_() {
                return 22;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.armor.equip_netherite"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TheLastSwordModItems.DRAGON_CRYSTAL.get())});
            }

            public String m_6082_() {
                return "dragon_crystal_armor";
            }

            public float m_6651_() {
                return 5.0f;
            }

            public float m_6649_() {
                return 1.0f;
            }
        }, type, props.m_41486_().m_41497_(Rarity.RARE));
    }

    @Override
    protected int[] getBaseArmorValues() {
        return new int[]{4, 6, 6, 4};
    }

    @Override
    protected double getBaseToughness() {
        return 5.0;
    }

    @Override
    protected String getArmorName() {
        return "DragonCrystalArmor";
    }

    private static boolean fullSet(LivingEntity e) {
        return !e.m_6844_(EquipmentSlot.HEAD).m_41619_() && e.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)TheLastSwordModItems.DRAGON_CRYSTAL_ARMOR_HELMET.get()) && !e.m_6844_(EquipmentSlot.CHEST).m_41619_() && e.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)TheLastSwordModItems.DRAGON_CRYSTAL_ARMOR_CHESTPLATE.get()) && !e.m_6844_(EquipmentSlot.LEGS).m_41619_() && e.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)TheLastSwordModItems.DRAGON_CRYSTAL_ARMOR_LEGGINGS.get()) && !e.m_6844_(EquipmentSlot.FEET).m_41619_() && e.m_6844_(EquipmentSlot.FEET).m_150930_((Item)TheLastSwordModItems.DRAGON_CRYSTAL_ARMOR_BOOTS.get());
    }

    private void crystalGuard(LivingEntity e) {
        UUID id = e.m_20148_();
        if (DragonCrystalArmor.fullSet(e)) {
            int max = (int)e.m_21233_();
            e.m_7911_((float)max);
            if (!CRYSTAL_GUARD_TIMERS.getOrDefault(id, false).booleanValue()) {
                CRYSTAL_GUARD_TIMERS.put(id, true);
                TheLastSwordMod.queueServerWork(1200, () -> {
                    if (DragonCrystalArmor.fullSet(e)) {
                        if (e.m_6103_() < (float)max) {
                            e.m_7911_((float)max);
                            Level lvl = e.m_9236_();
                            BlockPos pos = e.m_20183_();
                            lvl.m_5594_(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.amethyst_block.chime")), SoundSource.PLAYERS, 2.0f, 1.0f);
                        }
                        this.crystalGuard(e);
                    } else {
                        CRYSTAL_GUARD_TIMERS.put(id, false);
                    }
                });
            }
        } else {
            CRYSTAL_GUARD_TIMERS.put(id, false);
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent ev) {
        boolean toDragonCrystal;
        Player p;
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof Player) || (p = (Player)livingEntity).m_9236_().m_5776_()) {
            return;
        }
        boolean fromDragonCrystal = !ev.getFrom().m_41619_() && ev.getFrom().m_41720_() instanceof DragonCrystalArmor;
        boolean bl = toDragonCrystal = !ev.getTo().m_41619_() && ev.getTo().m_41720_() instanceof DragonCrystalArmor;
        if (!fromDragonCrystal && !toDragonCrystal) {
            return;
        }
        TheLastSwordMod.queueServerWork(1, () -> DragonCrystalArmor.syncHealthToMaxHealth(p));
    }

    private static void syncHealthToMaxHealth(Player player) {
        float maxHealth;
        float currentHealth = player.m_21223_();
        if (currentHealth > (maxHealth = player.m_21233_())) {
            player.m_21153_(maxHealth);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent ev) {
        ItemStack helm;
        Item item;
        if (ev.phase != TickEvent.Phase.END || ev.player.m_9236_().m_5776_()) {
            return;
        }
        Player p = ev.player;
        if (p.f_19797_ % 20 == 0) {
            // empty if block
        }
        DragonCrystalArmor.applyArmorEffects(p);
        if (DragonCrystalArmor.fullSet((LivingEntity)p) && (item = (helm = p.m_6844_(EquipmentSlot.HEAD)).m_41720_()) instanceof DragonCrystalArmor) {
            DragonCrystalArmor a = (DragonCrystalArmor)item;
            a.crystalGuard((LivingEntity)p);
        }
    }

    private static void applyArmorEffects(Player p) {
        block6: for (EquipmentSlot s : EquipmentSlot.values()) {
            ItemStack st;
            if (s.m_20743_() != EquipmentSlot.Type.ARMOR || (st = p.m_6844_(s)).m_41619_() || !(st.m_41720_() instanceof DragonCrystalArmor)) continue;
            switch (s) {
                case HEAD: {
                    if (TheLastSwordConfiguration.getEnableNightVisionSafely()) {
                        p.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 240, 2, false, false));
                    }
                    p.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 240, 2, false, false));
                    continue block6;
                }
                case CHEST: {
                    p.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 240, 2, false, false));
                    p.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 240, 2, false, false));
                    continue block6;
                }
                case LEGS: {
                    p.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 240, 2, false, false));
                    p.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 240, 0, false, false));
                    continue block6;
                }
                case FEET: {
                    p.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 240, 0, false, false));
                    p.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 240, 2, false, false));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppingEvent e) {
        CRYSTAL_GUARD_TIMERS.clear();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return cap == ItemCapability.LEVEL_CAPABILITY ? LazyOptional.of(() -> new DefaultLevel(0)).cast() : LazyOptional.empty();
    }

    @Override
    protected void appendSpecificTooltip(ItemStack itemstack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237115_((String)this.getSpecificTooltipKey()));
        list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.dragon_crystal_armor_skill"));
        list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.dragon_crystal_armor"));
    }

    protected abstract String getSpecificTooltipKey();

    public static class Boots
    extends DragonCrystalArmor {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack s, Entity e, EquipmentSlot sl, String tp) {
            return "the_last_sword:textures/models/armor/dragon_crystal_armor_layer_1.png";
        }

        @Override
        public EquipmentSlot m_40402_() {
            return EquipmentSlot.FEET;
        }

        @Override
        protected String getSpecificTooltipKey() {
            return "item_tooltip.the_last_sword.dragon_crystal_armor_boots";
        }
    }

    public static class Leggings
    extends DragonCrystalArmor {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack s, Entity e, EquipmentSlot sl, String tp) {
            return "the_last_sword:textures/models/armor/dragon_crystal_armor_layer_2.png";
        }

        @Override
        public EquipmentSlot m_40402_() {
            return EquipmentSlot.LEGS;
        }

        @Override
        protected String getSpecificTooltipKey() {
            return "item_tooltip.the_last_sword.dragon_crystal_armor_leggings";
        }
    }

    public static class Chestplate
    extends DragonCrystalArmor {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack s, Entity e, EquipmentSlot sl, String tp) {
            return "the_last_sword:textures/models/armor/dragon_crystal_armor_layer_1.png";
        }

        @Override
        public EquipmentSlot m_40402_() {
            return EquipmentSlot.CHEST;
        }

        @Override
        protected String getSpecificTooltipKey() {
            return "item_tooltip.the_last_sword.dragon_crystal_armor_chestplate";
        }
    }

    public static class Helmet
    extends DragonCrystalArmor {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack s, Entity e, EquipmentSlot sl, String tp) {
            return "the_last_sword:textures/models/armor/dragon_crystal_armor_layer_1.png";
        }

        @Override
        public EquipmentSlot m_40402_() {
            return EquipmentSlot.HEAD;
        }

        @Override
        protected String getSpecificTooltipKey() {
            return "item_tooltip.the_last_sword.dragon_crystal_armor_helmet";
        }
    }
}

