/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.item;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.entity.DragonCrystalSwordProjectile;
import net.the_last_sword.init.TheLastSwordModItems;
import net.the_last_sword.item.TheLastEndSwordItems;
import net.the_last_sword.util.EntityUtil;

public class DragonCrystalSword
extends TheLastEndSwordItems
implements ICapabilityProvider {
    public DragonCrystalSword() {
        super(new Tier(){

            public int m_6609_() {
                return 2048;
            }

            public float m_6624_() {
                return 4.5f;
            }

            public float m_6631_() {
                return 8.0f;
            }

            public int m_6604_() {
                return 4;
            }

            public int m_6601_() {
                return 22;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TheLastSwordModItems.DRAGON_CRYSTAL.get())});
            }
        }, 3, -2.4f, new Item.Properties().m_41486_().m_41497_(Rarity.UNCOMMON), 64.0f, 4);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (EntityUtil.isOwnerOrAllyOrPet((Entity)target, attacker.m_20148_(), (Entity)attacker) || !EntityUtil.shouldAttack((Entity)target)) {
            return false;
        }
        boolean attackedSuccessfully = super.m_7579_(stack, target, attacker);
        if (!attacker.m_9236_().f_46443_) {
            stack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(levelCap -> {
                int level;
                double configValue = (level = levelCap.getLevel()) < 6 ? TheLastSwordConfiguration.getIncreaseValueSafely() : TheLastSwordConfiguration.getIncreaseValueHighLevelSafely();
                float extraDamage = (float)((double)level * configValue);
                if (extraDamage > 0.0f) {
                    target.m_6469_(new DamageSource((Holder)attacker.m_20193_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268515_), (Entity)attacker, (Entity)attacker), extraDamage);
                }
            });
        }
        return attackedSuccessfully;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_21206_().m_41720_() == Items.f_42740_ && TheLastSwordConfiguration.getBlockCancelUseSafely()) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        DragonCrystalSwordProjectile.shoot(world, (LivingEntity)player, player.m_217043_(), EntityUtil.getEntityUUID((Entity)player));
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    public static float getProjectilePhysicalDamage() {
        return 12.0f;
    }

    @Override
    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        if (!Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.shift"));
        } else {
            int itemLevel = this.getItemLevel(itemstack);
            double configValue = itemLevel < 6 ? TheLastSwordConfiguration.getIncreaseValueSafely() : TheLastSwordConfiguration.getIncreaseValueHighLevelSafely();
            float extraDamage = (float)((double)itemLevel * configValue);
            float basePhysicalDamage = this.getBasePhysicalDamage();
            list.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.dragon_crystal_sword.left_click", (Object[])new Object[]{String.format("%.0f", Float.valueOf(basePhysicalDamage)), String.format("%.0f", Float.valueOf(extraDamage))}));
            list.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.dragon_crystal_sword.right_click", (Object[])new Object[]{String.format("%.0f", Float.valueOf(DragonCrystalSword.getProjectilePhysicalDamage())), String.format("%.0f", Float.valueOf(extraDamage))}));
        }
        list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.dragon_crystal_sword"));
    }
}

