/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.item;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.entity.DragonSwordProjectile;
import net.the_last_sword.init.TheLastSwordModKeyMappings;
import net.the_last_sword.item.TheLastEndSwordItems;
import net.the_last_sword.summon.WraithSummonManager;
import net.the_last_sword.util.EntityUtil;

public class DragonSword
extends TheLastEndSwordItems
implements ICapabilityProvider {
    public DragonSword() {
        super(new Tier(){

            public int m_6609_() {
                return 4096;
            }

            public float m_6624_() {
                return 4.5f;
            }

            public float m_6631_() {
                return 96.0f;
            }

            public int m_6604_() {
                return 5;
            }

            public int m_6601_() {
                return 50;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42104_)});
            }
        }, 3, -2.4f, new Item.Properties().m_41486_().m_41497_(Rarity.RARE), 128.0f, 200);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (EntityUtil.isOwnerOrAllyOrPet((Entity)target, attacker.m_20148_(), (Entity)attacker) || !EntityUtil.shouldAttack((Entity)target)) {
            return false;
        }
        boolean attackedSuccessfully = super.m_7579_(stack, target, attacker);
        if (!attacker.m_9236_().f_46443_) {
            stack.getCapability(ItemCapability.MODE_CAPABILITY).ifPresent(modeCap -> {
                int mode = modeCap.getMode();
                stack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(levelCap -> {
                    int level;
                    double configValue = (level = levelCap.getLevel()) < 6 ? TheLastSwordConfiguration.getIncreaseValueSafely() : TheLastSwordConfiguration.getIncreaseValueHighLevelSafely();
                    float extraDamage = (float)((double)level * configValue);
                    if (extraDamage > 0.0f) {
                        if (mode == 0) {
                            target.m_6469_(new DamageSource((Holder)attacker.m_20193_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268724_), (Entity)attacker, (Entity)attacker), extraDamage);
                        } else {
                            target.m_6469_(new DamageSource((Holder)attacker.m_20193_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268482_), (Entity)attacker, (Entity)attacker), extraDamage);
                        }
                    }
                });
            });
        }
        return attackedSuccessfully;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_21206_().m_41720_() == Items.f_42740_ && TheLastSwordConfiguration.getBlockCancelUseSafely()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        stack.getCapability(ItemCapability.MODE_CAPABILITY).ifPresent(cap -> {
            int mode = cap.getMode();
            if (mode == 0) {
                if (!world.f_46443_) {
                    DragonSwordProjectile.shoot(world, (LivingEntity)player, player.m_217043_(), EntityUtil.getEntityUUID((Entity)player));
                }
            } else if (mode == 1 && !world.f_46443_) {
                WraithSummonManager.invokeWraith(player, stack, world);
            }
        });
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player) {
            int mode;
            Player player = (Player)entity;
            if (!entity.m_9236_().f_46443_ && (mode = stack.getCapability(ItemCapability.MODE_CAPABILITY).map(cap -> cap.getMode()).orElse(0).intValue()) == 1) {
                this.performForwardAreaAttack(player, stack);
            }
        }
        return super.onEntitySwing(stack, entity);
    }

    private void performForwardAreaAttack(Player player, ItemStack stack) {
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 playerPos = player.m_20182_();
        double range = 5.0;
        double width = 3.0;
        Vec3 endPos = playerPos.m_82549_(lookVec.m_82490_(range));
        AABB attackBox = new AABB(Math.min(playerPos.f_82479_, endPos.f_82479_) - width / 2.0, playerPos.f_82480_ - 1.0, Math.min(playerPos.f_82481_, endPos.f_82481_) - width / 2.0, Math.max(playerPos.f_82479_, endPos.f_82479_) + width / 2.0, playerPos.f_82480_ + 2.0, Math.max(playerPos.f_82481_, endPos.f_82481_) + width / 2.0);
        List targets = player.m_9236_().m_6443_(LivingEntity.class, attackBox, e -> e != player && e.m_6084_() && EntityUtil.shouldAttack((Entity)e) && !EntityUtil.isOwnerOrAllyOrPet((Entity)e, player.m_20148_(), (Entity)player) && !WraithSummonManager.isWraith(e.m_20148_()));
        for (LivingEntity target : targets) {
            Vec3 toTarget = target.m_20182_().m_82546_(playerPos).m_82541_();
            double dot = lookVec.m_82526_(toTarget);
            if (!(dot > 0.5)) continue;
            stack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(levelCap -> {
                int level;
                double configValue = (level = levelCap.getLevel()) < 6 ? TheLastSwordConfiguration.getIncreaseValueSafely() : TheLastSwordConfiguration.getIncreaseValueHighLevelSafely();
                float extraDamage = (float)((double)level * configValue);
                if (extraDamage > 0.0f) {
                    target.m_6469_(new DamageSource((Holder)player.m_20193_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268482_), (Entity)player, (Entity)player), extraDamage);
                }
            });
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        stack.getCapability(ItemCapability.MODE_CAPABILITY).ifPresent(cap -> {
            int mode = cap.getMode();
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.mode").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)cap.getModeTextKey(mode))));
            if (!Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.shift"));
            } else {
                stack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(levelCap -> {
                    int itemLevel = levelCap.getLevel();
                    double configValue = itemLevel < 6 ? TheLastSwordConfiguration.getIncreaseValueSafely() : TheLastSwordConfiguration.getIncreaseValueHighLevelSafely();
                    float extraDamage = (float)((double)itemLevel * configValue);
                    float basePhysicalDamage = this.getBasePhysicalDamage();
                    if (mode == 0) {
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.dragon_sword.left_click_normal", (Object[])new Object[]{String.format("%.0f", Float.valueOf(basePhysicalDamage)), String.format("%.0f", Float.valueOf(extraDamage))}));
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.dragon_sword.right_click_normal", (Object[])new Object[]{String.format("%.0f", Float.valueOf(basePhysicalDamage)), String.format("%.0f", Float.valueOf(extraDamage))}));
                    } else {
                        float attackPerLevel;
                        float healthPerLevel;
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.dragon_sword.left_click_summon", (Object[])new Object[]{"5\u683c", String.format("%.0f", Float.valueOf(basePhysicalDamage)), String.format("%.0f", Float.valueOf(extraDamage))}));
                        if (itemLevel >= 6) {
                            healthPerLevel = (float)TheLastSwordConfiguration.getSwordWraithHealthPerHighLevelSafely();
                            attackPerLevel = (float)TheLastSwordConfiguration.getSwordWraithAttackPerHighLevelSafely();
                        } else {
                            healthPerLevel = (float)TheLastSwordConfiguration.getSwordWraithHealthPerLevelSafely();
                            attackPerLevel = (float)TheLastSwordConfiguration.getSwordWraithAttackPerLevelSafely();
                        }
                        float healthBonus = (float)itemLevel * healthPerLevel;
                        float attackBonus = (float)itemLevel * attackPerLevel;
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.dragon_sword.right_click_summon", (Object[])new Object[]{String.format("%.0f", Float.valueOf(healthBonus)), String.format("%.0f", Float.valueOf(attackBonus))}));
                    }
                    tooltip.add((Component)Component.m_237119_());
                });
                if (mode == 1) {
                    stack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(levelCap -> {
                        float attackPerLevel;
                        float healthPerLevel;
                        int itemLevel = levelCap.getLevel();
                        if (itemLevel >= 6) {
                            healthPerLevel = (float)TheLastSwordConfiguration.getSwordWraithHealthPerHighLevelSafely();
                            attackPerLevel = (float)TheLastSwordConfiguration.getSwordWraithAttackPerHighLevelSafely();
                        } else {
                            healthPerLevel = (float)TheLastSwordConfiguration.getSwordWraithHealthPerLevelSafely();
                            attackPerLevel = (float)TheLastSwordConfiguration.getSwordWraithAttackPerLevelSafely();
                        }
                        float healthBonus = (float)itemLevel * healthPerLevel;
                        float attackBonus = (float)itemLevel * attackPerLevel;
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.summon_entity_mode_descr", (Object[])new Object[]{"5", String.format("%.0f", Float.valueOf(healthBonus)), String.format("%.0f", Float.valueOf(attackBonus))}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA))));
                    });
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.normal_mode_descr").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA))));
                }
            }
        });
        tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.mode_key").m_130946_(" ").m_130946_(TheLastSwordModKeyMappings.CHANGE_SWORD_MODE.getKey().m_84875_().getString()));
        tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.dragon_sword"));
    }
}

