/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.item;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.the_last_sword.attack.AbsoluteDestructionDamageSource;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.entity.TheLastSwordProjectile;
import net.the_last_sword.event.BlockEventHandler;
import net.the_last_sword.init.TheLastSwordModKeyMappings;
import net.the_last_sword.item.TheLastEndSwordItems;
import net.the_last_sword.summon.WraithSummonManager;
import net.the_last_sword.util.EntityUtil;

@Mod.EventBusSubscriber(modid="the_last_sword")
public class TheLastEndSword
extends TheLastEndSwordItems {
    private boolean returnSwing;

    public TheLastEndSword() {
        super(new Tier(){

            public int m_6609_() {
                return 0;
            }

            public float m_6624_() {
                return 1024.0f;
            }

            public float m_6631_() {
                return 196.0f;
            }

            public int m_6604_() {
                return 1024;
            }

            public int m_6601_() {
                return 1024;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42104_)});
            }
        }, 3, -2.4f, new Item.Properties().m_41486_().m_41497_(Rarity.EPIC), 1024.0f, 200);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int mode = stack.getCapability(ItemCapability.MODE_CAPABILITY).map(cap -> cap.getMode()).orElse(2);
        boolean attackedSuccessfully = super.m_7579_(stack, target, attacker);
        if (!attacker.m_9236_().f_46443_ && mode != 0) {
            stack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(levelCap -> {
                int level;
                double configValue = (level = levelCap.getLevel()) < 6 ? TheLastSwordConfiguration.getIncreaseValueSafely() : TheLastSwordConfiguration.getIncreaseValueHighLevelSafely();
                float extraDamage = (float)((double)level * configValue);
                if (extraDamage > 0.0f) {
                    if (mode == 1) {
                        DamageSource voidDamageSource = new DamageSource((Holder)attacker.m_20193_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268724_), (Entity)attacker, (Entity)attacker);
                        target.m_6469_(voidDamageSource, extraDamage);
                    } else if (mode == 2) {
                        AbsoluteDestructionDamageSource.applyAbsoluteDestructionIntelligently(target, (Entity)attacker, stack, extraDamage);
                    }
                }
            });
        }
        return attackedSuccessfully;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_21206_().m_41720_() == Items.f_42740_ && TheLastSwordConfiguration.getBlockCancelUseSafely()) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        itemstack.getCapability(ItemCapability.MODE_CAPABILITY).ifPresent(modeCapability -> {
            int mode = modeCapability.getMode();
            if (mode == 0) {
                if (!world.f_46443_) {
                    TheLastSwordProjectile.shoot(world, (LivingEntity)player, RandomSource.m_216327_());
                }
            } else if (mode == 1) {
                BlockEventHandler.performMining(player, world);
            } else if (mode == 2 && !world.f_46443_) {
                this.returnSwing = true;
                WraithSummonManager.invokeWraith(player, itemstack, world);
            }
        });
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    private void forceDropBlock(Level world, BlockPos pos, Player player) {
        List drops;
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block == Blocks.f_50016_ || block.m_49966_().m_60795_()) {
            return;
        }
        ItemStack dropStack = new ItemStack((ItemLike)block);
        if ((block instanceof DropExperienceBlock || block.m_60589_() != null) && !(drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)player.m_21205_())).isEmpty()) {
            dropStack = (ItemStack)drops.get(0);
        }
        if (!dropStack.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, dropStack);
            world.m_7967_((Entity)itemEntity);
        }
        world.m_7471_(pos, false);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (this.returnSwing) {
            this.returnSwing = false;
            return true;
        }
        if (entity instanceof Player) {
            int mode;
            Player player = (Player)entity;
            if (!entity.m_9236_().f_46443_ && (mode = stack.getCapability(ItemCapability.MODE_CAPABILITY).map(cap -> cap.getMode()).orElse(2).intValue()) == 0) {
                this.performNormalModeForwardAreaAttack(player, stack);
            }
        }
        return super.onEntitySwing(stack, entity);
    }

    private void performNormalModeForwardAreaAttack(Player player, ItemStack stack) {
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 playerPos = player.m_20182_();
        double attackRange = player.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get());
        Vec3 endPos = playerPos.m_82549_(lookVec.m_82490_(attackRange));
        AABB attackBox = new AABB(Math.min(playerPos.f_82479_, endPos.f_82479_) - attackRange / 2.0, playerPos.f_82480_ - 1.0, Math.min(playerPos.f_82481_, endPos.f_82481_) - attackRange / 2.0, Math.max(playerPos.f_82479_, endPos.f_82479_) + attackRange / 2.0, playerPos.f_82480_ + 2.0, Math.max(playerPos.f_82481_, endPos.f_82481_) + attackRange / 2.0);
        List targets = player.m_9236_().m_6443_(LivingEntity.class, attackBox, e -> e != player && e.m_6084_() && EntityUtil.shouldAttack((Entity)e) && !EntityUtil.isOwnerOrAllyOrPet((Entity)e, player.m_20148_(), (Entity)player) && !WraithSummonManager.isWraith(e.m_20148_()));
        for (LivingEntity target : targets) {
            float extraDamage;
            Vec3 toTarget = target.m_20182_().m_82546_(playerPos).m_82541_();
            double dot = lookVec.m_82526_(toTarget);
            if (!(dot > 0.5) || !((extraDamage = stack.getCapability(ItemCapability.LEVEL_CAPABILITY).map(levelCap -> {
                int level = levelCap.getLevel();
                double configValue = level < 6 ? TheLastSwordConfiguration.getIncreaseValueSafely() : TheLastSwordConfiguration.getIncreaseValueHighLevelSafely();
                return Float.valueOf((float)((double)level * configValue));
            }).orElse(Float.valueOf(0.0f)).floatValue()) > 0.0f)) continue;
            AbsoluteDestructionDamageSource.applyAbsoluteDestructionIntelligently(target, (Entity)player, stack, extraDamage);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        stack.getCapability(ItemCapability.MODE_CAPABILITY).ifPresent(cap -> {
            int mode = cap.getMode();
            tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.mode").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)cap.getModeTextKey(mode))));
            if (!Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.shift"));
            } else {
                float attackBonus;
                float healthBonus;
                int miningRadius;
                int itemLevel = this.getItemLevel(stack);
                double configValue = itemLevel < 6 ? TheLastSwordConfiguration.getIncreaseValueSafely() : TheLastSwordConfiguration.getIncreaseValueHighLevelSafely();
                float extraDamage = (float)((double)itemLevel * configValue);
                float basePhysicalDamage = this.getBasePhysicalDamage();
                switch (mode) {
                    case 0: {
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.the_last_sword.left_click_normal", (Object[])new Object[]{String.format("%.0f", Float.valueOf(basePhysicalDamage)), String.format("%.0f", Float.valueOf(extraDamage))}));
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.the_last_sword.right_click_normal", (Object[])new Object[]{"2.5\u683c", String.format("%.0f", Float.valueOf(basePhysicalDamage)), String.format("%.0f", Float.valueOf(extraDamage))}));
                        break;
                    }
                    case 1: {
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.the_last_sword.left_click_mining", (Object[])new Object[]{String.format("%.0f", Float.valueOf(basePhysicalDamage)), String.format("%.0f", Float.valueOf(extraDamage))}));
                        miningRadius = TheLastSwordConfiguration.getMiningRadiusSafely();
                        int miningArea = miningRadius * 2 + 1;
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.the_last_sword.right_click_mining", (Object[])new Object[]{miningArea + "x" + miningArea + "x" + miningArea}));
                        break;
                    }
                    case 2: {
                        float attackPerLevel;
                        float healthPerLevel;
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.the_last_sword.left_click_summon", (Object[])new Object[]{"5", String.format("%.0f", Float.valueOf(basePhysicalDamage)), String.format("%.0f", Float.valueOf(extraDamage))}));
                        if (itemLevel >= 6) {
                            healthPerLevel = (float)TheLastSwordConfiguration.getSwordWraithHealthPerHighLevelSafely();
                            attackPerLevel = (float)TheLastSwordConfiguration.getSwordWraithAttackPerHighLevelSafely();
                        } else {
                            healthPerLevel = (float)TheLastSwordConfiguration.getSwordWraithHealthPerLevelSafely();
                            attackPerLevel = (float)TheLastSwordConfiguration.getSwordWraithAttackPerLevelSafely();
                        }
                        healthBonus = (float)itemLevel * healthPerLevel;
                        attackBonus = (float)itemLevel * attackPerLevel;
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.the_last_sword.right_click_summon", (Object[])new Object[]{String.format("%.0f", Float.valueOf(healthBonus)), String.format("%.0f", Float.valueOf(attackBonus))}));
                    }
                }
                tooltip.add((Component)Component.m_237119_());
                switch (mode) {
                    case 1: {
                        miningRadius = TheLastSwordConfiguration.getMiningRadiusSafely();
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.powerful_mining_mode_descr", (Object[])new Object[]{miningRadius}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA))));
                        break;
                    }
                    case 2: {
                        float attackPerLevel;
                        float healthPerLevel;
                        if (itemLevel >= 6) {
                            healthPerLevel = (float)TheLastSwordConfiguration.getSwordWraithHealthPerHighLevelSafely();
                            attackPerLevel = (float)TheLastSwordConfiguration.getSwordWraithAttackPerHighLevelSafely();
                        } else {
                            healthPerLevel = (float)TheLastSwordConfiguration.getSwordWraithHealthPerLevelSafely();
                            attackPerLevel = (float)TheLastSwordConfiguration.getSwordWraithAttackPerLevelSafely();
                        }
                        healthBonus = (float)itemLevel * healthPerLevel;
                        attackBonus = (float)itemLevel * attackPerLevel;
                        tooltip.add((Component)Component.m_237110_((String)"item_tooltip.the_last_sword.summon_entity_mode_descr", (Object[])new Object[]{"6", String.format("%.0f", Float.valueOf(healthBonus)), String.format("%.0f", Float.valueOf(attackBonus))}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA))));
                        break;
                    }
                    default: {
                        tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.normal_mode_descr").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA))));
                    }
                }
            }
        });
        tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.mode_key").m_130946_(" ").m_130946_(TheLastSwordModKeyMappings.CHANGE_SWORD_MODE.getKey().m_84875_().getString()));
        tooltip.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.the_last_sword"));
    }

    @Mod.EventBusSubscriber(modid="the_last_sword")
    public static class TheLastSwordTickHandler {
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            Player player = event.player;
            boolean hasSword = TheLastSwordTickHandler.hasTheLastEndSwordInInventory(player);
            if (!player.m_7500_() && !player.m_5833_()) {
                boolean allowFlying = TheLastSwordConfiguration.getAllowFlyingSafely();
                if (hasSword) {
                    if (allowFlying && !player.m_150110_().f_35936_) {
                        player.m_150110_().f_35936_ = true;
                        player.getPersistentData().m_128379_("TheLastSwordFly", true);
                        player.m_6885_();
                    }
                } else if (player.getPersistentData().m_128471_("TheLastSwordFly")) {
                    player.m_150110_().f_35936_ = false;
                    player.m_150110_().f_35935_ = false;
                    player.getPersistentData().m_128473_("TheLastSwordFly");
                    player.m_6885_();
                }
            }
            TheLastSwordTickHandler.manageDefenseLevel(player, hasSword);
        }

        public static boolean hasTheLastEndSwordInInventory(Player player) {
            if (player == null) {
                return false;
            }
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!(stack.m_41720_() instanceof TheLastEndSword)) continue;
                return true;
            }
            ItemStack offhand = player.m_21206_();
            return offhand.m_41720_() instanceof TheLastEndSword;
        }

        private static void manageDefenseLevel(Player player, boolean hasSword) {
            int currentLevel;
            boolean isTracked = DefenceManager.isTracked((LivingEntity)player);
            int n = currentLevel = isTracked ? DefenceManager.getLevel((LivingEntity)player) : 0;
            if (hasSword) {
                if (!isTracked) {
                    DefenceManager.register((LivingEntity)player, 2);
                } else if (currentLevel < 2) {
                    DefenceManager.pullFromEntity((LivingEntity)player, 2);
                } else if (currentLevel > 2) {
                    DefenceManager.pullFromEntity((LivingEntity)player, currentLevel);
                } else {
                    DefenceManager.pullFromEntity((LivingEntity)player, 2);
                }
            } else if (isTracked && TheLastSwordTickHandler.isSwordDrivenDefense(currentLevel)) {
                DefenceManager.clear((LivingEntity)player);
            }
        }

        private static boolean isSwordDrivenDefense(int level) {
            return level == 2;
        }
    }
}

