/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.the_last_sword.capability.DefaultExtraAttackDamage;
import net.the_last_sword.capability.DefaultLevel;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import org.jetbrains.annotations.NotNull;

public abstract class TheLastEndSwordItems
extends SwordItem
implements ICapabilityProvider {
    private final float destroySpeed;
    private final int toolLevel;

    public TheLastEndSwordItems(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties, float destroySpeed, int toolLevel) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
        this.destroySpeed = destroySpeed;
        this.toolLevel = toolLevel;
    }

    public boolean m_8096_(BlockState blockstate) {
        int tier = this.toolLevel;
        if (tier < 3 && blockstate.m_204336_(BlockTags.f_144284_)) {
            return false;
        }
        if (tier < 2 && blockstate.m_204336_(BlockTags.f_144285_)) {
            return false;
        }
        return tier >= 1 || !blockstate.m_204336_(BlockTags.f_144286_);
    }

    public float m_8102_(ItemStack itemstack, BlockState blockstate) {
        return this.destroySpeed;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_HOE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public float getBasePhysicalDamage() {
        return this.m_43314_().m_6631_() + 4.0f;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        ItemStack stack = this.m_5456_().m_7968_();
        if (cap == ItemCapability.LEVEL_CAPABILITY) {
            return LazyOptional.of(() -> {
                CompoundTag nbt = stack.m_41784_();
                if (!nbt.m_128441_("level")) {
                    nbt.m_128405_("level", 0);
                }
                return new DefaultLevel(nbt.m_128451_("level"));
            }).cast();
        }
        if (cap == ItemCapability.EXTRA_ATTACK_DAMAGE_CAPABILITY) {
            return LazyOptional.of(() -> {
                CompoundTag nbt = stack.m_41784_();
                if (!nbt.m_128441_("extraAttackDamage")) {
                    nbt.m_128350_("extraAttackDamage", 0.0f);
                }
                return new DefaultExtraAttackDamage(nbt.m_128451_("extraAttackDamage"));
            }).cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = super.getShareTag(stack) != null ? super.getShareTag(stack) : new CompoundTag();
        stack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(swordLevel -> {
            if (tag != null) {
                tag.m_128405_("level", swordLevel.getLevel());
            }
        });
        stack.getCapability(ItemCapability.EXTRA_ATTACK_DAMAGE_CAPABILITY).ifPresent(extraAttack -> {
            if (tag != null) {
                tag.m_128350_("extraAttackDamage", extraAttack.getExtraAttackDamage());
            }
        });
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag tag) {
        super.readShareTag(stack, tag);
        if (tag != null) {
            stack.getCapability(ItemCapability.LEVEL_CAPABILITY).ifPresent(swordLevel -> swordLevel.setLevel(tag.m_128451_("level")));
            stack.getCapability(ItemCapability.EXTRA_ATTACK_DAMAGE_CAPABILITY).ifPresent(extraAttack -> extraAttack.setExtraAttackDamage(tag.m_128457_("extraAttackDamage")));
        }
    }

    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        int itemLevel = this.getItemLevel(itemstack);
        list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.level").m_130946_(" " + itemLevel));
        double configValue = itemLevel < 6 ? TheLastSwordConfiguration.getIncreaseValueSafely() : TheLastSwordConfiguration.getIncreaseValueHighLevelSafely();
        float realTimeExtraDamage = (float)((double)itemLevel * configValue);
        list.add((Component)Component.m_237115_((String)"item_tooltip.the_last_sword.extra_attack_damage").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAA00FF))).m_130946_(" " + String.format("%.0f", Float.valueOf(realTimeExtraDamage))));
    }

    protected int getItemLevel(ItemStack itemstack) {
        if (itemstack.m_41782_() && itemstack.m_41783_().m_128441_("level")) {
            return itemstack.m_41783_().m_128451_("level");
        }
        if (itemstack.getCapability(ItemCapability.LEVEL_CAPABILITY).isPresent()) {
            return itemstack.getCapability(ItemCapability.LEVEL_CAPABILITY).map(levelCap -> levelCap.getLevel()).orElse(0);
        }
        return 0;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.m_6081_(new ItemStack((ItemLike)Items.f_42393_).m_41720_().m_7968_()) || enchantment.m_6081_(new ItemStack((ItemLike)Items.f_42395_).m_41720_().m_7968_()) || enchantment.m_6081_(new ItemStack((ItemLike)Items.f_42411_).m_41720_().m_7968_()) || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean isRepairable(ItemStack stack) {
        return true;
    }

    public boolean m_41386_(DamageSource damageSource) {
        return false;
    }
}

