/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.mixin;

import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.the_last_sword.item.DragonArmor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EndCrystal.class})
public class EndCrystalMixin {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        EndCrystal crystal = (EndCrystal)this;
        if (crystal.m_9236_().m_5776_()) {
            return;
        }
        AABB searchBox = new AABB(crystal.m_20185_() - 8.0, crystal.m_20186_() - 8.0, crystal.m_20189_() - 8.0, crystal.m_20185_() + 8.0, crystal.m_20186_() + 8.0, crystal.m_20189_() + 8.0);
        List nearbyPlayers = crystal.m_9236_().m_45976_(Player.class, searchBox);
        Player targetPlayer = null;
        for (Player player : nearbyPlayers) {
            if (!this.hasDragonArmor(player) || !this.hasItemsNeedCharge(player)) continue;
            targetPlayer = player;
            break;
        }
        if (targetPlayer != null) {
            crystal.m_31052_(targetPlayer.m_20183_().m_7495_());
            this.chargePlayerItems(targetPlayer);
        } else if (crystal.m_31064_() != null) {
            crystal.m_31052_(null);
        }
    }

    private boolean hasDragonArmor(Player player) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = player.m_6844_(slot)).m_41619_() || !(stack.m_41720_() instanceof DragonArmor)) continue;
            return true;
        }
        return false;
    }

    private boolean hasItemsNeedCharge(Player player) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            boolean needsCharge;
            ItemStack stack = player.m_6844_(slot);
            if (stack.m_41619_() || !(needsCharge = stack.getCapability(ForgeCapabilities.ENERGY).map(energy -> energy.getEnergyStored() < energy.getMaxEnergyStored()).orElse(false).booleanValue())) continue;
            return true;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            boolean needsCharge;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !(needsCharge = stack.getCapability(ForgeCapabilities.ENERGY).map(energy -> energy.getEnergyStored() < energy.getMaxEnergyStored()).orElse(false).booleanValue())) continue;
            return true;
        }
        return false;
    }

    private void chargePlayerItems(Player player) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = player.m_6844_(slot);
            if (stack.m_41619_()) continue;
            stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> {
                if (energy.getEnergyStored() < energy.getMaxEnergyStored()) {
                    energy.receiveEnergy(200, false);
                }
            });
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_()) continue;
            stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> {
                if (energy.getEnergyStored() < energy.getMaxEnergyStored()) {
                    energy.receiveEnergy(200, false);
                }
            });
        }
    }
}

