/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityLookup;
import net.the_last_sword.attack.AttackEffectManager;
import net.the_last_sword.defence.DefenceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityLookup.class})
public class EntityLookupMixin {
    @Inject(method={"add"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$interceptLookupAdd(EntityAccess entity, CallbackInfo ci) {
        try {
            Entity realEntity;
            if (entity instanceof Entity && AttackEffectManager.isReviveBan(realEntity = (Entity)entity)) {
                ci.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventLookupRemoval(EntityAccess entity, CallbackInfo ci) {
        try {
            LivingEntity livingEntity;
            int level;
            if (entity instanceof LivingEntity && (level = DefenceManager.getLevel(livingEntity = (LivingEntity)entity)) >= 3) {
                ci.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

