/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.mixin;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.init.TheLastSwordModMobEffects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class}, priority=1024)
public class EntityMixin {
    @Inject(method={"kill"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventKill(CallbackInfo ci) {
        Entity self = (Entity)this;
        if (self instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)self;
            int level = DefenceManager.isTracked(livingEntity) ? DefenceManager.getLevel(livingEntity) : 0;
            float storedHealth = DefenceManager.getStoredHealth(livingEntity);
            if (level >= 1 && storedHealth > 0.0f) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"discard"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventDiscard(CallbackInfo ci) {
        Entity self = (Entity)this;
        if (self instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)self;
            int level = DefenceManager.isTracked(livingEntity) ? DefenceManager.getLevel(livingEntity) : 0;
            float storedHealth = DefenceManager.getStoredHealth(livingEntity);
            if (level >= 1 && storedHealth > 0.0f) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventRemove(Entity.RemovalReason reason, CallbackInfo ci) {
        Entity self = (Entity)this;
        if (!(self instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)self;
        int level = DefenceManager.getLevel(living);
        if (!(level <= 1 || living instanceof Player && reason == Entity.RemovalReason.CHANGED_DIMENSION)) {
            ci.cancel();
        }
    }

    @Inject(method={"setRemoved"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventSetRemoved(Entity.RemovalReason reason, CallbackInfo ci) {
        Entity self = (Entity)this;
        if (!(self instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)self;
        int level = DefenceManager.getLevel(living);
        if (!(level <= 1 || living instanceof Player && reason == Entity.RemovalReason.CHANGED_DIMENSION)) {
            ci.cancel();
        }
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventStopRiding(CallbackInfo ci) {
        LivingEntity livingEntity;
        int level;
        Entity self = (Entity)this;
        if (self instanceof LivingEntity && (level = DefenceManager.getLevel(livingEntity = (LivingEntity)self)) >= 3) {
            ci.cancel();
        }
    }

    @Inject(method={"removeVehicle"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventRemoveVehicle(CallbackInfo ci) {
        LivingEntity livingEntity;
        int level;
        Entity self = (Entity)this;
        if (self instanceof LivingEntity && (level = DefenceManager.getLevel(livingEntity = (LivingEntity)self)) >= 3) {
            ci.cancel();
        }
    }

    @Inject(method={"ejectPassengers"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventEjectPassengers(CallbackInfo ci) {
        LivingEntity livingEntity;
        int level;
        Entity self = (Entity)this;
        if (self instanceof LivingEntity && (level = DefenceManager.getLevel(livingEntity = (LivingEntity)self)) >= 3) {
            ci.cancel();
        }
    }

    @Inject(method={"setLevelCallback"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$preventSetLevelCallback(EntityInLevelCallback callback, CallbackInfo ci) {
        LivingEntity livingEntity;
        int level;
        Entity self = (Entity)this;
        if (self instanceof LivingEntity && (level = DefenceManager.getLevel(livingEntity = (LivingEntity)self)) >= 3 && callback == EntityInLevelCallback.f_156799_) {
            ci.cancel();
        }
    }

    @Inject(method={"isInWall"}, at={@At(value="HEAD")}, cancellable=true)
    private void theLastSword$phasingNotInWall(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity;
        Entity self = (Entity)this;
        if (self instanceof LivingEntity && (livingEntity = (LivingEntity)self).m_21023_((MobEffect)TheLastSwordModMobEffects.PHASING.get())) {
            cir.setReturnValue((Object)false);
        }
    }
}

