/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.util.EntityQueryContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public class LevelMixin {
    @Inject(at={@At(value="RETURN")}, method={"getEntities(Lnet/minecraft/world/level/entity/EntityTypeTest;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, cancellable=true)
    private <T extends Entity> void filterProtectedEntitiesFromTypeTestScan(EntityTypeTest<Entity, T> entityTypeTest, AABB area, Predicate<? super T> predicate, CallbackInfoReturnable<List<T>> cir) {
        if (EntityQueryContext.isInternalModQuery()) {
            return;
        }
        List originalEntities = (List)cir.getReturnValue();
        if (originalEntities == null) {
            return;
        }
        ArrayList<Entity> filteredEntities = new ArrayList<Entity>();
        for (Entity entity : originalEntities) {
            int defenseLevel;
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && DefenceManager.isTracked(livingEntity = (LivingEntity)entity) && (defenseLevel = DefenceManager.getLevel(livingEntity)) >= 3) continue;
            filteredEntities.add(entity);
        }
        cir.setReturnValue(filteredEntities);
    }

    @Inject(at={@At(value="RETURN")}, method={"getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, cancellable=true)
    private void filterProtectedEntitiesFromEntityScan(Entity except, AABB area, Predicate<? super Entity> predicate, CallbackInfoReturnable<List<Entity>> cir) {
        if (EntityQueryContext.isInternalModQuery()) {
            return;
        }
        List originalEntities = (List)cir.getReturnValue();
        if (originalEntities == null) {
            return;
        }
        ArrayList<Entity> filteredEntities = new ArrayList<Entity>();
        for (Entity entity : originalEntities) {
            int defenseLevel;
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && DefenceManager.isTracked(livingEntity = (LivingEntity)entity) && (defenseLevel = DefenceManager.getLevel(livingEntity)) >= 3) continue;
            filteredEntities.add(entity);
        }
        cir.setReturnValue(filteredEntities);
    }
}

