/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.mixin;

import java.util.ArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.the_last_sword.attack.AttackEffectManager;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.util.EntityQueryContext;
import net.the_last_sword.util.TheLastSwordLogger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
public class ServerLevelMixin {
    @Unique
    private static int theLastSword$reviveBanTickCounter = 0;

    @Inject(at={@At(value="HEAD")}, method={"addEntity"}, cancellable=true)
    private void addEntity(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (AttackEffectManager.isReviveBan(entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addFreshEntity"}, cancellable=true)
    private void addFreshEntity(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (AttackEffectManager.isReviveBan(entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void onWorldTick(CallbackInfo ci) {
        ServerLevel level = (ServerLevel)this;
        try {
            DefenceManager.worldTick(level);
            AttackEffectManager.worldTick(level);
            if (!level.m_46472_().equals((Object)ServerLevel.f_46428_)) {
                return;
            }
            if (++theLastSword$reviveBanTickCounter >= 20) {
                theLastSword$reviveBanTickCounter = 0;
                AttackEffectManager.tickReviveBanSystem();
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Error in manager tick processing", e);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getAllEntities"}, cancellable=true)
    private void filterProtectedEntitiesFromScan(CallbackInfoReturnable<Iterable<Entity>> cir) {
        if (EntityQueryContext.isInternalModQuery()) {
            return;
        }
        Iterable originalEntities = (Iterable)cir.getReturnValue();
        if (originalEntities == null) {
            return;
        }
        ArrayList<Entity> filteredEntities = new ArrayList<Entity>();
        for (Entity entity : originalEntities) {
            int defenseLevel;
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && DefenceManager.isTracked(livingEntity = (LivingEntity)entity) && (defenseLevel = DefenceManager.getLevel(livingEntity)) >= 3) continue;
            filteredEntities.add(entity);
        }
        cir.setReturnValue(filteredEntities);
    }
}

