/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.network;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.the_last_sword.recipe.ConfigDragonCrystalSmithingManager;
import net.the_last_sword.recipe.DragonCrystalSmithingRecipe;
import net.the_last_sword.recipe.DragonCrystalSmithingSerializer;

public class ConfigRecipeSyncPacket {
    private final Map<String, String> recipeData;
    private static final Gson GSON = new Gson();

    public ConfigRecipeSyncPacket(Map<String, String> recipeData) {
        this.recipeData = recipeData;
    }

    public static void encode(ConfigRecipeSyncPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.recipeData.size());
        for (Map.Entry<String, String> entry : packet.recipeData.entrySet()) {
            buf.m_130070_(entry.getKey());
            buf.m_130070_(entry.getValue());
        }
    }

    public static ConfigRecipeSyncPacket decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashMap<String, String> recipeData = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buf.m_130277_();
            String value = buf.m_130277_();
            recipeData.put(key, value);
        }
        return new ConfigRecipeSyncPacket(recipeData);
    }

    public static void handle(ConfigRecipeSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                ConfigRecipeSyncPacket.handleClientSync(packet.recipeData);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void handleClientSync(Map<String, String> recipeData) {
        HashMap<ResourceLocation, DragonCrystalSmithingRecipe> clientRecipes = new HashMap<ResourceLocation, DragonCrystalSmithingRecipe>();
        for (Map.Entry<String, String> entry : recipeData.entrySet()) {
            try {
                JsonObject json;
                ResourceLocation recipeId = new ResourceLocation("the_last_sword", entry.getKey());
                DragonCrystalSmithingRecipe recipe = DragonCrystalSmithingSerializer.INSTANCE.fromJson(recipeId, json = (JsonObject)GSON.fromJson(entry.getValue(), JsonObject.class));
                if (recipe == null) continue;
                clientRecipes.put(recipeId, recipe);
            }
            catch (Exception exception) {}
        }
        ConfigDragonCrystalSmithingManager.updateClientCache(clientRecipes);
    }
}

