/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.network;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.the_last_sword.TheLastSwordMod;
import net.the_last_sword.capability.ItemCapability;
import net.the_last_sword.recipe.ConfigDragonCrystalSmithingManager;
import net.the_last_sword.recipe.DragonCrystalSmithingRecipe;
import net.the_last_sword.world.inventory.DragonCrystalSmithingTableGuiMenu;

public class JEISyncPacket {
    private final int x;
    private final int y;
    private final int z;
    private final ItemStack slot0Item;
    private final ItemStack slot1Item;
    private final ItemStack slot2Item;

    public JEISyncPacket(int x, int y, int z, ItemStack slot0, ItemStack slot1, ItemStack slot2) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.slot0Item = slot0.m_41777_();
        this.slot1Item = slot1.m_41777_();
        this.slot2Item = slot2.m_41777_();
    }

    public JEISyncPacket(FriendlyByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.slot0Item = buffer.m_130267_();
        this.slot1Item = buffer.m_130267_();
        this.slot2Item = buffer.m_130267_();
    }

    public static void buffer(JEISyncPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.m_130055_(message.slot0Item);
        buffer.m_130055_(message.slot1Item);
        buffer.m_130055_(message.slot2Item);
    }

    public static void handler(JEISyncPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            Level world = entity.m_9236_();
            if (!world.m_46805_(new BlockPos(message.x, message.y, message.z))) {
                return;
            }
            AbstractContainerMenu patt2534$temp = entity.f_36096_;
            if (patt2534$temp instanceof DragonCrystalSmithingTableGuiMenu) {
                DragonCrystalSmithingTableGuiMenu menu = (DragonCrystalSmithingTableGuiMenu)patt2534$temp;
                JEISyncPacket.moveItemFromInventoryToSlot((Player)entity, menu, message.slot0Item, 0);
                JEISyncPacket.moveItemFromInventoryToSlot((Player)entity, menu, message.slot1Item, 1);
                JEISyncPacket.moveItemFromInventoryToSlot((Player)entity, menu, message.slot2Item, 2);
                if (!(message.slot0Item.m_41619_() || message.slot1Item.m_41619_() || message.slot2Item.m_41619_())) {
                    DragonCrystalSmithingRecipe recipe = JEISyncPacket.findMatchingRecipe(world, message.slot0Item, message.slot1Item, message.slot2Item);
                    if (recipe != null) {
                        TransientCraftingContainer tempContainer = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

                            public ItemStack m_7648_(Player player, int index) {
                                return ItemStack.f_41583_;
                            }

                            public boolean m_6875_(Player player) {
                                return false;
                            }
                        }, 3, 1);
                        tempContainer.m_6836_(0, message.slot0Item);
                        tempContainer.m_6836_(1, message.slot1Item);
                        tempContainer.m_6836_(2, message.slot2Item);
                        ItemStack result = recipe.assemble((CraftingContainer)tempContainer, world.m_9598_());
                        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)message.slot1Item);
                        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)result);
                        menu.m_38853_(3).m_5852_(result);
                        menu.m_38946_();
                    } else {
                        menu.m_38853_(3).m_5852_(ItemStack.f_41583_);
                        menu.m_38946_();
                    }
                } else {
                    menu.m_38853_(3).m_5852_(ItemStack.f_41583_);
                    menu.m_38946_();
                }
            }
        });
        context.setPacketHandled(true);
    }

    private static DragonCrystalSmithingRecipe findMatchingRecipe(Level world, ItemStack template, ItemStack input, ItemStack addition) {
        TransientCraftingContainer craftingContainer = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public ItemStack m_7648_(Player player, int index) {
                return ItemStack.f_41583_;
            }

            public boolean m_6875_(Player player) {
                return false;
            }
        }, 3, 1);
        craftingContainer.m_6836_(0, template);
        craftingContainer.m_6836_(1, input);
        craftingContainer.m_6836_(2, addition);
        return ConfigDragonCrystalSmithingManager.findMatchingRecipe(craftingContainer, world);
    }

    private static void moveItemFromInventoryToSlot(Player player, DragonCrystalSmithingTableGuiMenu menu, ItemStack targetItem, int slotIndex) {
        if (targetItem.m_41619_()) {
            return;
        }
        ItemStack currentSlotItem = menu.m_38853_(slotIndex).m_7993_();
        if (!currentSlotItem.m_41619_() && ItemStack.m_150942_((ItemStack)currentSlotItem, (ItemStack)targetItem)) {
            return;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack invStack = player.m_150109_().m_8020_(i);
            if (invStack.m_41619_() || !ItemStack.m_41656_((ItemStack)invStack, (ItemStack)targetItem) || !JEISyncPacket.itemsHaveSameLevel(invStack, targetItem)) continue;
            ItemStack singleItem = invStack.m_41777_();
            singleItem.m_41764_(1);
            if (!currentSlotItem.m_41619_()) {
                player.m_150109_().m_150079_(currentSlotItem);
                menu.m_38853_(slotIndex).m_5852_(ItemStack.f_41583_);
            }
            menu.m_38853_(slotIndex).m_5852_(singleItem);
            invStack.m_41774_(1);
            if (invStack.m_41619_()) {
                player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            } else {
                player.m_150109_().m_6836_(i, invStack);
            }
            return;
        }
    }

    private static boolean itemsHaveSameLevel(ItemStack stack1, ItemStack stack2) {
        int level2;
        int level1 = JEISyncPacket.getItemLevel(stack1);
        return level1 == (level2 = JEISyncPacket.getItemLevel(stack2));
    }

    private static int getItemLevel(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("level")) {
            return itemStack.m_41783_().m_128451_("level");
        }
        if (itemStack.getCapability(ItemCapability.LEVEL_CAPABILITY).isPresent()) {
            return itemStack.getCapability(ItemCapability.LEVEL_CAPABILITY).map(cap -> cap.getLevel()).orElse(0);
        }
        return 0;
    }

    public static void registerMessage(FMLCommonSetupEvent event) {
        if (ModList.get().isLoaded("jei")) {
            TheLastSwordMod.addNetworkMessage(JEISyncPacket.class, JEISyncPacket::buffer, JEISyncPacket::new, JEISyncPacket::handler);
        }
    }
}

