/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.network;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.the_last_sword.TheLastSwordMod;
import net.the_last_sword.event.BlockPreviewRenderer;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PreviewBlocksPacket {
    private final Set<BlockPos> blocks;

    public PreviewBlocksPacket(Set<BlockPos> blocks) {
        this.blocks = new HashSet<BlockPos>(blocks);
    }

    public PreviewBlocksPacket(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.blocks = new HashSet<BlockPos>();
        for (int i = 0; i < size; ++i) {
            this.blocks.add(buf.m_130135_());
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.blocks.size());
        for (BlockPos pos : this.blocks) {
            buf.m_130064_(pos);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
                BlockPreviewRenderer.setPreviewBlocks(this.blocks);
            }
        });
        context.get().setPacketHandled(true);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheLastSwordMod.addNetworkMessage(PreviewBlocksPacket.class, PreviewBlocksPacket::encode, PreviewBlocksPacket::new, PreviewBlocksPacket::handle);
    }
}

