/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.network;

import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.the_last_sword.TheLastSwordMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SyncInventoryPacket {
    private final ItemStack[] items;
    private final int playerId;

    public SyncInventoryPacket(int playerId, NonNullList<ItemStack> items) {
        this.playerId = playerId;
        this.items = (ItemStack[])items.toArray((Object[])new ItemStack[0]);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.playerId);
        buffer.m_130130_(this.items.length);
        for (ItemStack stack : this.items) {
            buffer.m_130055_(stack);
        }
    }

    public SyncInventoryPacket(FriendlyByteBuf buffer) {
        int playerId = buffer.m_130242_();
        int size = buffer.m_130242_();
        ItemStack[] items = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            items[i] = buffer.m_130267_();
        }
        this.items = items;
        this.playerId = playerId;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer entity = ((NetworkEvent.Context)ctx.get()).getSender();
            if (entity != null) {
                for (int i = 0; i < this.items.length; ++i) {
                    entity.f_36093_.m_6836_(i, this.items[i]);
                }
                entity.f_36093_.m_6596_();
                entity.f_36095_.m_38946_();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheLastSwordMod.addNetworkMessage(SyncInventoryPacket.class, SyncInventoryPacket::encode, SyncInventoryPacket::new, SyncInventoryPacket::handle);
    }
}

