/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.test;

import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.the_last_sword.attack.AttackEffectManager;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.entity.TheLastEndEntity;
import net.the_last_sword.init.TheLastSwordModEntities;
import net.the_last_sword.init.TheLastSwordModMobEffects;
import net.the_last_sword.util.EntityUtil;

public class TestEntity
extends PathfinderMob {
    private static final int GRADIENT_START = 0x800080;
    private static final int GRADIENT_END = 0;
    private final ServerBossEvent bossInfo = new ServerBossEvent((Component)Component.m_237119_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_20);
    private static final ConcurrentHashMap<EntityType<?>, Long> bannedEntities = new ConcurrentHashMap();
    private boolean isSelfMoving = false;

    private static MutableComponent gradientBold(String txt) {
        MutableComponent result = Component.m_237113_((String)"");
        int len = txt.length();
        for (int i = 0; i < len; ++i) {
            float t = len == 1 ? 0.0f : (float)i / (float)(len - 1);
            int rgb = TestEntity.blend(0x800080, 0, t);
            result.m_7220_((Component)Component.m_237113_((String)String.valueOf(txt.charAt(i))).m_130938_(st -> st.m_131136_(Boolean.valueOf(true)).m_131148_(TextColor.m_131266_((int)rgb))));
        }
        return result;
    }

    private static int blend(int c1, int c2, float t) {
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = Mth.m_14045_((int)((int)((float)r1 + (float)(r2 - r1) * t)), (int)0, (int)255);
        int g = Mth.m_14045_((int)((int)((float)g1 + (float)(g2 - g1) * t)), (int)0, (int)255);
        int b = Mth.m_14045_((int)((int)((float)b1 + (float)(b2 - b1) * t)), (int)0, (int)255);
        return r << 16 | g << 8 | b;
    }

    public TestEntity(PlayMessages.SpawnEntity pkt, Level lvl) {
        this((EntityType<TestEntity>)((EntityType)TheLastSwordModEntities.TEST_ENTITY.get()), lvl);
    }

    public TestEntity(EntityType<TestEntity> type, Level lvl) {
        super(type, lvl);
        this.m_274367_(2.0f);
        this.f_21364_ = 100;
        this.m_21557_(false);
        this.m_21530_();
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Component m_5446_() {
        String raw = Component.m_237115_((String)"entity.the_last_sword.test_entity").getString();
        return TestEntity.gradientBold(raw);
    }

    protected void m_8099_() {
        this.m_21573_().m_26575_().m_77355_(true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ender_dragon.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ender_dragon.death"));
    }

    public void m_6457_(ServerPlayer p) {
        super.m_6457_(p);
        this.bossInfo.m_6543_(p);
    }

    public void m_6452_(ServerPlayer p) {
        super.m_6452_(p);
        this.bossInfo.m_6539_(p);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6075_() {
        Level level;
        super.m_6075_();
        EntityUtil.TheLastEndSetHealth((LivingEntity)this, 1024.0f);
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = this.m_20182_();
            AABB box = new AABB(center, center).m_82400_(1024.0);
            serverLevel.m_6443_(Entity.class, box, e -> e != this && !(e instanceof Player)).forEach(target -> {
                if (target instanceof TheLastEndEntity) {
                    TheLastEndEntity theLastEndEntity = (TheLastEndEntity)((Object)target);
                    theLastEndEntity.setIsDead(true);
                    theLastEndEntity.safeRemove();
                    return;
                }
                if (target instanceof TestEntity) {
                    TestEntity testEntity = (TestEntity)((Object)target);
                    testEntity.safeRemove();
                    return;
                }
                if (target instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)target;
                    AttackEffectManager.addReviveBan((Entity)le);
                }
                EntityUtil.TheLastEndRemove(target, Entity.RemovalReason.KILLED);
            });
        }
        if (!this.m_9236_().f_46443_) {
            this.m_7292_(new MobEffectInstance((MobEffect)TheLastSwordModMobEffects.PHASING.get(), 240, 0, false, false));
        }
    }

    public void m_6667_(DamageSource cause) {
    }

    public void m_6074_() {
    }

    public boolean m_21224_() {
        return false;
    }

    protected void m_6153_() {
    }

    protected void m_21226_() {
    }

    public void m_142687_(Entity.RemovalReason reason) {
    }

    public float m_21233_() {
        return 1024.0f;
    }

    public float m_21223_() {
        return this.m_21233_();
    }

    public void m_21153_(float health) {
        EntityUtil.TheLastEndSetHealth((LivingEntity)this, health);
    }

    public void m_5634_(float amt) {
        this.m_21153_(this.m_21233_());
    }

    public void m_142467_(Entity.RemovalReason reason) {
    }

    public void m_6842_(boolean invisible) {
    }

    public boolean m_21525_() {
        return false;
    }

    public void m_21557_(boolean noAi) {
    }

    protected boolean m_8028_() {
        return false;
    }

    public void m_6043_() {
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity e) {
    }

    protected void m_6138_() {
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_147240_(double s, double x, double z) {
    }

    public void m_7023_(Vec3 v) {
    }

    public void m_20256_(Vec3 m) {
    }

    public void m_7678_(double x, double y, double z, float yaw, float pitch) {
    }

    public void safeRemove() {
        Level level;
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundRemoveEntitiesPacket removePacket = new ClientboundRemoveEntitiesPacket(new int[]{this.m_19879_()});
            for (ServerPlayer player : serverLevel.m_7654_().m_6846_().m_11314_()) {
                player.f_8906_.m_9829_((Packet)removePacket);
            }
        }
        DefenceManager.clear((LivingEntity)this);
        EntityUtil.TheLastEndRemove((Entity)this, Entity.RemovalReason.KILLED);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 1024.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22281_, 3.4028234663852886E38).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 3.4028234663852886E38).m_22268_(Attributes.f_22282_, 3.4028234663852886E38);
    }

    public static void init() {
    }

    @Mod.EventBusSubscriber(modid="the_last_sword", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static final class EntityRegisterHook {
        @SubscribeEvent
        public static void TheLastSwordTestEntityOnJoin(EntityJoinLevelEvent e) {
            TestEntity te;
            if (e.getLevel().m_5776_()) {
                return;
            }
            Entity entity = e.getEntity();
            if (entity instanceof TestEntity && !DefenceManager.isTracked((LivingEntity)(te = (TestEntity)entity))) {
                DefenceManager.register((LivingEntity)te, 3);
            }
        }
    }
}

