/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.the_last_sword.attack.AttackEffectManager;
import net.the_last_sword.compat.CompatCheck;
import net.the_last_sword.configuration.TheLastSwordConfiguration;
import net.the_last_sword.defence.DefenceManager;
import net.the_last_sword.entity.TheLastEndEntity;
import net.the_last_sword.entity.TheLastEndSwordWraithEntity;
import net.the_last_sword.summon.WraithSummonManager;
import net.the_last_sword.util.DynamicHealthDetector;
import net.the_last_sword.util.TheLastSwordLogger;
import net.the_last_sword.util.unsafe.UnsafeFieldOffsets;
import net.the_last_sword.util.unsafe.UnsafeUtil;

public final class EntityUtil {
    private static final Set<Integer> loggedDataIds = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Set<LivingEntity> detectionTargetEntities = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Set<String> HEALTH_KEYWORDS = new HashSet<String>(Arrays.asList("health", "heal", "hp", "life", "vital"));
    private static final Set<String> HEALTH_BLACKLIST_KEYWORDS = new HashSet<String>(Arrays.asList("ai", "goal", "target", "path", "navigation", "nav", "brain", "memory", "sensor", "behavior", "behaviour", "skill", "ability", "spell", "cast", "animation", "anim", "stage", "cooldown", "cool", "cd", "time", "tick", "duration", "delay", "timer", "age", "hurt"));

    public static boolean containsHealthKeyword(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return false;
        }
        String lowerName = fieldName.toLowerCase();
        for (String keyword : HEALTH_KEYWORDS) {
            if (!lowerName.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInBlacklist(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return false;
        }
        String lowerName = fieldName.toLowerCase();
        for (String keyword : HEALTH_BLACKLIST_KEYWORDS) {
            if (!lowerName.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldModifyEntityData(LivingEntity entity, int dataId) {
        if (dataId <= 15) {
            return false;
        }
        String fieldName = EntityUtil.findFieldNameByDataId(entity.getClass(), dataId);
        return fieldName == null || !EntityUtil.isInBlacklist(fieldName);
    }

    public static float TheLastEndGetHealth(LivingEntity entity) {
        boolean useUnsafe;
        if (entity == null) {
            return 0.0f;
        }
        boolean bl = useUnsafe = TheLastSwordConfiguration.getEnableUnsafeCodeSafely() && !CompatCheck.UnsafeGetHealthCompatCheck();
        if (useUnsafe) {
            return EntityUtil.getHealthWithUnsafeFallback(entity);
        }
        return EntityUtil.getVanillaHealthDirectly(entity);
    }

    private static float getHealthWithUnsafeFallback(LivingEntity entity) {
        try {
            Float unsafeResult = UnsafeUtil.UnsafeGetHealth(entity);
            if (unsafeResult != null) {
                return unsafeResult.floatValue();
            }
            return EntityUtil.getVanillaHealthDirectly(entity);
        }
        catch (Throwable t) {
            return EntityUtil.getVanillaHealthDirectly(entity);
        }
    }

    private static float getVanillaHealthDirectly(LivingEntity entity) {
        Object value;
        SynchedEntityData entityData = entity.m_20088_();
        SynchedEntityData.DataItem healthItem = (SynchedEntityData.DataItem)entityData.f_135345_.get(LivingEntity.f_20961_.m_135015_());
        if (healthItem != null && (value = healthItem.m_135403_()) instanceof Float) {
            return ((Float)value).floatValue();
        }
        return entity.m_21223_();
    }

    public static void TheLastEndSetHealth(LivingEntity entity, float expectedHealth) {
        if (entity == null) {
            return;
        }
        try {
            if (EntityUtil.setBasicHealth(entity, expectedHealth)) {
                return;
            }
            if (EntityUtil.setHealthViaAccessors(entity, expectedHealth)) {
                return;
            }
            if (DynamicHealthDetector.tryUsingCachedFields(entity, expectedHealth)) {
                return;
            }
            if (EntityUtil.setHealthViaPassiveDetection(entity, expectedHealth)) {
                return;
            }
            EntityUtil.setHealthViaActiveScanning(entity, expectedHealth);
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Failed to set health: {}", e.getMessage(), e);
        }
    }

    private static boolean setBasicHealth(LivingEntity entity, float expectedHealth) {
        try {
            boolean useUnsafe = TheLastSwordConfiguration.getEnableUnsafeCodeSafely();
            if (useUnsafe) {
                UnsafeUtil.UnsafeSetHealth(entity, expectedHealth);
            } else {
                EntityUtil.setVanillaHealthDirectly(entity, expectedHealth);
            }
            float currentHealth = entity.m_21223_();
            return Math.abs(currentHealth - expectedHealth) <= 2.0f;
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Stage 1 exception: {}", e.getMessage(), e);
            return false;
        }
    }

    private static boolean setHealthViaAccessors(LivingEntity entity, float expectedHealth) {
        try {
            boolean success;
            List<EntityDataAccessor<?>> nearbyAccessors = EntityUtil.findNearbyNumericAccessors(entity);
            for (EntityDataAccessor<?> acc : nearbyAccessors) {
                EntityUtil.setAccessorValue(entity, acc, expectedHealth);
            }
            float currentHealth = entity.m_21223_();
            boolean bl = success = Math.abs(currentHealth - expectedHealth) <= 2.0f;
            if (success) {
                return true;
            }
            boolean aggressiveEnabled = TheLastSwordConfiguration.getEnableAggressiveHealthDetectionSafely();
            return aggressiveEnabled && EntityUtil.setAllNumericAccessors(entity, expectedHealth);
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Stage 2 exception: {}", e.getMessage(), e);
            return false;
        }
    }

    public static void markEntityForDetection(LivingEntity entity) {
        detectionTargetEntities.add(entity);
    }

    public static void unmarkEntityForDetection(LivingEntity entity) {
        detectionTargetEntities.remove(entity);
    }

    public static boolean isEntityMarkedForDetection(LivingEntity entity) {
        return detectionTargetEntities.contains(entity);
    }

    private static boolean setAllNumericAccessors(LivingEntity entity, float expectedHealth) {
        try {
            float afterHealth;
            SynchedEntityData entityData = entity.m_20088_();
            for (Map.Entry entry : entityData.f_135345_.entrySet()) {
                Object currentValue;
                Integer dataId = (Integer)entry.getKey();
                SynchedEntityData.DataItem dataItem = (SynchedEntityData.DataItem)entry.getValue();
                if (dataItem == null || !((currentValue = dataItem.m_135403_()) instanceof Number) || !EntityUtil.shouldModifyEntityData(entity, dataId)) continue;
                EntityUtil.setEntityDataValueSafe(dataItem, expectedHealth);
            }
            boolean unsafeEnabled = TheLastSwordConfiguration.getEnableUnsafeCodeSafely();
            if (unsafeEnabled) {
                EntityUtil.scanAndModifyAllInstanceFields(entity, expectedHealth);
            }
            boolean success = Math.abs((afterHealth = entity.m_21223_()) - expectedHealth) <= 2.0f;
            return success;
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Stage 2.5 exception: {}", e.getMessage(), e);
            return false;
        }
    }

    private static int scanAndModifyAllInstanceFields(LivingEntity entity, float expectedHealth) {
        try {
            HashSet<Object> scannedObjects = new HashSet<Object>();
            int totalModified = 0;
            Class<?> currentClass = entity.getClass();
            int MAX_INHERITANCE_LEVEL = 5;
            for (int inheritanceLevel = 0; currentClass != null && inheritanceLevel < 5; currentClass = currentClass.getSuperclass(), ++inheritanceLevel) {
                int modifiedInThisClass = EntityUtil.scanAndModifyFieldsInClass(entity, currentClass, expectedHealth, scannedObjects, 0);
                totalModified += modifiedInThisClass;
                if (currentClass != LivingEntity.class && currentClass != null) continue;
                break;
            }
            return totalModified;
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Inheritance tree scan exception: {}", e.getMessage(), e);
            return 0;
        }
    }

    private static int scanAndModifyFieldsInClass(Object targetObject, Class<?> targetClass, float expectedHealth, Set<Object> scannedObjects, int nestingLevel) {
        int MAX_NESTING_LEVEL = 3;
        if (nestingLevel > 3) {
            return 0;
        }
        if (nestingLevel > 0 && scannedObjects.contains(targetObject)) {
            return 0;
        }
        if (nestingLevel > 0) {
            scannedObjects.add(targetObject);
        }
        int modifiedCount = 0;
        try {
            Field[] fields;
            for (Field field : fields = targetClass.getDeclaredFields()) {
                try {
                    Object nestedObject;
                    field.setAccessible(true);
                    Class<?> fieldType = field.getType();
                    String fieldName = field.getName();
                    if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                    if (fieldType == Double.TYPE || fieldType == Double.class) {
                        boolean success;
                        if (!EntityUtil.containsHealthKeyword(fieldName) || EntityUtil.isInBlacklist(fieldName) || !(success = UnsafeUtil.setDoubleField(targetObject, field, expectedHealth))) continue;
                        ++modifiedCount;
                        continue;
                    }
                    if (fieldType == Float.TYPE || fieldType == Float.class) {
                        boolean success;
                        if (!EntityUtil.containsHealthKeyword(fieldName) || EntityUtil.isInBlacklist(fieldName) || !(success = UnsafeUtil.setFloatField(targetObject, field, expectedHealth))) continue;
                        ++modifiedCount;
                        continue;
                    }
                    if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                        boolean success;
                        if (!EntityUtil.containsHealthKeyword(fieldName) || EntityUtil.isInBlacklist(fieldName) || !(success = UnsafeUtil.setIntField(targetObject, field, (int)expectedHealth))) continue;
                        ++modifiedCount;
                        continue;
                    }
                    if (fieldType.isPrimitive() || fieldType.getName().startsWith("java.") || fieldType.getName().startsWith("javax.") || fieldType.getName().startsWith("jdk.") || fieldType.getName().startsWith("sun.") || (nestedObject = field.get(targetObject)) == null || scannedObjects.contains(nestedObject)) continue;
                    modifiedCount += EntityUtil.scanAndModifyFieldsInClass(nestedObject, nestedObject.getClass(), expectedHealth, scannedObjects, nestingLevel + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modifiedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setHealthViaPassiveDetection(LivingEntity entity, float expectedHealth) {
        try {
            boolean aggressiveEnabled = TheLastSwordConfiguration.getEnableAggressiveHealthDetectionSafely();
            if (!aggressiveEnabled) {
                boolean bl = false;
                return bl;
            }
            EntityUtil.markEntityForDetection(entity);
            DynamicHealthDetector.handleRealHealth(entity, expectedHealth);
            float finalHealth = entity.m_21223_();
            boolean bl = Math.abs(finalHealth - expectedHealth) <= 2.0f;
            return bl;
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Stage 3 exception: {}", e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            EntityUtil.unmarkEntityForDetection(entity);
        }
    }

    private static boolean setHealthViaActiveScanning(LivingEntity entity, float expectedHealth) {
        try {
            boolean unsafeEnabled = TheLastSwordConfiguration.getEnableUnsafeCodeSafely();
            boolean aggressiveEnabled = TheLastSwordConfiguration.getEnableAggressiveHealthDetectionSafely();
            if (!unsafeEnabled || !aggressiveEnabled) {
                return false;
            }
            DynamicHealthDetector.initiateActiveScanning(entity, expectedHealth);
            float finalHealth = entity.m_21223_();
            return Math.abs(finalHealth - expectedHealth) <= 2.0f;
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Stage 4 exception: {}", e.getMessage(), e);
            return false;
        }
    }

    public static Entity[] findAllEntitiesWithHealth(Entity source, double range) {
        Vec3 vec3 = new Vec3(source.m_20185_(), source.m_20186_(), source.m_20189_());
        AABB boundingBox = new AABB(vec3.f_82479_ - range, vec3.f_82480_ - range, vec3.f_82481_ - range, vec3.f_82479_ + range, vec3.f_82480_ + range, vec3.f_82481_ + range);
        List<LivingEntity> list = source.f_19853_.m_6443_(LivingEntity.class, boundingBox, e -> true).stream().filter(entity -> entity != source && !(entity instanceof Player)).sorted(Comparator.comparingDouble(LivingEntity::m_21223_).reversed()).toList();
        return list.toArray(new Entity[0]);
    }

    private static void setVanillaHealthDirectly(LivingEntity entity, float expectedHealth) {
        SynchedEntityData entityData = entity.m_20088_();
        SynchedEntityData.DataItem healthItem = (SynchedEntityData.DataItem)entityData.f_135345_.get(LivingEntity.f_20961_.m_135015_());
        if (healthItem != null) {
            SynchedEntityData.DataItem floatHealthItem = healthItem;
            floatHealthItem.f_135391_ = Float.valueOf(expectedHealth);
            floatHealthItem.f_135392_ = true;
            entityData.f_135348_ = true;
        }
    }

    private static List<EntityDataAccessor<?>> findNearbyNumericAccessors(LivingEntity entity) {
        ArrayList result = new ArrayList();
        float entityHealth = entity.m_21223_();
        int vanillaHealthId = LivingEntity.f_20961_.m_135015_();
        for (Class<?> clazz = entity.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    float numericValue;
                    Object value;
                    EntityDataAccessor accessor;
                    field.setAccessible(true);
                    if (!EntityDataAccessor.class.isAssignableFrom(field.getType()) || !Modifier.isStatic(field.getModifiers()) || (accessor = (EntityDataAccessor)field.get(null)).m_135015_() == vanillaHealthId || !((value = entity.m_20088_().m_135370_(accessor)) instanceof Number) || !(Math.abs((numericValue = ((Number)value).floatValue()) - entityHealth) < 2.0f) && !EntityUtil.containsHealthKeyword(field.getName())) continue;
                    result.add(accessor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private static void setAccessorValue(LivingEntity entity, EntityDataAccessor<?> accessor, float expectedHealth) {
        Object currentValue = entity.m_20088_().m_135370_(accessor);
        if (currentValue instanceof Float) {
            EntityDataAccessor<?> floatAccessor = accessor;
            entity.m_20088_().m_135381_(floatAccessor, (Object)Float.valueOf(expectedHealth));
        } else if (currentValue instanceof Integer) {
            EntityDataAccessor<?> intAccessor = accessor;
            entity.m_20088_().m_135381_(intAccessor, (Object)((int)expectedHealth));
        } else if (currentValue instanceof Double) {
            EntityDataAccessor<?> doubleAccessor = accessor;
            entity.m_20088_().m_135381_(doubleAccessor, (Object)expectedHealth);
        }
    }

    private static String findFieldNameByDataId(Class<?> entityClass, int dataId) {
        for (Class<?> clazz = entityClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    if (!Modifier.isStatic(field.getModifiers()) || !EntityDataAccessor.class.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    EntityDataAccessor accessor = (EntityDataAccessor)field.get(null);
                    if (accessor == null || accessor.m_135015_() != dataId) continue;
                    return field.getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static void setEntityDataValueSafe(SynchedEntityData.DataItem<?> dataItem, float expectedHealth) {
        Object currentValue = dataItem.m_135403_();
        try {
            if (currentValue instanceof Float) {
                SynchedEntityData.DataItem<?> floatItem = dataItem;
                floatItem.f_135391_ = Float.valueOf(expectedHealth);
                floatItem.f_135392_ = true;
            } else if (currentValue instanceof Integer) {
                SynchedEntityData.DataItem<?> intItem = dataItem;
                intItem.f_135391_ = (int)expectedHealth;
                intItem.f_135392_ = true;
            } else if (currentValue instanceof Double) {
                SynchedEntityData.DataItem<?> doubleItem = dataItem;
                doubleItem.f_135391_ = (double)expectedHealth;
                doubleItem.f_135392_ = true;
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("EntityData value set exception: {}", e.getMessage(), e);
        }
    }

    public static void TheLastEndClearDataFromOutside(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        if (TheLastSwordConfiguration.getEnableUnsafeCodeSafely()) {
            EntityUtil.clearExternalDataUnsafe(entity);
        } else {
            EntityUtil.clearExternalDataReflection(entity);
        }
    }

    private static void clearExternalDataUnsafe(LivingEntity entity) {
        try {
            Object object;
            SynchedEntityData entityData = entity.m_20088_();
            Object itemsMap = UnsafeFieldOffsets.UNSAFE.getObject(entityData, UnsafeFieldOffsets.OFF_SYNCHED_ITEMS);
            if (itemsMap == null) {
                return;
            }
            boolean hasCleared = false;
            if (itemsMap instanceof Int2ObjectMap) {
                Int2ObjectMap fastMap = (Int2ObjectMap)itemsMap;
                object = fastMap.int2ObjectEntrySet().iterator();
                while (object.hasNext()) {
                    Object currentValue;
                    Object zeroValue;
                    Object dataItem;
                    Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)object.next();
                    int dataId = entry.getIntKey();
                    if (!EntityUtil.shouldModifyEntityData(entity, dataId) || (dataItem = entry.getValue()) == null || (zeroValue = EntityUtil.getZeroValueForNumericType(currentValue = UnsafeFieldOffsets.UNSAFE.getObject(dataItem, UnsafeFieldOffsets.OFF_DATAITEM_VALUE))) == null) continue;
                    UnsafeFieldOffsets.UNSAFE.putObject(dataItem, UnsafeFieldOffsets.OFF_DATAITEM_VALUE, zeroValue);
                    UnsafeFieldOffsets.UNSAFE.putBoolean(dataItem, UnsafeFieldOffsets.OFF_DATAITEM_DIRTY, true);
                    hasCleared = true;
                }
            } else if (itemsMap instanceof Map) {
                Map stdMap = (Map)itemsMap;
                object = stdMap.entrySet().iterator();
                while (object.hasNext()) {
                    Object currentValue;
                    Object zeroValue;
                    Object dataItem;
                    Map.Entry entry = (Map.Entry)object.next();
                    Integer dataId = (Integer)entry.getKey();
                    if (dataId == null || !EntityUtil.shouldModifyEntityData(entity, dataId) || (dataItem = entry.getValue()) == null || (zeroValue = EntityUtil.getZeroValueForNumericType(currentValue = UnsafeFieldOffsets.UNSAFE.getObject(dataItem, UnsafeFieldOffsets.OFF_DATAITEM_VALUE))) == null) continue;
                    UnsafeFieldOffsets.UNSAFE.putObject(dataItem, UnsafeFieldOffsets.OFF_DATAITEM_VALUE, zeroValue);
                    UnsafeFieldOffsets.UNSAFE.putBoolean(dataItem, UnsafeFieldOffsets.OFF_DATAITEM_DIRTY, true);
                    hasCleared = true;
                }
            }
            if (hasCleared) {
                UnsafeFieldOffsets.UNSAFE.putBoolean(entityData, UnsafeFieldOffsets.OFF_SYNCHED_DIRTY, true);
                if (!entity.m_9236_().f_46443_ && (object = entity.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)object;
                    EntityUtil.safeSyncEntityDataToClients((Entity)entity, serverLevel);
                }
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Unsafe external data clearing failed: {}", e.getMessage());
        }
    }

    private static void clearExternalDataReflection(LivingEntity entity) {
        try {
            SynchedEntityData entityData = entity.m_20088_();
            Int2ObjectMap itemsById = entityData.f_135345_;
            if (itemsById == null) {
                return;
            }
            boolean hasCleared = false;
            for (Map.Entry entry : itemsById.entrySet()) {
                Object currentValue;
                Object zeroValue;
                SynchedEntityData.DataItem dataItem;
                Integer dataId = (Integer)entry.getKey();
                if (dataId == null || !EntityUtil.shouldModifyEntityData(entity, dataId) || (dataItem = (SynchedEntityData.DataItem)entry.getValue()) == null || (zeroValue = EntityUtil.getZeroValueForNumericType(currentValue = dataItem.m_135403_())) == null) continue;
                SynchedEntityData.DataItem genericDataItem = dataItem;
                genericDataItem.f_135391_ = zeroValue;
                genericDataItem.f_135392_ = true;
                hasCleared = true;
            }
            if (hasCleared) {
                Level level;
                entityData.f_135348_ = true;
                if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    EntityUtil.safeSyncEntityDataToClients((Entity)entity, serverLevel);
                }
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Reflection external data clearing failed: {}", e.getMessage());
        }
    }

    private static Object getZeroValueForNumericType(Object currentValue) {
        if (currentValue instanceof Integer) {
            return 0;
        }
        if (currentValue instanceof Float) {
            return Float.valueOf(0.0f);
        }
        if (currentValue instanceof Double) {
            return 0.0;
        }
        return null;
    }

    public static void safeSyncEntityDataToClients(Entity entity, ServerLevel serverLevel) {
        serverLevel.m_7726_().m_8394_(entity, (Packet)new ClientboundSetEntityDataPacket(entity.m_19879_(), entity.m_20088_().m_252804_()));
    }

    public static void TheLastEndSetDead(LivingEntity entity, DamageSource ds) {
        if (entity == null) {
            return;
        }
        try {
            if (!entity.m_9236_().f_46443_ && TheLastSwordConfiguration.getTheLastEndDeadParticleEffectsSafely()) {
                int i;
                ServerLevel serverLevel = (ServerLevel)entity.m_9236_();
                Vec3 pos = entity.m_20182_();
                for (i = 0; i < 12; ++i) {
                    double theta = Math.PI * 2 * (double)i / 12.0;
                    double phi = Math.acos(1.0 - 2.0 * ((double)i + 0.5) / 12.0);
                    double x = Math.sin(phi) * Math.cos(theta);
                    double y = Math.sin(phi) * Math.sin(theta);
                    double z = Math.cos(phi);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_ + x, pos.f_82480_ + (double)entity.m_20206_() / 2.0 + y, pos.f_82481_ + z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 16; ++i) {
                    double angle = Math.PI * 2 * (double)i / 16.0;
                    double x = Math.cos(angle);
                    double z = Math.sin(angle);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, pos.f_82479_, pos.f_82480_ + (double)entity.m_20206_() / 2.0, pos.f_82481_, 1, x * 0.3, 0.0, z * 0.3, 0.1);
                }
            }
            EntityUtil.triggerKillAdvancement(entity, ds);
            EntityUtil.sendDeathMessage(entity, ds);
            if (entity instanceof TheLastEndEntity) {
                TheLastEndEntity theLastEndEntity = (TheLastEndEntity)entity;
                theLastEndEntity.setIsDead(true);
                theLastEndEntity.setDeathTime(-1);
            } else {
                entity.m_6074_();
                DefenceManager.clear(entity);
                EntityUtil.addReviveBan((Entity)entity);
                EntityUtil.TheLastEndSetHealth(entity, 0.0f);
                if (TheLastSwordConfiguration.getEnableUnsafeCodeSafely()) {
                    UnsafeUtil.UnsafeSetDead(entity, ds);
                } else {
                    entity.f_20890_ = true;
                }
                EntityUtil.dropLoot(entity, ds);
                EntityUtil.dropExperience(entity);
                EntityUtil.TheLastEndRemove((Entity)entity, Entity.RemovalReason.KILLED);
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("[TheLastSword] Failed to setDead entity {}: {}", entity.m_7755_().getString(), e.getMessage());
        }
    }

    private static void dropExperience(LivingEntity entity) {
        try {
            if (entity.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
                int xpDrop;
                for (int experiencePoints = entity.m_213860_(); experiencePoints > 0; experiencePoints -= xpDrop) {
                    xpDrop = ExperienceOrb.m_20782_((int)experiencePoints);
                    entity.m_9236_().m_7967_((Entity)new ExperienceOrb(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), xpDrop));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendDeathMessage(LivingEntity entity, DamageSource ds) {
        try {
            if (!entity.m_9236_().f_46443_ && entity.m_9236_().m_7654_() != null) {
                Level level = entity.m_9236_();
                ItemStack weapon = ItemStack.f_41583_;
                Entity entity2 = ds.m_7639_();
                if (entity2 instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity2;
                    weapon = attacker.m_21205_();
                }
                MutableComponent deathMessage = !weapon.m_41619_() ? Component.m_237110_((String)"death.attack.absolute_destruction.item", (Object[])new Object[]{entity.m_5446_(), ds.m_7639_() != null ? ds.m_7639_().m_5446_() : Component.m_237113_((String)"Unknown"), weapon.m_41611_()}) : (ds.m_7640_() instanceof Player ? Component.m_237110_((String)"death.attack.absolute_destruction.player", (Object[])new Object[]{entity.m_5446_(), ds.m_7640_().m_5446_()}) : (ds.m_7639_() != null ? Component.m_237110_((String)"death.attack.absolute_destruction.player", (Object[])new Object[]{entity.m_5446_(), ds.m_7639_().m_5446_()}) : Component.m_237110_((String)"death.attack.absolute_destruction", (Object[])new Object[]{entity.m_5446_()})));
                if (level.m_46469_().m_46207_(GameRules.f_46142_)) {
                    PlayerList playerList = level.m_7654_().m_6846_();
                    playerList.m_240416_((Component)deathMessage, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isReviveBan(Entity entity) {
        try {
            return AttackEffectManager.isReviveBan(entity);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void addReviveBan(Entity entity) {
        try {
            AttackEffectManager.addReviveBan(entity);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void dropLoot(LivingEntity entity, DamageSource ds) {
        entity.m_6668_(ds);
    }

    public static void TheLastEndRevive(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        try {
            entity.f_20890_ = false;
            entity.f_20919_ = 0;
            entity.revive();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.m_7583_();
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("[TheLastSword] Failed to revive entity {}: {}", entity.m_7755_().getString(), e.getMessage());
        }
    }

    public static void TheLastEndRemove(Entity entity, Entity.RemovalReason reason) {
        if (entity == null) {
            return;
        }
        int entityId = entity.m_19879_();
        try {
            ServerLevel serverLevel;
            Level level;
            entity.invalidateCaps();
            entity.isAddedToWorld = false;
            EntityUtil.theLastEndCleanupAI(entity);
            EntityUtil.theLastEndCleanupBossBar(entity);
            if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                ClientboundRemoveEntitiesPacket removePacket = new ClientboundRemoveEntitiesPacket(new int[]{entityId});
                for (ServerPlayer player : serverLevel.m_6907_()) {
                    player.f_8906_.m_9829_((Packet)removePacket);
                }
            }
            if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                entity.m_213651_(DynamicGameEventListener::m_223634_);
                entity.onRemovedFromWorld();
                MinecraftForge.EVENT_BUS.post((Event)new EntityLeaveLevelEvent(entity, entity.m_9236_()));
                serverLevel.m_6188_().m_83420_(entity);
            }
            if (TheLastSwordConfiguration.getEnableUnsafeCodeSafely()) {
                boolean unsafeSuccess = UnsafeUtil.UnsafeRemove(entity, reason);
                if (!unsafeSuccess) {
                    TheLastSwordLogger.warn("Warning: Unsafe removal failed for entity {}", entityId);
                }
            } else {
                EntityUtil.theLastEndSetRemoved(entity, Entity.RemovalReason.KILLED);
                EntityUtil.theLastEndCallbackRemove(entity, reason);
                EntityUtil.theLastEndListRemove(entity);
                EntityUtil.theLastEndTeleport(entity);
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Terminal removal failed: {}", e.getMessage());
        }
    }

    private static void theLastEndCleanupAI(Entity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob.f_21345_ != null) {
                mob.f_21345_.m_262460_(goal -> true);
            }
            if (mob.f_21346_ != null) {
                mob.f_21346_.m_262460_(goal -> true);
            }
            mob.m_6710_(null);
            if (mob.m_21573_() != null) {
                mob.m_21573_().m_26573_();
            }
        }
    }

    public static void theLastEndCleanupBossBar(Entity entity) {
        if (entity == null) {
            return;
        }
        for (Class<?> clazz = entity.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(entity);
                    if (!(fieldValue instanceof ServerBossEvent)) continue;
                    ServerBossEvent serverBossEvent = (ServerBossEvent)fieldValue;
                    serverBossEvent.m_7706_();
                    serverBossEvent.m_8321_(false);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    private static void theLastEndSetRemoved(Entity entity, Entity.RemovalReason reason) {
        entity.f_146795_ = reason;
        entity.m_8127_();
        EntityUtil.removeAllPassengers(entity);
    }

    private static void removeAllPassengers(Entity entity) {
        List passengers = entity.m_20197_();
        for (int i = passengers.size() - 1; i >= 0; --i) {
            Entity passenger = (Entity)passengers.get(i);
            if (passenger == null) continue;
            passenger.m_8127_();
        }
    }

    private static void theLastEndCallbackRemove(Entity entity, Entity.RemovalReason reason) {
        Level level;
        if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            entity.f_146801_ = EntityInLevelCallback.f_156799_;
        }
    }

    private static void theLastEndListRemove(Entity entity) {
        Level level;
        if (entity == null) {
            return;
        }
        int entityId = entity.m_19879_();
        UUID entityUUID = entity.m_20148_();
        if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!EntityUtil.removeFromChunkMap(serverLevel, entityId)) {
                TheLastSwordLogger.warn("Failed to remove from ChunkMap: entity={}", entityId);
            }
            if (!EntityUtil.removeFromServerLevelLists(serverLevel, entity)) {
                TheLastSwordLogger.warn("Failed to remove from ServerLevel lists: entity={}", entityId);
            }
            if (!EntityUtil.removeFromEntityLookup(serverLevel, entityId, entityUUID)) {
                TheLastSwordLogger.warn("Failed to remove from EntityLookup: entity={}", entityId);
            }
            if (!EntityUtil.removeFromKnownUuids(serverLevel, entityUUID)) {
                TheLastSwordLogger.warn("Failed to remove from knownUuids: entity={}", entityId);
            }
            if (!EntityUtil.removeFromEntityTickList(serverLevel, entityId)) {
                TheLastSwordLogger.warn("Failed to remove from EntityTickList: entity={}", entityId);
            }
            if (!EntityUtil.removeFromClassInstanceMultiMap(serverLevel, entity)) {
                TheLastSwordLogger.warn("Failed to remove from ClassInstanceMultiMap: entity={}", entityId);
            }
        }
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft != null && minecraft.f_91073_ != null && !EntityUtil.removeFromClientContainers(minecraft.f_91073_, entity, entityId, entityUUID)) {
                TheLastSwordLogger.warn("Failed to remove from client containers: entity={}", entityId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean removeFromChunkMap(ServerLevel serverLevel, int entityId) {
        try {
            Field chunkSourceField = EntityUtil.findFieldByType(ServerLevel.class, "net.minecraft.server.level.ServerChunkCache");
            if (chunkSourceField == null) {
                return false;
            }
            chunkSourceField.setAccessible(true);
            Object chunkSource = chunkSourceField.get(serverLevel);
            if (chunkSource == null) {
                return false;
            }
            Field chunkMapField = EntityUtil.findFieldByType(chunkSource.getClass(), "net.minecraft.server.level.ChunkMap");
            if (chunkMapField == null) {
                return false;
            }
            chunkMapField.setAccessible(true);
            Object chunkMap = chunkMapField.get(chunkSource);
            if (chunkMap == null) {
                return false;
            }
            boolean success = false;
            for (Field field : chunkMap.getClass().getDeclaredFields()) {
                if (!Int2ObjectMap.class.isAssignableFrom(field.getType()) || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                Int2ObjectMap map = (Int2ObjectMap)field.get(chunkMap);
                if (map == null || !map.containsKey(entityId)) continue;
                map.remove(entityId);
                success = true;
            }
            return success;
        }
        catch (Exception e) {
            TheLastSwordLogger.warn("Failed to remove from ChunkMap: {}", e.getMessage());
            return false;
        }
    }

    private static boolean removeFromServerLevelLists(ServerLevel serverLevel, Entity entity) {
        boolean success = false;
        try {
            String fieldName;
            Object value;
            if (entity instanceof ServerPlayer) {
                Field[] playersField = null;
                Field[] fieldArray = ServerLevel.class.getDeclaredFields();
                int n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    List list;
                    Field f = fieldArray[i];
                    if (!List.class.isAssignableFrom(f.getType())) continue;
                    f.setAccessible(true);
                    Object value2 = f.get(serverLevel);
                    if (!(value2 instanceof List) || (list = (List)value2).isEmpty() || !(list.get(0) instanceof ServerPlayer)) continue;
                    success = list.remove(entity);
                    break;
                }
            }
            if (entity instanceof Mob) {
                for (Field f : ServerLevel.class.getDeclaredFields()) {
                    if (!Set.class.isAssignableFrom(f.getType())) continue;
                    f.setAccessible(true);
                    value = f.get(serverLevel);
                    if (!(value instanceof Set) || !(fieldName = f.getName()).contains("navigating") && !fieldName.contains("mob")) continue;
                    Set set = (Set)value;
                    success = set.remove(entity) || success;
                    break;
                }
            }
            if (entity.isMultipartEntity()) {
                for (Field f : ServerLevel.class.getDeclaredFields()) {
                    if (!Int2ObjectMap.class.isAssignableFrom(f.getType())) continue;
                    f.setAccessible(true);
                    value = f.get(serverLevel);
                    if (!(value instanceof Int2ObjectMap) || !(fieldName = f.getName()).contains("dragon") && !fieldName.contains("part")) continue;
                    Int2ObjectMap map = (Int2ObjectMap)value;
                    for (PartEntity part : entity.getParts()) {
                        if (map.remove(part.m_19879_()) == null) continue;
                        success = true;
                    }
                    break;
                }
            }
            return success;
        }
        catch (Exception e) {
            TheLastSwordLogger.warn("Failed to remove from ServerLevel lists: {}", e.getMessage());
            return false;
        }
    }

    private static boolean removeFromEntityLookup(ServerLevel serverLevel, int entityId, UUID entityUUID) {
        boolean success = false;
        try {
            Field entityManagerField = EntityUtil.findFieldByType(ServerLevel.class, "net.minecraft.world.level.entity.PersistentEntitySectionManager");
            if (entityManagerField == null) {
                return false;
            }
            entityManagerField.setAccessible(true);
            Object pesm = entityManagerField.get(serverLevel);
            if (pesm == null) {
                return false;
            }
            Field visibleStorageField = EntityUtil.findFieldByType(pesm.getClass(), "net.minecraft.world.level.entity.EntityLookup");
            if (visibleStorageField != null) {
                visibleStorageField.setAccessible(true);
                Object entityLookup = visibleStorageField.get(pesm);
                if (entityLookup != null) {
                    Field byUuidField;
                    Field byIdField = EntityUtil.findFieldByType(entityLookup.getClass(), "it.unimi.dsi.fastutil.ints.Int2ObjectMap");
                    if (byIdField != null) {
                        byIdField.setAccessible(true);
                        Int2ObjectMap byId = (Int2ObjectMap)byIdField.get(entityLookup);
                        if (byId != null && byId.remove(entityId) != null) {
                            success = true;
                        }
                    }
                    if ((byUuidField = EntityUtil.findFieldByType(entityLookup.getClass(), "java.util.Map")) != null) {
                        byUuidField.setAccessible(true);
                        Map byUuid = (Map)byUuidField.get(entityLookup);
                        if (byUuid != null && byUuid.remove(entityUUID) != null) {
                            success = true;
                        }
                    }
                }
            }
            return success;
        }
        catch (Exception e) {
            TheLastSwordLogger.warn("Failed to remove from EntityLookup: {}", e.getMessage());
            return false;
        }
    }

    private static boolean removeFromKnownUuids(ServerLevel serverLevel, UUID entityUUID) {
        try {
            Field entityManagerField = EntityUtil.findFieldByType(ServerLevel.class, "net.minecraft.world.level.entity.PersistentEntitySectionManager");
            if (entityManagerField == null) {
                return false;
            }
            entityManagerField.setAccessible(true);
            Object pesm = entityManagerField.get(serverLevel);
            if (pesm == null) {
                return false;
            }
            Field knownUuidsField = EntityUtil.findFieldByType(pesm.getClass(), "java.util.Set");
            if (knownUuidsField != null) {
                knownUuidsField.setAccessible(true);
                Set knownUuids = (Set)knownUuidsField.get(pesm);
                if (knownUuids != null && knownUuids.remove(entityUUID)) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            TheLastSwordLogger.warn("Failed to remove from knownUuids: {}", e.getMessage());
            return false;
        }
    }

    private static boolean removeFromEntityTickList(ServerLevel serverLevel, int entityId) {
        try {
            Int2ObjectMap iterated;
            Field entityTickListField = EntityUtil.findFieldByType(ServerLevel.class, "net.minecraft.world.level.entity.EntityTickList");
            if (entityTickListField == null) {
                return false;
            }
            entityTickListField.setAccessible(true);
            Object entityTickList = entityTickListField.get(serverLevel);
            if (entityTickList == null) {
                return false;
            }
            Field activeField = null;
            Field passiveField = null;
            Field iteratedField = null;
            for (Field f : entityTickList.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                if ("active".equals(f.getName())) {
                    activeField = f;
                    continue;
                }
                if ("passive".equals(f.getName())) {
                    passiveField = f;
                    continue;
                }
                if (!"iterated".equals(f.getName())) continue;
                iteratedField = f;
            }
            if (activeField == null || passiveField == null) {
                return false;
            }
            Int2ObjectMap active = (Int2ObjectMap)activeField.get(entityTickList);
            Int2ObjectMap passive = (Int2ObjectMap)passiveField.get(entityTickList);
            Int2ObjectMap int2ObjectMap = iterated = iteratedField != null ? (Int2ObjectMap)iteratedField.get(entityTickList) : null;
            if (active == null || passive == null) {
                return false;
            }
            if (iterated == active) {
                passive.clear();
                for (Int2ObjectMap.Entry entry : active.int2ObjectEntrySet()) {
                    passive.put(entry.getIntKey(), (Object)((Entity)entry.getValue()));
                }
                activeField.set(entityTickList, passive);
                passiveField.set(entityTickList, active);
                Int2ObjectMap temp = active;
                active = passive;
                passive = temp;
            }
            return active.remove(entityId) != null;
        }
        catch (Exception e) {
            TheLastSwordLogger.warn("Failed to remove from EntityTickList: {}", e.getMessage());
            return false;
        }
    }

    private static boolean removeFromClassInstanceMultiMap(ServerLevel serverLevel, Entity entity) {
        boolean success = false;
        try {
            Field entityManagerField = EntityUtil.findFieldByType(ServerLevel.class, "net.minecraft.world.level.entity.PersistentEntitySectionManager");
            if (entityManagerField == null) {
                return false;
            }
            entityManagerField.setAccessible(true);
            Object pesm = entityManagerField.get(serverLevel);
            if (pesm == null) {
                return false;
            }
            Field sectionStorageField = EntityUtil.findFieldByType(pesm.getClass(), "net.minecraft.world.level.entity.EntitySectionStorage");
            if (sectionStorageField == null) {
                return false;
            }
            sectionStorageField.setAccessible(true);
            Object sectionStorage = sectionStorageField.get(pesm);
            if (sectionStorage == null) {
                return false;
            }
            Field sectionsField = EntityUtil.findFieldByType(sectionStorage.getClass(), "it.unimi.dsi.fastutil.longs.Long2ObjectMap");
            if (sectionsField == null) {
                return false;
            }
            sectionsField.setAccessible(true);
            Long2ObjectMap sections = (Long2ObjectMap)sectionsField.get(sectionStorage);
            if (sections == null) {
                return false;
            }
            for (Object section : sections.values()) {
                Field byClassField;
                Field storageField;
                if (section == null || (storageField = EntityUtil.findFieldByType(section.getClass(), "net.minecraft.util.ClassInstanceMultiMap")) == null) continue;
                storageField.setAccessible(true);
                Object classInstanceMultiMap = storageField.get(section);
                if (classInstanceMultiMap == null || (byClassField = EntityUtil.findFieldByType(classInstanceMultiMap.getClass(), "java.util.Map")) == null) continue;
                byClassField.setAccessible(true);
                Map byClass = (Map)byClassField.get(classInstanceMultiMap);
                if (byClass == null) continue;
                for (Map.Entry entry : byClass.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!(key instanceof Class) || !(value instanceof List)) continue;
                    Class clazz = (Class)key;
                    List list = (List)value;
                    if (!clazz.isInstance(entity) || !list.remove(entity)) continue;
                    success = true;
                }
            }
            return success;
        }
        catch (Exception e) {
            TheLastSwordLogger.warn("Failed to remove from ClassInstanceMultiMap: {}", e.getMessage());
            return false;
        }
    }

    private static boolean removeFromClientContainers(ClientLevel clientLevel, Entity entity, int entityId, UUID entityUUID) {
        boolean success = false;
        try {
            Field entityTickListField;
            for (Field f : clientLevel.getClass().getDeclaredFields()) {
                Set set;
                f.setAccessible(true);
                Object value = f.get(clientLevel);
                if (!(value instanceof Set) || !"tickingEntities".equals(f.getName()) || !(set = (Set)value).remove(entity)) continue;
                success = true;
            }
            Field entityManagerField = EntityUtil.findFieldByType(clientLevel.getClass(), "net.minecraft.world.level.entity.TransientEntitySectionManager");
            if (entityManagerField != null) {
                entityManagerField.setAccessible(true);
                Object tesm = entityManagerField.get(clientLevel);
                if (tesm != null) {
                    Field sectionStorageField;
                    Field entityStorageField = EntityUtil.findFieldByType(tesm.getClass(), "net.minecraft.world.level.entity.EntityLookup");
                    if (entityStorageField != null) {
                        entityStorageField.setAccessible(true);
                        Object entityLookup = entityStorageField.get(tesm);
                        if (entityLookup != null) {
                            Field byUuidField;
                            Field byIdField = EntityUtil.findFieldByType(entityLookup.getClass(), "it.unimi.dsi.fastutil.ints.Int2ObjectMap");
                            if (byIdField != null) {
                                byIdField.setAccessible(true);
                                Int2ObjectMap byId = (Int2ObjectMap)byIdField.get(entityLookup);
                                if (byId != null && byId.remove(entityId) != null) {
                                    success = true;
                                }
                            }
                            if ((byUuidField = EntityUtil.findFieldByType(entityLookup.getClass(), "java.util.Map")) != null) {
                                byUuidField.setAccessible(true);
                                Map byUuid = (Map)byUuidField.get(entityLookup);
                                if (byUuid != null && byUuid.remove(entityUUID) != null) {
                                    success = true;
                                }
                            }
                        }
                    }
                    if ((sectionStorageField = EntityUtil.findFieldByType(tesm.getClass(), "net.minecraft.world.level.entity.EntitySectionStorage")) != null) {
                        Field sectionsField;
                        sectionStorageField.setAccessible(true);
                        Object sectionStorage = sectionStorageField.get(tesm);
                        if (sectionStorage != null && (sectionsField = EntityUtil.findFieldByType(sectionStorage.getClass(), "it.unimi.dsi.fastutil.longs.Long2ObjectMap")) != null) {
                            sectionsField.setAccessible(true);
                            Long2ObjectMap sections = (Long2ObjectMap)sectionsField.get(sectionStorage);
                            if (sections != null) {
                                for (Object section : sections.values()) {
                                    Field byClassField;
                                    Field storageField;
                                    if (section == null || (storageField = EntityUtil.findFieldByType(section.getClass(), "net.minecraft.util.ClassInstanceMultiMap")) == null) continue;
                                    storageField.setAccessible(true);
                                    Object classInstanceMultiMap = storageField.get(section);
                                    if (classInstanceMultiMap == null || (byClassField = EntityUtil.findFieldByType(classInstanceMultiMap.getClass(), "java.util.Map")) == null) continue;
                                    byClassField.setAccessible(true);
                                    Map byClass = (Map)byClassField.get(classInstanceMultiMap);
                                    if (byClass == null) continue;
                                    for (Map.Entry entry : byClass.entrySet()) {
                                        Object key = entry.getKey();
                                        Object value = entry.getValue();
                                        if (!(key instanceof Class) || !(value instanceof List)) continue;
                                        Class clazz = (Class)key;
                                        List list = (List)value;
                                        if (!clazz.isInstance(entity) || !list.remove(entity)) continue;
                                        success = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if ((entityTickListField = EntityUtil.findFieldByType(clientLevel.getClass(), "net.minecraft.world.level.entity.EntityTickList")) != null) {
                entityTickListField.setAccessible(true);
                Object entityTickList = entityTickListField.get(clientLevel);
                if (entityTickList != null) {
                    for (Field f : entityTickList.getClass().getDeclaredFields()) {
                        Int2ObjectMap map;
                        f.setAccessible(true);
                        if (!"active".equals(f.getName()) && !"passive".equals(f.getName()) || (map = (Int2ObjectMap)f.get(entityTickList)) == null || map.remove(entityId) == null) continue;
                        success = true;
                    }
                }
            }
            return success;
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Failed to remove from client containers: {}", e.getMessage());
            return false;
        }
    }

    private static void theLastEndTeleport(Entity entity) {
        if (entity == null) {
            return;
        }
        try {
            int entityHash = entity.m_19879_() * 31 + entity.m_20148_().hashCode();
            Random rand = new Random(entityHash);
            double voidX = 1024 * (rand.nextInt(2000) - 1000);
            double voidY = -1024.0;
            double voidZ = 1024 * (rand.nextInt(2000) - 1000);
            entity.m_20343_(voidX, voidY, voidZ);
            entity.f_19790_ = voidX;
            entity.f_19791_ = voidY;
            entity.f_19792_ = voidZ;
            entity.f_19860_ = entity.m_146909_();
            entity.f_19859_ = entity.m_146908_();
        }
        catch (Exception e) {
            TheLastSwordLogger.warn("Failed to teleport entity: {}", e.getMessage());
        }
    }

    public static boolean areAllies(Entity a, Entity b) {
        Player playerOwner;
        TamableAnimal tb;
        TamableAnimal ta;
        Player bOwner;
        LivingEntity lb;
        Player aOwner;
        LivingEntity la;
        if (a == null || b == null || a == b) {
            return true;
        }
        if (a instanceof Player) {
            Player pa = (Player)a;
            if (b instanceof Player) {
                Player pb = (Player)b;
                return pa.m_5647_() != null && pa.m_5647_() == pb.m_5647_();
            }
        }
        if (a instanceof LivingEntity && WraithSummonManager.isWraith(la = (LivingEntity)a) && (aOwner = WraithSummonManager.getOwner(la, la.m_9236_())) != null) {
            Player pb;
            if (b.equals((Object)aOwner)) {
                return true;
            }
            if (b instanceof Player && EntityUtil.areAllies((Entity)aOwner, (Entity)(pb = (Player)b))) {
                return true;
            }
            if (b instanceof LivingEntity) {
                LivingEntity lb2 = (LivingEntity)b;
                return EntityUtil.isOwnedByAllyOf(lb2, aOwner);
            }
        }
        if (b instanceof LivingEntity && WraithSummonManager.isWraith(lb = (LivingEntity)b) && (bOwner = WraithSummonManager.getOwner(lb, lb.m_9236_())) != null) {
            Player pa;
            if (a.equals((Object)bOwner)) {
                return true;
            }
            if (a instanceof Player && EntityUtil.areAllies((Entity)(pa = (Player)a), (Entity)bOwner)) {
                return true;
            }
            if (a instanceof LivingEntity) {
                LivingEntity la2 = (LivingEntity)a;
                return EntityUtil.isOwnedByAllyOf(la2, bOwner);
            }
        }
        if (a instanceof LivingEntity) {
            la = (LivingEntity)a;
            if (b instanceof LivingEntity) {
                LivingEntity lb3 = (LivingEntity)b;
                if (WraithSummonManager.isWraith(la) && WraithSummonManager.isWraith(lb3)) {
                    Player aOwner2 = WraithSummonManager.getOwner(la, la.m_9236_());
                    Player bOwner2 = WraithSummonManager.getOwner(lb3, lb3.m_9236_());
                    if (aOwner2 != null && bOwner2 != null) {
                        return aOwner2.equals((Object)bOwner2) || EntityUtil.areAllies((Entity)aOwner2, (Entity)bOwner2);
                    }
                }
            }
        }
        if (a instanceof TamableAnimal) {
            ta = (TamableAnimal)a;
            if (b instanceof Player) {
                Player pb = (Player)b;
                return ta.m_21830_((LivingEntity)pb);
            }
        }
        if (b instanceof TamableAnimal) {
            tb = (TamableAnimal)b;
            if (a instanceof Player) {
                Player pa = (Player)a;
                return tb.m_21830_((LivingEntity)pa);
            }
        }
        if (a instanceof TamableAnimal && (aOwner = (ta = (TamableAnimal)a).m_269323_()) instanceof Player) {
            Player pb;
            playerOwner = aOwner;
            if (b instanceof Player && EntityUtil.areAllies((Entity)playerOwner, (Entity)(pb = (Player)b))) {
                return true;
            }
            if (b instanceof LivingEntity) {
                LivingEntity lb4 = (LivingEntity)b;
                return EntityUtil.isOwnedByAllyOf(lb4, playerOwner);
            }
        }
        if (b instanceof TamableAnimal && (bOwner = (tb = (TamableAnimal)b).m_269323_()) instanceof Player) {
            Player pa;
            playerOwner = bOwner;
            if (a instanceof Player && EntityUtil.areAllies((Entity)(pa = (Player)a), (Entity)playerOwner)) {
                return true;
            }
            if (a instanceof LivingEntity) {
                LivingEntity la3 = (LivingEntity)a;
                return EntityUtil.isOwnedByAllyOf(la3, playerOwner);
            }
        }
        return false;
    }

    private static boolean isOwnedByAllyOf(LivingEntity entity, Player referencePlayer) {
        if (WraithSummonManager.isWraith(entity)) {
            Player owner = WraithSummonManager.getOwner(entity, entity.m_9236_());
            return owner != null && EntityUtil.areAllies((Entity)owner, (Entity)referencePlayer);
        }
        if (entity instanceof TamableAnimal) {
            Player playerOwner;
            TamableAnimal tamable = (TamableAnimal)entity;
            LivingEntity owner = tamable.m_269323_();
            return owner instanceof Player && EntityUtil.areAllies((Entity)(playerOwner = (Player)owner), (Entity)referencePlayer);
        }
        return false;
    }

    public static boolean isOwnerOrAllyOrPet(Entity e, UUID ownerUUID, Entity owner) {
        if (e == null || ownerUUID == null || owner == null) {
            return false;
        }
        if (e.m_20148_().equals(ownerUUID)) {
            return true;
        }
        return EntityUtil.areAllies(e, owner);
    }

    public static boolean shouldAttack(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && WraithSummonManager.isWraith(livingEntity = (LivingEntity)entity)) {
            return false;
        }
        if (entity instanceof Player) {
            return TheLastSwordConfiguration.getAttackPlayersSafely();
        }
        if (entity instanceof Villager) {
            return TheLastSwordConfiguration.getAttackVillagersSafely();
        }
        if (entity instanceof Animal) {
            return TheLastSwordConfiguration.getAttackAnimalsSafely();
        }
        if (entity instanceof TamableAnimal) {
            return TheLastSwordConfiguration.getAttackTamedSafely();
        }
        if (entity instanceof IronGolem) {
            return TheLastSwordConfiguration.getAttackGolemsSafely();
        }
        if (entity instanceof NeutralMob) {
            return TheLastSwordConfiguration.getAttackNeutralSafely();
        }
        return true;
    }

    public static List<Entity> getEntitiesInRange(Level lvl, LivingEntity src, double range) {
        AABB box = new AABB(src.m_20185_() - range, src.m_20186_() - range, src.m_20189_() - range, src.m_20185_() + range, src.m_20186_() + range, src.m_20189_() + range);
        return lvl.m_6249_((Entity)src, box, e -> !(e instanceof ItemEntity) && !(e instanceof ExperienceOrb) && !EntityUtil.isOwnerOrAllyOrPet(e, src.m_20148_(), (Entity)src));
    }

    public static List<Entity> getAttackTargets(Level lvl, LivingEntity src, double range) {
        return EntityUtil.getEntitiesInRange(lvl, src, range).stream().filter(EntityUtil::shouldAttack).filter(entity -> {
            if (WraithSummonManager.isWraith(src)) {
                Player owner;
                LivingEntity livingTarget;
                if (entity instanceof LivingEntity && WraithSummonManager.isWraith(livingTarget = (LivingEntity)entity)) {
                    Player srcOwner = WraithSummonManager.getOwner(src, lvl);
                    Player targetOwner = WraithSummonManager.getOwner(livingTarget, lvl);
                    if (srcOwner != null && targetOwner != null && srcOwner.equals((Object)targetOwner)) {
                        return false;
                    }
                }
                if ((owner = WraithSummonManager.getOwner(src, lvl)) != null && entity.equals((Object)owner)) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
    }

    public static TheLastEndSwordWraithEntity findSummonedEntity(Player p) {
        return p.m_9236_().m_6443_(TheLastEndSwordWraithEntity.class, p.m_20191_().m_82400_(64.0), e -> e.m_21824_() && p.m_20148_().equals(e.m_21805_())).stream().findFirst().orElse(null);
    }

    public static void triggerKillAdvancement(LivingEntity entity, DamageSource source) {
        try {
            ServerPlayer killerPlayer = null;
            Entity entity2 = source.m_7639_();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer player;
                killerPlayer = player = (ServerPlayer)entity2;
            } else {
                entity2 = source.m_7639_();
                if (entity2 instanceof LivingEntity) {
                    LivingEntity sourceEntity = (LivingEntity)entity2;
                    killerPlayer = EntityUtil.findOwnerOrAllyPlayer(sourceEntity);
                }
            }
            if (killerPlayer != null) {
                CriteriaTriggers.f_10568_.m_48104_(killerPlayer, (Entity)entity, source);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ServerPlayer findOwnerOrAllyPlayer(LivingEntity entity) {
        try {
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (ServerPlayer player : serverLevel.m_7654_().m_6846_().m_11314_()) {
                    if (!EntityUtil.areAllies((Entity)entity, (Entity)player)) continue;
                    return player;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static UUID getEntityUUID(Entity entity) {
        return entity == null ? null : entity.m_20148_();
    }

    public static void faceTarget(LivingEntity source, LivingEntity entity) {
        if (source == null || entity == null || !entity.m_6084_()) {
            return;
        }
        double deltaX = entity.m_20185_() - source.m_20185_();
        double deltaZ = entity.m_20189_() - source.m_20189_();
        double deltaY = entity.m_20186_() + (double)entity.m_20206_() * 0.5 - (source.m_20186_() + (double)source.m_20206_() * 0.5);
        double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        float yaw = (float)(Math.atan2(-deltaX, deltaZ) * 180.0 / Math.PI);
        float pitch = (float)(Math.atan2(-deltaY, horizontalDistance) * 180.0 / Math.PI);
        source.m_146922_(yaw);
        source.m_146926_(pitch);
        source.f_20885_ = yaw;
        source.f_20883_ = yaw;
    }

    public static boolean isInFrontHemisphere(LivingEntity source, Entity entity, double maxAngle) {
        double dz;
        if (source == null || entity == null) {
            return false;
        }
        float yaw = source.m_146908_();
        double yawRad = Math.toRadians(yaw);
        double dirX = -Math.sin(yawRad);
        double dirZ = Math.cos(yawRad);
        double dx = entity.m_20185_() - source.m_20185_();
        double distance = Math.sqrt(dx * dx + (dz = entity.m_20189_() - source.m_20189_()) * dz);
        if (distance < 1.0E-6) {
            return true;
        }
        double normX = dx / distance;
        double normZ = dz / distance;
        double dot = dirX * normX + dirZ * normZ;
        double angle = Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, dot))));
        return angle <= maxAngle;
    }

    public static List<LivingEntity> getTargetsInHemisphere(LivingEntity source, double range, double maxAngle) {
        if (source == null) {
            return new ArrayList<LivingEntity>();
        }
        ArrayList<LivingEntity> validTargets = new ArrayList<LivingEntity>();
        AABB area = new AABB(source.m_20185_() - range, source.m_20186_() - 1.0, source.m_20189_() - range, source.m_20185_() + range, source.m_20186_() + 3.0, source.m_20189_() + range);
        List candidates = source.m_9236_().m_45933_((Entity)source, area);
        for (Entity entity : candidates) {
            double distance;
            LivingEntity livingTarget;
            if (!(entity instanceof LivingEntity) || !(livingTarget = (LivingEntity)entity).m_6084_() || !EntityUtil.shouldAttack(entity) || (distance = (double)source.m_20270_(entity)) > range || !EntityUtil.isInFrontHemisphere(source, entity, maxAngle)) continue;
            validTargets.add(livingTarget);
        }
        return validTargets;
    }

    public static void clearAllEntityCaches() {
        detectionTargetEntities.clear();
        loggedDataIds.clear();
    }

    private static Field findFieldByType(Class<?> clazz, String typeName) {
        try {
            for (Field field : clazz.getDeclaredFields()) {
                String fieldTypeName;
                if (Modifier.isStatic(field.getModifiers()) || !(fieldTypeName = field.getType().getName()).equals(typeName)) continue;
                return field;
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.warn("Failed to find field by type {}: {}", typeName, e.getMessage());
        }
        return null;
    }
}

