/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.util.unsafe;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.the_last_sword.util.TheLastSwordLogger;
import sun.misc.Unsafe;

public final class UnsafeFieldOffsets {
    public static final Unsafe UNSAFE;
    public static final int HEALTH_DATA_ID = 9;
    public static final long OFF_ENTITY_DATA;
    public static final long OFF_SYNCHED_ITEMS;
    public static final long OFF_SYNCHED_DIRTY;
    public static final long OFF_DATAITEM_VALUE;
    public static final long OFF_DATAITEM_DIRTY;
    public static final String FASTUTIL_INT2OBJ;
    public static final Class<?> C_DATAITEM;
    public static final long OFF_ENTITY_POSITION;
    public static final long OFF_ENTITY_BOUNDING_BOX;
    public static final long OFF_ENTITY_BLOCK_POS;
    public static final long OFF_ENTITY_CHUNK_POS;
    public static final long OFF_ENTITY_X_OLD;
    public static final long OFF_ENTITY_Y_OLD;
    public static final long OFF_ENTITY_Z_OLD;
    public static final long OFF_ENTITY_X_ROT;
    public static final long OFF_ENTITY_Y_ROT;
    public static final long OFF_ENTITY_X_ROT_OLD;
    public static final long OFF_ENTITY_Y_ROT_OLD;
    public static final long OFF_ENTITY_DEATH_TIME;
    public static final long OFF_ENTITY_DEAD;
    public static final long OFF_ENTITY_LAST_HURT_BY;
    public static final long OFF_ENTITY_LAST_HURT_TIME;
    public static final long OFF_ENTITY_HURT_TIME;
    public static final long OFF_ENTITY_HURT_DURATION;
    public static final long OFF_ENTITY_LAST_HURT_BY_MOB;
    public static final long OFF_ENTITY_LAST_HURT_BY_MOB_TIME;
    public static final long OFF_ENTITY_LAST_DAMAGE_SOURCE;
    public static final long OFF_ENTITY_LAST_DAMAGE_STAMP;
    public static final long OFF_ENTITY_LEVEL_CALLBACK;
    public static final long OFF_ENTITY_REMOVAL_REASON;
    public static final long OFF_ENTITY_PASSENGERS;
    public static final long OFF_SERVER_ENTITY_MANAGER;
    public static final long OFF_SERVER_ENTITY_TICK_LIST;
    public static final long OFF_SERVER_NAVIGATING_MOBS;
    public static final long OFF_SERVER_DRAGON_PARTS;
    public static final long OFF_SERVER_CHUNK_SOURCE;
    public static final long OFF_SERVER_PLAYERS;
    public static final long OFF_MANAGER_KNOWN_UUIDS;
    public static final long OFF_MANAGER_VISIBLE_STORAGE;
    public static final long OFF_MANAGER_SECTION_STORAGE;
    public static final long OFF_LOOKUP_BY_ID;
    public static final long OFF_LOOKUP_BY_UUID;
    public static final long OFF_CHUNK_SOURCE_CHUNK_MAP;
    public static final long OFF_CHUNK_MAP_ENTITY_MAP;
    public static final long OFF_ENTITY_SECTION_STORAGE_SECTIONS;
    public static final long OFF_ENTITY_SECTION_STORAGE;
    public static final long OFF_MULTIMAP_BY_CLASS;
    public static final long OFF_MULTIMAP_ALL_INSTANCES;
    public static final long OFF_TICKLIST_ACTIVE;
    public static final long OFF_TICKLIST_PASSIVE;
    public static final long OFF_TICKLIST_ITERATED;
    public static final long OFF_ENTITY_LAST_HAND_ITEMS;
    public static final long OFF_ENTITY_LAST_ARMOR_ITEMS;
    public static final long OFF_ENTITY_SKIP_DROP_EXPERIENCE;
    public static final long OFF_ENTITY_CAPTURED_DROPS;

    public static Field findFieldByType(Class<?> ownerClass, Class<?> fieldType, int index) {
        int count = 0;
        for (Class<?> clazz = ownerClass; clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || !fieldType.isAssignableFrom(field.getType())) continue;
                if (count == index) {
                    field.setAccessible(true);
                    UnsafeFieldOffsets.logDebug(String.format("Found field: %s.%s (type: %s, index: %d)", ownerClass.getSimpleName(), field.getName(), fieldType.getSimpleName(), index));
                    return field;
                }
                ++count;
            }
        }
        throw new IllegalStateException(String.format("Field not found: %s (type: %s, index: %d)", ownerClass.getName(), fieldType.getName(), index));
    }

    public static Field findFieldByTypeSafe(Class<?> ownerClass, Class<?> fieldType, int index) {
        try {
            return UnsafeFieldOffsets.findFieldByType(ownerClass, fieldType, index);
        }
        catch (Exception e) {
            UnsafeFieldOffsets.logDebug(String.format("Safe field search failed: %s.%s[%d] - %s", ownerClass.getSimpleName(), fieldType.getSimpleName(), index, e.getMessage()));
            return null;
        }
    }

    private static long findForgeField(Class<?> ownerClass, String fieldName) {
        try {
            Field field = ownerClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            long offset = UNSAFE.objectFieldOffset(field);
            TheLastSwordLogger.debug("Found Forge field: {}.{}", ownerClass.getSimpleName(), fieldName);
            return offset;
        }
        catch (NoSuchFieldException e) {
            TheLastSwordLogger.warn("Forge field {}.{} not found - Forge environment may not be available", ownerClass.getSimpleName(), fieldName);
            return -1L;
        }
    }

    public static boolean isValidOffset(long offset) {
        return offset > 0L && offset != -1L;
    }

    private static void logDebug(String message) {
    }

    public static String getOffsetStatistics() {
        StringBuilder stats = new StringBuilder();
        stats.append("ASM Field Offsets Statistics:\n");
        int healthOffsets = 7;
        int teleportOffsets = 11;
        int deathOffsets = 10;
        int callbackOffsets = 3;
        int serverListOffsets = 6;
        int managerOffsets = 3;
        int lookupOffsets = 2;
        int chunkCacheOffsets = 1;
        int chunkMapOffsets = 1;
        int sectionStorageOffsets = 1;
        int sectionOffsets = 1;
        int lootOffsets = 4;
        int totalOffsets = healthOffsets + teleportOffsets + deathOffsets + callbackOffsets + serverListOffsets + managerOffsets + lookupOffsets + chunkCacheOffsets + chunkMapOffsets + sectionStorageOffsets + sectionOffsets + lootOffsets;
        stats.append("- Health related: ").append(healthOffsets).append(" offsets\n");
        stats.append("- Teleport related: ").append(teleportOffsets).append(" offsets\n");
        stats.append("- Death related: ").append(deathOffsets).append(" offsets\n");
        stats.append("- Callback related: ").append(callbackOffsets).append(" offsets\n");
        stats.append("- Server list related: ").append(serverListOffsets).append(" offsets\n");
        stats.append("- Manager related: ").append(managerOffsets).append(" offsets\n");
        stats.append("- Lookup related: ").append(lookupOffsets).append(" offsets\n");
        stats.append("- Chunk cache related: ").append(chunkCacheOffsets).append(" offsets\n");
        stats.append("- Chunk map related: ").append(chunkMapOffsets).append(" offsets\n");
        stats.append("- Section storage related: ").append(sectionStorageOffsets).append(" offsets\n");
        stats.append("- Section related: ").append(sectionOffsets).append(" offsets\n");
        stats.append("- Loot related: ").append(lootOffsets).append(" offsets\n");
        stats.append("- Total: ").append(totalOffsets).append(" offsets\n");
        stats.append("Key offsets status:\n");
        stats.append("- FastUtil support: ").append(FASTUTIL_INT2OBJ != null ? "Yes" : "No").append("\n");
        stats.append("- Entity data offset: ").append(UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_DATA) ? "Valid" : "Invalid").append("\n");
        stats.append("- Health data offset: ").append(UnsafeFieldOffsets.isValidOffset(OFF_DATAITEM_VALUE) ? "Valid" : "Invalid").append("\n");
        stats.append("- Position offset: ").append(UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_POSITION) ? "Valid" : "Invalid").append("\n");
        stats.append("- Death offset: ").append(UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_DEAD) ? "Valid" : "Invalid").append("\n");
        stats.append("- Callback offset: ").append(UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_LEVEL_CALLBACK) ? "Valid" : "Invalid").append("\n");
        stats.append("- Section storage offset: ").append(UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_SECTION_STORAGE) ? "Valid" : "Invalid").append("\n");
        stats.append("- Captured drops offset: ").append(UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_CAPTURED_DROPS) ? "Valid (Forge)" : "Invalid (Vanilla)").append("\n");
        stats.append("- Chunk source offset: ").append(UnsafeFieldOffsets.isValidOffset(OFF_SERVER_CHUNK_SOURCE) ? "Valid" : "Invalid").append("\n");
        stats.append("- Chunk map offset: ").append(UnsafeFieldOffsets.isValidOffset(OFF_CHUNK_SOURCE_CHUNK_MAP) ? "Valid" : "Invalid").append("\n");
        stats.append("- Entity map offset: ").append(UnsafeFieldOffsets.isValidOffset(OFF_CHUNK_MAP_ENTITY_MAP) ? "Valid" : "Invalid").append("\n");
        stats.append("- Section storage sections offset: ").append(UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_SECTION_STORAGE_SECTIONS) ? "Valid" : "Invalid").append("\n");
        return stats.toString();
    }

    public static boolean validateOffsets() {
        try {
            boolean valid = true;
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_DATA);
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_SYNCHED_ITEMS);
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_DATAITEM_VALUE);
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_POSITION);
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_BOUNDING_BOX);
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_DEAD);
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_DEATH_TIME);
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_LEVEL_CALLBACK);
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_REMOVAL_REASON);
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_SECTION_STORAGE);
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_SERVER_CHUNK_SOURCE);
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_CHUNK_SOURCE_CHUNK_MAP);
            valid &= UnsafeFieldOffsets.isValidOffset(OFF_CHUNK_MAP_ENTITY_MAP);
            return valid &= UnsafeFieldOffsets.isValidOffset(OFF_ENTITY_SECTION_STORAGE_SECTIONS);
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Offset validation error: " + e.getMessage());
            return false;
        }
    }

    private UnsafeFieldOffsets() {
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to initialize Unsafe", t);
        }
        try {
            Field itemsField;
            UnsafeFieldOffsets.logDebug("Initializing ASM field offsets...");
            UnsafeFieldOffsets.logDebug("Initializing health-related field offsets...");
            Field entityDataField = UnsafeFieldOffsets.findFieldByType(Entity.class, SynchedEntityData.class, 0);
            OFF_ENTITY_DATA = UNSAFE.objectFieldOffset(entityDataField);
            Class<SynchedEntityData> synchedClass = SynchedEntityData.class;
            String fastUtilName = null;
            try {
                Class<?> fastUtilClass = Class.forName("it.unimi.dsi.fastutil.ints.Int2ObjectMap");
                itemsField = UnsafeFieldOffsets.findFieldByType(synchedClass, fastUtilClass, 0);
                fastUtilName = "it/unimi/dsi/fastutil/ints/Int2ObjectMap";
            }
            catch (ClassNotFoundException e) {
                itemsField = UnsafeFieldOffsets.findFieldByType(synchedClass, Map.class, 0);
            }
            OFF_SYNCHED_ITEMS = UNSAFE.objectFieldOffset(itemsField);
            FASTUTIL_INT2OBJ = fastUtilName;
            Field dirtyField = UnsafeFieldOffsets.findFieldByType(synchedClass, Boolean.TYPE, 0);
            OFF_SYNCHED_DIRTY = UNSAFE.objectFieldOffset(dirtyField);
            C_DATAITEM = Class.forName("net.minecraft.network.syncher.SynchedEntityData$DataItem");
            Field valueField = UnsafeFieldOffsets.findFieldByType(C_DATAITEM, Object.class, 1);
            OFF_DATAITEM_VALUE = UNSAFE.objectFieldOffset(valueField);
            Field dirtyItemField = UnsafeFieldOffsets.findFieldByType(C_DATAITEM, Boolean.TYPE, 0);
            OFF_DATAITEM_DIRTY = UNSAFE.objectFieldOffset(dirtyItemField);
            UnsafeFieldOffsets.logDebug("Initializing teleport-related field offsets...");
            Class<Entity> entityClass = Entity.class;
            OFF_ENTITY_POSITION = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, Vec3.class, 0));
            OFF_ENTITY_BOUNDING_BOX = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, AABB.class, 0));
            OFF_ENTITY_BLOCK_POS = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, BlockPos.class, 0));
            OFF_ENTITY_CHUNK_POS = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, ChunkPos.class, 0));
            OFF_ENTITY_X_OLD = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, Double.TYPE, 3));
            OFF_ENTITY_Y_OLD = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, Double.TYPE, 4));
            OFF_ENTITY_Z_OLD = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, Double.TYPE, 5));
            OFF_ENTITY_Y_ROT = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, Float.TYPE, 0));
            OFF_ENTITY_X_ROT = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, Float.TYPE, 1));
            OFF_ENTITY_Y_ROT_OLD = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, Float.TYPE, 2));
            OFF_ENTITY_X_ROT_OLD = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, Float.TYPE, 3));
            UnsafeFieldOffsets.logDebug("Initializing death-related field offsets...");
            Class<LivingEntity> livingClass = LivingEntity.class;
            OFF_ENTITY_HURT_TIME = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, Integer.TYPE, 2));
            OFF_ENTITY_HURT_DURATION = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, Integer.TYPE, 3));
            OFF_ENTITY_DEATH_TIME = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, Integer.TYPE, 4));
            OFF_ENTITY_LAST_HURT_TIME = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, Integer.TYPE, 5));
            OFF_ENTITY_LAST_HURT_BY_MOB_TIME = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, Integer.TYPE, 6));
            OFF_ENTITY_DEAD = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, Boolean.TYPE, 0));
            OFF_ENTITY_LAST_HURT_BY = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, Player.class, 0));
            OFF_ENTITY_LAST_HURT_BY_MOB = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, LivingEntity.class, 0));
            OFF_ENTITY_LAST_DAMAGE_SOURCE = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, DamageSource.class, 0));
            OFF_ENTITY_LAST_DAMAGE_STAMP = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, Long.TYPE, 0));
            UnsafeFieldOffsets.logDebug("Initializing callback removal field offsets...");
            OFF_ENTITY_LEVEL_CALLBACK = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, EntityInLevelCallback.class, 0));
            OFF_ENTITY_REMOVAL_REASON = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, Entity.RemovalReason.class, 0));
            OFF_ENTITY_PASSENGERS = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entityClass, ImmutableList.class, 0));
            UnsafeFieldOffsets.logDebug("Initializing ServerLevel list cleanup field offsets...");
            Class<ServerLevel> serverLevelClass = ServerLevel.class;
            OFF_SERVER_ENTITY_MANAGER = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(serverLevelClass, PersistentEntitySectionManager.class, 0));
            OFF_SERVER_ENTITY_TICK_LIST = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(serverLevelClass, EntityTickList.class, 0));
            OFF_SERVER_NAVIGATING_MOBS = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(serverLevelClass, Set.class, 0));
            OFF_SERVER_DRAGON_PARTS = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(serverLevelClass, Int2ObjectMap.class, 0));
            OFF_SERVER_CHUNK_SOURCE = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(serverLevelClass, ServerChunkCache.class, 0));
            OFF_SERVER_PLAYERS = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(serverLevelClass, List.class, 0));
            UnsafeFieldOffsets.logDebug("Initializing PersistentEntitySectionManager field offsets...");
            Class<PersistentEntitySectionManager> managerClass = PersistentEntitySectionManager.class;
            OFF_MANAGER_KNOWN_UUIDS = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(managerClass, Set.class, 0));
            OFF_MANAGER_VISIBLE_STORAGE = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(managerClass, EntityLookup.class, 0));
            OFF_MANAGER_SECTION_STORAGE = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(managerClass, EntitySectionStorage.class, 0));
            UnsafeFieldOffsets.logDebug("Initializing EntityLookup field offsets...");
            Class<EntityLookup> lookupClass = EntityLookup.class;
            OFF_LOOKUP_BY_ID = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(lookupClass, Int2ObjectMap.class, 0));
            OFF_LOOKUP_BY_UUID = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(lookupClass, Map.class, 1));
            UnsafeFieldOffsets.logDebug("Initializing ServerChunkCache field offsets...");
            Class<ServerChunkCache> serverChunkCacheClass = ServerChunkCache.class;
            OFF_CHUNK_SOURCE_CHUNK_MAP = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(serverChunkCacheClass, ChunkMap.class, 0));
            UnsafeFieldOffsets.logDebug("Initializing ChunkMap field offsets...");
            Class<ChunkMap> chunkMapClass = ChunkMap.class;
            OFF_CHUNK_MAP_ENTITY_MAP = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(chunkMapClass, Int2ObjectMap.class, 0));
            UnsafeFieldOffsets.logDebug("Initializing EntitySectionStorage field offsets...");
            Class<EntitySectionStorage> entitySectionStorageClass = EntitySectionStorage.class;
            OFF_ENTITY_SECTION_STORAGE_SECTIONS = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entitySectionStorageClass, Long2ObjectMap.class, 0));
            UnsafeFieldOffsets.logDebug("Initializing EntitySection field offsets...");
            Class<EntitySection> entitySectionClass = EntitySection.class;
            OFF_ENTITY_SECTION_STORAGE = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(entitySectionClass, ClassInstanceMultiMap.class, 0));
            UnsafeFieldOffsets.logDebug("Initializing ClassInstanceMultiMap field offsets...");
            Class<ClassInstanceMultiMap> multiMapClass = ClassInstanceMultiMap.class;
            OFF_MULTIMAP_BY_CLASS = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(multiMapClass, Map.class, 0));
            OFF_MULTIMAP_ALL_INSTANCES = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(multiMapClass, List.class, 0));
            UnsafeFieldOffsets.logDebug("Initializing EntityTickList field offsets...");
            Class<EntityTickList> tickListClass = EntityTickList.class;
            OFF_TICKLIST_ACTIVE = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(tickListClass, Int2ObjectMap.class, 0));
            OFF_TICKLIST_PASSIVE = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(tickListClass, Int2ObjectMap.class, 1));
            OFF_TICKLIST_ITERATED = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(tickListClass, Int2ObjectMap.class, 2));
            UnsafeFieldOffsets.logDebug("Initializing loot drop field offsets...");
            OFF_ENTITY_LAST_HAND_ITEMS = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, NonNullList.class, 0));
            OFF_ENTITY_LAST_ARMOR_ITEMS = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, NonNullList.class, 1));
            OFF_ENTITY_SKIP_DROP_EXPERIENCE = UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(livingClass, Boolean.TYPE, 1));
            long capturedDropsOffset = -1L;
            try {
                Field capturedDropsField = UnsafeFieldOffsets.findFieldByType(entityClass, Collection.class, 0);
                capturedDropsOffset = UNSAFE.objectFieldOffset(capturedDropsField);
                UnsafeFieldOffsets.logDebug("Found capturedDrops field (Forge environment)");
            }
            catch (Exception e) {
                UnsafeFieldOffsets.logDebug("No capturedDrops field found (vanilla environment)");
            }
            OFF_ENTITY_CAPTURED_DROPS = capturedDropsOffset;
            UnsafeFieldOffsets.logDebug("ASM field offsets initialization completed successfully!");
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to initialize ASM field offsets", t);
        }
    }
}

