/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.util.unsafe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.the_last_sword.util.TheLastSwordLogger;
import net.the_last_sword.util.unsafe.UnsafeFieldOffsets;

public final class UnsafeFieldOffsetsClient {
    public static final long OFF_CLIENT_TICKING_ENTITIES;
    public static final long OFF_CLIENT_ENTITY_STORAGE;
    public static final long OFF_CLIENT_PLAYERS;
    public static final long OFF_CLIENT_PART_ENTITIES;
    public static final long OFF_TESM_ENTITY_STORAGE;
    public static final long OFF_TESM_SECTION_STORAGE;

    private static void logDebug(String message) {
    }

    public static boolean isValidOffset(long offset) {
        return offset > 0L && offset != -1L;
    }

    public static String getOffsetStatistics() {
        StringBuilder stats = new StringBuilder();
        stats.append("Client-side ASM Field Offsets Statistics:\n");
        int clientOffsets = 4;
        int tesmOffsets = 2;
        int totalOffsets = clientOffsets + tesmOffsets;
        stats.append("- Client level related: ").append(clientOffsets).append(" offsets\n");
        stats.append("- TESM related: ").append(tesmOffsets).append(" offsets\n");
        stats.append("- Total: ").append(totalOffsets).append(" offsets\n");
        stats.append("Key offsets status:\n");
        stats.append("- Client ticking entities: ").append(UnsafeFieldOffsetsClient.isValidOffset(OFF_CLIENT_TICKING_ENTITIES) ? "Valid" : "Invalid").append("\n");
        stats.append("- Client entity storage: ").append(UnsafeFieldOffsetsClient.isValidOffset(OFF_CLIENT_ENTITY_STORAGE) ? "Valid" : "Invalid").append("\n");
        stats.append("- TESM entity storage: ").append(UnsafeFieldOffsetsClient.isValidOffset(OFF_TESM_ENTITY_STORAGE) ? "Valid" : "Invalid").append("\n");
        return stats.toString();
    }

    public static boolean validateOffsets() {
        try {
            boolean valid = true;
            valid &= UnsafeFieldOffsetsClient.isValidOffset(OFF_CLIENT_TICKING_ENTITIES);
            valid &= UnsafeFieldOffsetsClient.isValidOffset(OFF_CLIENT_ENTITY_STORAGE);
            return valid &= UnsafeFieldOffsetsClient.isValidOffset(OFF_TESM_ENTITY_STORAGE);
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Client offset validation error: " + e.getMessage());
            return false;
        }
    }

    private UnsafeFieldOffsetsClient() {
    }

    static {
        try {
            UnsafeFieldOffsetsClient.logDebug("Initializing client-side ASM field offsets...");
            UnsafeFieldOffsetsClient.logDebug("Initializing ClientLevel field offsets...");
            Class<ClientLevel> clientLevelClass = ClientLevel.class;
            OFF_CLIENT_TICKING_ENTITIES = UnsafeFieldOffsets.UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(clientLevelClass, EntityTickList.class, 0));
            OFF_CLIENT_ENTITY_STORAGE = UnsafeFieldOffsets.UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(clientLevelClass, TransientEntitySectionManager.class, 0));
            OFF_CLIENT_PLAYERS = UnsafeFieldOffsets.UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(clientLevelClass, List.class, 0));
            OFF_CLIENT_PART_ENTITIES = UnsafeFieldOffsets.UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(clientLevelClass, Int2ObjectMap.class, 0));
            UnsafeFieldOffsetsClient.logDebug("Initializing TransientEntitySectionManager field offsets...");
            Class<TransientEntitySectionManager> tesmClass = TransientEntitySectionManager.class;
            OFF_TESM_ENTITY_STORAGE = UnsafeFieldOffsets.UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(tesmClass, EntityLookup.class, 0));
            OFF_TESM_SECTION_STORAGE = UnsafeFieldOffsets.UNSAFE.objectFieldOffset(UnsafeFieldOffsets.findFieldByType(tesmClass, EntitySectionStorage.class, 0));
            UnsafeFieldOffsetsClient.logDebug("Client-side ASM field offsets initialization completed successfully!");
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to initialize client-side ASM field offsets", t);
        }
    }
}

