/*
 * Decompiled with CFR 0.152.
 */
package net.the_last_sword.util.unsafe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.the_last_sword.util.TheLastSwordLogger;
import net.the_last_sword.util.unsafe.UnsafeFieldOffsets;
import net.the_last_sword.util.unsafe.UnsafeFieldOffsetsClient;

public final class UnsafeUtil {
    private UnsafeUtil() {
    }

    public static boolean setDoubleField(Object target, Field field, double value) {
        if (target == null || field == null) {
            return false;
        }
        try {
            long offset = UnsafeFieldOffsets.UNSAFE.objectFieldOffset(field);
            UnsafeFieldOffsets.UNSAFE.putDouble(target, offset, value);
            return true;
        }
        catch (Throwable t) {
            try {
                field.setAccessible(true);
                field.setDouble(target, value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static boolean setFloatField(Object target, Field field, float value) {
        if (target == null || field == null) {
            return false;
        }
        try {
            long offset = UnsafeFieldOffsets.UNSAFE.objectFieldOffset(field);
            UnsafeFieldOffsets.UNSAFE.putFloat(target, offset, value);
            return true;
        }
        catch (Throwable t) {
            try {
                field.setAccessible(true);
                field.setFloat(target, value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static boolean setIntField(Object target, Field field, int value) {
        if (target == null || field == null) {
            return false;
        }
        try {
            long offset = UnsafeFieldOffsets.UNSAFE.objectFieldOffset(field);
            UnsafeFieldOffsets.UNSAFE.putInt(target, offset, value);
            return true;
        }
        catch (Throwable t) {
            try {
                field.setAccessible(true);
                field.setInt(target, value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static boolean UnsafeSetHealth(LivingEntity entity, float health) {
        if (entity == null) {
            return false;
        }
        try {
            return UnsafeUtil.setEntityHealthDirect(entity, health);
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeSetHealth failed: {}", t.getMessage());
            return false;
        }
    }

    public static Float UnsafeGetHealth(LivingEntity entity) {
        if (entity == null) {
            return null;
        }
        try {
            return UnsafeUtil.getEntityHealthDirect(entity);
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeGetHealth failed: {}", t.getMessage());
            return null;
        }
    }

    private static boolean setEntityHealthDirect(LivingEntity entity, float health) {
        if (entity == null) {
            return false;
        }
        try {
            Object synchedData = UnsafeFieldOffsets.UNSAFE.getObject(entity, UnsafeFieldOffsets.OFF_ENTITY_DATA);
            if (synchedData == null) {
                return false;
            }
            Object itemsMap = UnsafeFieldOffsets.UNSAFE.getObject(synchedData, UnsafeFieldOffsets.OFF_SYNCHED_ITEMS);
            if (itemsMap == null) {
                return false;
            }
            Object dataItem = UnsafeUtil.getMapEntry(itemsMap, 9);
            if (dataItem == null) {
                return false;
            }
            UnsafeFieldOffsets.UNSAFE.putObject(dataItem, UnsafeFieldOffsets.OFF_DATAITEM_VALUE, Float.valueOf(health));
            UnsafeFieldOffsets.UNSAFE.putBoolean(dataItem, UnsafeFieldOffsets.OFF_DATAITEM_DIRTY, true);
            UnsafeFieldOffsets.UNSAFE.putBoolean(synchedData, UnsafeFieldOffsets.OFF_SYNCHED_DIRTY, true);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Float getEntityHealthDirect(LivingEntity entity) {
        if (entity == null) {
            return null;
        }
        try {
            Object synchedData = UnsafeFieldOffsets.UNSAFE.getObject(entity, UnsafeFieldOffsets.OFF_ENTITY_DATA);
            if (synchedData == null) {
                return null;
            }
            Object itemsMap = UnsafeFieldOffsets.UNSAFE.getObject(synchedData, UnsafeFieldOffsets.OFF_SYNCHED_ITEMS);
            if (itemsMap == null) {
                return null;
            }
            Object dataItem = UnsafeUtil.getMapEntry(itemsMap, 9);
            if (dataItem == null) {
                return null;
            }
            Object value = UnsafeFieldOffsets.UNSAFE.getObject(dataItem, UnsafeFieldOffsets.OFF_DATAITEM_VALUE);
            return value instanceof Float ? (Float)value : null;
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("Failed to get health directly: " + t.getMessage());
            return null;
        }
    }

    public static boolean UnsafeTeleport(Entity entity, double x, double y, double z) {
        if (entity == null) {
            return false;
        }
        return UnsafeUtil.UnsafeTeleport(entity, x, y, z, entity.m_146908_(), entity.m_146909_());
    }

    public static boolean UnsafeTeleport(Entity entity, double x, double y, double z, float yaw, float pitch) {
        if (entity == null) {
            return false;
        }
        try {
            Level level;
            Vec3 newPosition = new Vec3(x, y, z);
            UnsafeFieldOffsets.UNSAFE.putObject(entity, UnsafeFieldOffsets.OFF_ENTITY_POSITION, newPosition);
            UnsafeFieldOffsets.UNSAFE.putDouble(entity, UnsafeFieldOffsets.OFF_ENTITY_X_OLD, x);
            UnsafeFieldOffsets.UNSAFE.putDouble(entity, UnsafeFieldOffsets.OFF_ENTITY_Y_OLD, y);
            UnsafeFieldOffsets.UNSAFE.putDouble(entity, UnsafeFieldOffsets.OFF_ENTITY_Z_OLD, z);
            UnsafeFieldOffsets.UNSAFE.putFloat(entity, UnsafeFieldOffsets.OFF_ENTITY_Y_ROT, yaw);
            UnsafeFieldOffsets.UNSAFE.putFloat(entity, UnsafeFieldOffsets.OFF_ENTITY_X_ROT, pitch);
            UnsafeFieldOffsets.UNSAFE.putFloat(entity, UnsafeFieldOffsets.OFF_ENTITY_Y_ROT_OLD, yaw);
            UnsafeFieldOffsets.UNSAFE.putFloat(entity, UnsafeFieldOffsets.OFF_ENTITY_X_ROT_OLD, pitch);
            BlockPos newBlockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            ChunkPos newChunkPos = new ChunkPos(newBlockPos);
            UnsafeFieldOffsets.UNSAFE.putObject(entity, UnsafeFieldOffsets.OFF_ENTITY_BLOCK_POS, newBlockPos);
            UnsafeFieldOffsets.UNSAFE.putObject(entity, UnsafeFieldOffsets.OFF_ENTITY_CHUNK_POS, newChunkPos);
            AABB newBoundingBox = entity.m_6972_(entity.m_20089_()).m_20384_(x, y, z);
            UnsafeFieldOffsets.UNSAFE.putObject(entity, UnsafeFieldOffsets.OFF_ENTITY_BOUNDING_BOX, newBoundingBox);
            if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                UnsafeUtil.syncTeleportToClients(entity, serverLevel, x, y, z, yaw, pitch);
            }
            return true;
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("Unsafe Teleport failed: {}", t.getMessage());
            return false;
        }
    }

    private static void syncTeleportToClients(Entity entity, ServerLevel serverLevel, double x, double y, double z, float yaw, float pitch) {
        if (entity == null) {
            return;
        }
        try {
            ClientboundTeleportEntityPacket teleportPacket = new ClientboundTeleportEntityPacket(entity);
            serverLevel.m_7726_().m_8445_(entity, (Packet)teleportPacket);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.f_8906_.m_9774_(x, y, z, yaw, pitch);
            }
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Failed to sync teleport to clients: " + e.getMessage());
        }
    }

    public static boolean UnsafeSetDead(LivingEntity entity, DamageSource damageSource) {
        if (entity == null) {
            return false;
        }
        try {
            Level level;
            UnsafeFieldOffsets.UNSAFE.putBoolean(entity, UnsafeFieldOffsets.OFF_ENTITY_DEAD, true);
            UnsafeFieldOffsets.UNSAFE.putInt(entity, UnsafeFieldOffsets.OFF_ENTITY_HURT_TIME, 10);
            UnsafeFieldOffsets.UNSAFE.putInt(entity, UnsafeFieldOffsets.OFF_ENTITY_HURT_DURATION, 10);
            if (damageSource != null) {
                UnsafeFieldOffsets.UNSAFE.putObject(entity, UnsafeFieldOffsets.OFF_ENTITY_LAST_DAMAGE_SOURCE, damageSource);
                UnsafeFieldOffsets.UNSAFE.putLong(entity, UnsafeFieldOffsets.OFF_ENTITY_LAST_DAMAGE_STAMP, entity.m_9236_().m_46467_());
                Entity directEntity = damageSource.m_7640_();
                if (directEntity instanceof Player) {
                    Player player = (Player)directEntity;
                    UnsafeFieldOffsets.UNSAFE.putObject(entity, UnsafeFieldOffsets.OFF_ENTITY_LAST_HURT_BY, player);
                    UnsafeFieldOffsets.UNSAFE.putInt(entity, UnsafeFieldOffsets.OFF_ENTITY_LAST_HURT_TIME, 100);
                }
                if (directEntity instanceof LivingEntity) {
                    LivingEntity livingAttacker = (LivingEntity)directEntity;
                    UnsafeFieldOffsets.UNSAFE.putObject(entity, UnsafeFieldOffsets.OFF_ENTITY_LAST_HURT_BY_MOB, livingAttacker);
                    UnsafeFieldOffsets.UNSAFE.putInt(entity, UnsafeFieldOffsets.OFF_ENTITY_LAST_HURT_BY_MOB_TIME, (int)entity.m_9236_().m_46467_());
                }
            }
            if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                UnsafeUtil.syncDeathToClients(entity, serverLevel);
            }
            return true;
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeSetDead failed: {}", t.getMessage());
            return false;
        }
    }

    private static void syncDeathToClients(LivingEntity entity, ServerLevel serverLevel) {
        if (entity == null) {
            return;
        }
        try {
            Object synchedData = UnsafeFieldOffsets.UNSAFE.getObject(entity, UnsafeFieldOffsets.OFF_ENTITY_DATA);
            if (synchedData != null) {
                UnsafeFieldOffsets.UNSAFE.putBoolean(synchedData, UnsafeFieldOffsets.OFF_SYNCHED_DIRTY, true);
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
            }
            serverLevel.m_7726_().m_8394_((Entity)entity, (Packet)new ClientboundSetEntityDataPacket(entity.m_19879_(), entity.m_20088_().m_252804_()));
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Failed to sync death to clients: " + e.getMessage());
        }
    }

    public static boolean UnsafeRemove(Entity entity, Entity.RemovalReason reason) {
        if (entity == null) {
            return false;
        }
        try {
            UnsafeUtil.UnsafeSetRemoved(entity, Entity.RemovalReason.KILLED);
            UnsafeUtil.UnsafeTriggerEntityManagerCallback(entity);
            UnsafeUtil.UnsafeHandleEntityPassengers(entity);
            UnsafeUtil.UnsafeLevelKnownUuidsRemove(entity);
            UnsafeUtil.UnsafeLevelEntityLookupRemove(entity);
            UnsafeUtil.UnsafeLevelTickListRemove(entity);
            UnsafeUtil.UnsafeChunkTrackedEntityRemove(entity);
            UnsafeUtil.UnsafeChunkEntitySectionStorageRemove(entity);
            UnsafeUtil.UnsafeCleanupMultipartEntity(entity);
            UnsafeUtil.UnsafeCleanupNavigatingMobs(entity);
            UnsafeUtil.UnsafeCleanupServerLevelPlayers(entity);
            int entityHash = entity.m_19879_() * 31 + entity.m_20148_().hashCode();
            Random rand = new Random(entityHash);
            double voidX = 1024 * (rand.nextInt(2000) - 1000);
            double voidY = -1024.0;
            double voidZ = 1024 * (rand.nextInt(2000) - 1000);
            UnsafeUtil.UnsafeTeleport(entity, voidX, voidY, voidZ);
            return true;
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeRemove failed for entity {}: {}", entity.m_19879_(), t.getMessage());
            return false;
        }
    }

    public static boolean UnsafeSetRemoved(Entity entity, Entity.RemovalReason reason) {
        if (entity == null) {
            return false;
        }
        try {
            UnsafeFieldOffsets.UNSAFE.putObject(entity, UnsafeFieldOffsets.OFF_ENTITY_REMOVAL_REASON, reason);
            return true;
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeSetRemoved failed: {}", t.getMessage());
            return false;
        }
    }

    private static void UnsafeTriggerEntityManagerCallback(Entity entity) {
        if (entity == null) {
            return;
        }
        try {
            if (UnsafeFieldOffsets.OFF_ENTITY_LEVEL_CALLBACK <= 0L) {
                return;
            }
            Object callback = UnsafeFieldOffsets.UNSAFE.getObject(entity, UnsafeFieldOffsets.OFF_ENTITY_LEVEL_CALLBACK);
            if (callback != null) {
                try {
                    Method onRemoveMethod = callback.getClass().getMethod("onRemove", Entity.RemovalReason.class);
                    onRemoveMethod.invoke(callback, Entity.RemovalReason.KILLED);
                }
                catch (Exception e) {
                    TheLastSwordLogger.warn("Failed to trigger EntityInLevelCallback.onRemove: {}", e.getMessage());
                }
            }
            UnsafeFieldOffsets.UNSAFE.putObject(entity, UnsafeFieldOffsets.OFF_ENTITY_LEVEL_CALLBACK, EntityInLevelCallback.f_156799_);
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeTriggerEntityManagerCallback failed: {}", t.getMessage());
        }
    }

    private static void UnsafeLevelKnownUuidsRemove(Entity entity) {
        if (entity == null) {
            return;
        }
        try {
            Level level = entity.m_9236_();
            String levelClassName = level.getClass().getSimpleName();
            if (levelClassName.equals("ServerLevel")) {
                Object entityManager = UnsafeFieldOffsets.UNSAFE.getObject(level, UnsafeFieldOffsets.OFF_SERVER_ENTITY_MANAGER);
                if (entityManager == null) {
                    return;
                }
                Object knownUuids = UnsafeFieldOffsets.UNSAFE.getObject(entityManager, UnsafeFieldOffsets.OFF_MANAGER_KNOWN_UUIDS);
                if (knownUuids instanceof Set) {
                    ((Set)knownUuids).remove(entity.m_20148_());
                }
            }
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeLevelKnownUuidsRemove failed: {}", t.getMessage());
        }
    }

    private static void UnsafeLevelEntityLookupRemove(Entity entity) {
        if (entity == null) {
            return;
        }
        try {
            Object entityLookup;
            Level level = entity.m_9236_();
            if (level == null) {
                return;
            }
            String levelClassName = level.getClass().getSimpleName();
            if (levelClassName.equals("ServerLevel")) {
                Object entityManager = UnsafeFieldOffsets.UNSAFE.getObject(level, UnsafeFieldOffsets.OFF_SERVER_ENTITY_MANAGER);
                if (entityManager == null) {
                    return;
                }
                entityLookup = UnsafeFieldOffsets.UNSAFE.getObject(entityManager, UnsafeFieldOffsets.OFF_MANAGER_VISIBLE_STORAGE);
            } else if (levelClassName.equals("ClientLevel")) {
                Object entityManager = UnsafeFieldOffsets.UNSAFE.getObject(level, UnsafeFieldOffsetsClient.OFF_CLIENT_ENTITY_STORAGE);
                if (entityManager == null) {
                    return;
                }
                entityLookup = UnsafeFieldOffsets.UNSAFE.getObject(entityManager, UnsafeFieldOffsetsClient.OFF_TESM_ENTITY_STORAGE);
            } else {
                return;
            }
            if (entityLookup != null) {
                UnsafeUtil.clearEntityFromLookup(entityLookup, entity);
            }
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeLevelEntityLookupRemove failed for entity {}: {}", entity.m_19879_(), t.getMessage());
        }
    }

    private static void UnsafeLevelTickListRemove(Entity entity) {
        if (entity == null) {
            return;
        }
        try {
            Object tickList;
            Level level = entity.m_9236_();
            if (level == null) {
                return;
            }
            String levelClassName = level.getClass().getSimpleName();
            if (levelClassName.equals("ServerLevel")) {
                tickList = UnsafeFieldOffsets.UNSAFE.getObject(level, UnsafeFieldOffsets.OFF_SERVER_ENTITY_TICK_LIST);
            } else if (levelClassName.equals("ClientLevel")) {
                tickList = UnsafeFieldOffsets.UNSAFE.getObject(level, UnsafeFieldOffsetsClient.OFF_CLIENT_TICKING_ENTITIES);
            } else {
                return;
            }
            if (tickList == null) {
                return;
            }
            Object iterated = UnsafeFieldOffsets.UNSAFE.getObject(tickList, UnsafeFieldOffsets.OFF_TICKLIST_ITERATED);
            Object active = UnsafeFieldOffsets.UNSAFE.getObject(tickList, UnsafeFieldOffsets.OFF_TICKLIST_ACTIVE);
            Object passive = UnsafeFieldOffsets.UNSAFE.getObject(tickList, UnsafeFieldOffsets.OFF_TICKLIST_PASSIVE);
            if (iterated == active) {
                if (passive instanceof Int2ObjectMap) {
                    ((Int2ObjectMap)passive).clear();
                }
                if (active instanceof Int2ObjectMap && passive instanceof Int2ObjectMap) {
                    Int2ObjectMap activeMap = (Int2ObjectMap)active;
                    Int2ObjectMap passiveMap = (Int2ObjectMap)passive;
                    activeMap.forEach((id, ent) -> passiveMap.put(id, ent));
                }
                UnsafeFieldOffsets.UNSAFE.putObject(tickList, UnsafeFieldOffsets.OFF_TICKLIST_ACTIVE, passive);
                UnsafeFieldOffsets.UNSAFE.putObject(tickList, UnsafeFieldOffsets.OFF_TICKLIST_PASSIVE, active);
                active = passive;
            }
            if (active instanceof Int2ObjectMap) {
                ((Int2ObjectMap)active).remove(entity.m_19879_());
            }
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeLevelTickListRemove failed: {}", t.getMessage());
        }
    }

    private static void UnsafeChunkTrackedEntityRemove(Entity entity) {
        if (entity == null) {
            return;
        }
        try {
            Level level = entity.m_9236_();
            if (level == null || !level.getClass().getSimpleName().equals("ServerLevel")) {
                return;
            }
            Object chunkSource = UnsafeFieldOffsets.UNSAFE.getObject(level, UnsafeFieldOffsets.OFF_SERVER_CHUNK_SOURCE);
            if (chunkSource == null) {
                return;
            }
            Object chunkMap = UnsafeFieldOffsets.UNSAFE.getObject(chunkSource, UnsafeFieldOffsets.OFF_CHUNK_SOURCE_CHUNK_MAP);
            if (chunkMap == null) {
                return;
            }
            Object entityMap = UnsafeFieldOffsets.UNSAFE.getObject(chunkMap, UnsafeFieldOffsets.OFF_CHUNK_MAP_ENTITY_MAP);
            if (entityMap == null) {
                return;
            }
            int entityId = entity.m_19879_();
            if (entityMap != null) {
                if (entityMap instanceof Int2ObjectMap) {
                    ((Int2ObjectMap)entityMap).remove(entityId);
                } else if (entityMap instanceof Map) {
                    ((Map)entityMap).remove(entityId);
                }
            }
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeChunkTrackedEntityRemove failed: {}", t.getMessage());
        }
    }

    private static void UnsafeChunkEntitySectionStorageRemove(Entity entity) {
        if (entity == null) {
            return;
        }
        try {
            Object sections;
            Object entityManager;
            Level level = entity.m_9236_();
            if (level == null) {
                return;
            }
            String levelClassName = level.getClass().getSimpleName();
            if (levelClassName.equals("ServerLevel")) {
                entityManager = UnsafeFieldOffsets.UNSAFE.getObject(level, UnsafeFieldOffsets.OFF_SERVER_ENTITY_MANAGER);
            } else if (levelClassName.equals("ClientLevel")) {
                entityManager = UnsafeFieldOffsets.UNSAFE.getObject(level, UnsafeFieldOffsetsClient.OFF_CLIENT_ENTITY_STORAGE);
            } else {
                return;
            }
            if (entityManager == null) {
                return;
            }
            Object sectionStorage = levelClassName.equals("ServerLevel") ? UnsafeFieldOffsets.UNSAFE.getObject(entityManager, UnsafeFieldOffsets.OFF_MANAGER_SECTION_STORAGE) : UnsafeFieldOffsets.UNSAFE.getObject(entityManager, UnsafeFieldOffsetsClient.OFF_TESM_SECTION_STORAGE);
            if (sectionStorage == null) {
                return;
            }
            Object sectionsMap = UnsafeFieldOffsets.UNSAFE.getObject(sectionStorage, UnsafeFieldOffsets.OFF_ENTITY_SECTION_STORAGE_SECTIONS);
            if (sectionsMap == null) {
                return;
            }
            if (sectionsMap instanceof Long2ObjectMap) {
                sections = ((Long2ObjectMap)sectionsMap).values();
            } else if (sectionsMap instanceof Map) {
                sections = ((Map)sectionsMap).values();
            } else {
                return;
            }
            for (Object entitySection : sections) {
                Object storage;
                if (entitySection == null || (storage = UnsafeFieldOffsets.UNSAFE.getObject(entitySection, UnsafeFieldOffsets.OFF_ENTITY_SECTION_STORAGE)) == null) continue;
                UnsafeUtil.UnsafeClassInstanceMultiMapRemove(storage, entity);
            }
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeChunkEntitySectionStorageRemove failed: {}", t.getMessage());
        }
    }

    private static void UnsafeClassInstanceMultiMapRemove(Object multiMap, Entity entity) {
        if (multiMap == null || entity == null) {
            return;
        }
        try {
            Class<?> entityClass;
            Map classMap;
            List entityList;
            Object byClassMap;
            Object allInstances = UnsafeFieldOffsets.UNSAFE.getObject(multiMap, UnsafeFieldOffsets.OFF_MULTIMAP_ALL_INSTANCES);
            if (allInstances != null && allInstances instanceof List) {
                ((List)allInstances).remove(entity);
            }
            if ((byClassMap = UnsafeFieldOffsets.UNSAFE.getObject(multiMap, UnsafeFieldOffsets.OFF_MULTIMAP_BY_CLASS)) != null && byClassMap instanceof Map && (entityList = (List)(classMap = (Map)byClassMap).get(entityClass = entity.getClass())) != null) {
                entityList.remove(entity);
                if (entityList.isEmpty()) {
                    classMap.remove(entityClass);
                }
            }
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeClassInstanceMultiMapRemove failed: {}", t.getMessage());
        }
    }

    private static void UnsafeCleanupMultipartEntity(Entity entity) {
        if (entity == null || !entity.isMultipartEntity()) {
            return;
        }
        try {
            Object partEntities;
            Level level = entity.m_9236_();
            if (level == null) {
                return;
            }
            String levelClassName = level.getClass().getSimpleName();
            if (levelClassName.equals("ServerLevel")) {
                Object dragonParts = UnsafeFieldOffsets.UNSAFE.getObject(level, UnsafeFieldOffsets.OFF_SERVER_DRAGON_PARTS);
                if (dragonParts instanceof Int2ObjectMap) {
                    Int2ObjectMap partMap = (Int2ObjectMap)dragonParts;
                    for (PartEntity part : entity.getParts()) {
                        partMap.remove(part.m_19879_());
                    }
                }
            } else if (levelClassName.equals("ClientLevel") && (partEntities = UnsafeFieldOffsets.UNSAFE.getObject(level, UnsafeFieldOffsetsClient.OFF_CLIENT_PART_ENTITIES)) instanceof Int2ObjectMap) {
                Int2ObjectMap partMap = (Int2ObjectMap)partEntities;
                for (PartEntity part : entity.getParts()) {
                    partMap.remove(part.m_19879_());
                }
            }
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeCleanupMultipartEntity failed: {}", t.getMessage());
        }
    }

    private static void UnsafeCleanupNavigatingMobs(Entity entity) {
        if (entity == null || !(entity instanceof Mob)) {
            return;
        }
        try {
            ServerLevel serverLevel;
            Object navigatingMobs;
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel && (navigatingMobs = UnsafeFieldOffsets.UNSAFE.getObject(serverLevel = (ServerLevel)level, UnsafeFieldOffsets.OFF_SERVER_NAVIGATING_MOBS)) instanceof Set) {
                ((Set)navigatingMobs).remove((Mob)entity);
            }
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeCleanupNavigatingMobs failed: {}", t.getMessage());
        }
    }

    private static void UnsafeCleanupServerLevelPlayers(Entity entity) {
        if (entity == null || !(entity instanceof ServerPlayer)) {
            return;
        }
        try {
            ServerLevel serverLevel;
            Object players;
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel && (players = UnsafeFieldOffsets.UNSAFE.getObject(serverLevel = (ServerLevel)level, UnsafeFieldOffsets.OFF_SERVER_PLAYERS)) instanceof List) {
                ((List)players).remove(entity);
            }
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeCleanupServerLevelPlayers failed: {}", t.getMessage());
        }
    }

    private static void UnsafeHandleEntityPassengers(Entity entity) {
        try {
            List passengers = entity.m_20197_();
            for (int i = passengers.size() - 1; i >= 0; --i) {
                Entity passenger = (Entity)passengers.get(i);
                if (passenger == null) continue;
                passenger.m_8127_();
            }
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("UnsafeHandleEntityPassengers failed: {}", t.getMessage());
        }
    }

    private static Object createEmptyInstance(Object original) {
        if (original == null) {
            return null;
        }
        String className = original.getClass().getName();
        try {
            if (className.contains("fastutil")) {
                if (className.contains("Int2Object")) {
                    return new Int2ObjectOpenHashMap();
                }
                if (className.contains("Long2Object")) {
                    return new Long2ObjectOpenHashMap();
                }
            }
            if (original instanceof Map) {
                return new HashMap();
            }
            if (original instanceof Set) {
                return new HashSet();
            }
            if (original instanceof List) {
                return new ArrayList();
            }
            TheLastSwordLogger.warn("Unknown collection type: {}", className);
            return null;
        }
        catch (Exception e) {
            TheLastSwordLogger.error("Failed to create empty instance for type {}: {}", className, e.getMessage());
            return null;
        }
    }

    private static void safelyPutEmpty(Object target, long offset, Object originalValue) {
        Object emptyInstance = UnsafeUtil.createEmptyInstance(originalValue);
        if (emptyInstance != null) {
            UnsafeFieldOffsets.UNSAFE.putObject(target, offset, emptyInstance);
        }
    }

    private static void clearEntityFromLookup(Object entityLookup, Entity entity) {
        if (entityLookup == null || entity == null) {
            return;
        }
        try {
            Object byUuidMap;
            Object byIdMap = UnsafeFieldOffsets.UNSAFE.getObject(entityLookup, UnsafeFieldOffsets.OFF_LOOKUP_BY_ID);
            if (byIdMap != null && byIdMap instanceof Int2ObjectMap) {
                ((Int2ObjectMap)byIdMap).remove(entity.m_19879_());
            }
            if ((byUuidMap = UnsafeFieldOffsets.UNSAFE.getObject(entityLookup, UnsafeFieldOffsets.OFF_LOOKUP_BY_UUID)) != null && byUuidMap instanceof Map) {
                try {
                    Map uuidMap = (Map)byUuidMap;
                    uuidMap.remove(entity.m_20148_());
                }
                catch (ClassCastException e) {
                    TheLastSwordLogger.error("byUuid map cast failed: {}", e.getMessage());
                }
            }
        }
        catch (Throwable t) {
            TheLastSwordLogger.error("clearEntityFromLookup failed: {}", t.getMessage());
        }
    }

    private static Object getMapEntry(Object map, int key) {
        if (map == null) {
            return null;
        }
        try {
            if (UnsafeFieldOffsets.FASTUTIL_INT2OBJ != null && map.getClass().getName().contains("fastutil")) {
                return ((Int2ObjectMap)map).get(key);
            }
            return ((Map)map).get(key);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

