package ca.maximilian.bluemap_viewer;

import com.cinemamod.mcef.MCEF;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_757;
import net.minecraft.client.render.*;
import java.awt.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static ca.maximilian.bluemap_viewer.BluemapViewer.browser;

public class BasicBrowser extends class_437 {
    private static class_310 minecraft;

    public static class_4185 changeUrlButton;
    public String url = "about:blank";

    public BasicBrowser(class_2561 title) {
        super(title);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        minecraft = class_310.method_1551();
        Config config = Config.HANDLER.instance();
        if (browser != null) {
            browser.close();
            browser = null;
        }
        if (browser == null) {
            String serverIp = Objects.requireNonNull(class_310.method_1551().method_1558()).field_3761;
            Config.HANDLER.load();
            List<? extends String> serverUrls = config.serverUrls;
            Boolean found = false;
            for (String checkingUrl : serverUrls) {
                String checkingIp = checkingUrl.split("=")[0];
                String serverUrl = checkingUrl.split("=")[1];

                if (serverIp.equals(checkingIp)) {
                    url = serverUrl;
                    found = true;
                }
            }
            if (!found) {
                minecraft.method_1507(new NewServerScreen(class_2561.method_43470("Add new url for: " + serverIp)));
            }
            browser = MCEF.createBrowser(url, false);
            changeUrlButton = class_4185.method_46430(class_2561.method_43471("bluemap_viewer.ui.string.changeUrl"), button -> {

                List<String> urls = new ArrayList<>(config.serverUrls);
                urls.remove(Objects.requireNonNull(class_310.method_1551().method_1558()).field_3761+"="+url);
                minecraft.method_1507(null);
                config.serverUrls = urls;
                Config.HANDLER.save();

                minecraft.method_1507(new NewServerScreen(class_2561.method_43470("Edit url for: " + serverIp)));
            }).method_46434(5, this.field_22790 - 25, 100, 20).method_46431();
            resizeBrowser();
        }
    }

    private int mouseX(double x) {
        return (int) ((x) * minecraft.method_22683().method_4495());
    }

    private int mouseY(double y) {
        return (int) ((y) * minecraft.method_22683().method_4495());
    }

    private int scaleX(double x) {
        return (int) ((x) * minecraft.method_22683().method_4495());
    }

    private int scaleY(double y) {
        return (int) ((y) * minecraft.method_22683().method_4495());
    }

    private void resizeBrowser() {
        if (field_22789 > 100 && field_22790 > 100 && browser != null) {
            browser.resize(scaleX(field_22789), scaleY(field_22790));
        }
    }

    @Override
    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        resizeBrowser();
    }

    @Override
    public void method_25419() {
        if (browser != null) {
            browser.close();
            browser = null; // Prevent potential memory leaks
        }
        super.method_25419();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (browser == null || browser.getRenderer() == null) {
            return;
        }

        // Store current render state
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture(0, browser.getRenderer().getTextureID());
        class_289 t = class_289.method_1348();
        class_287 buffer = t.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        buffer.method_22912(0, field_22790, 0).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, 255).method_1344();
        buffer.method_22912(field_22789, field_22790, 0).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, 255).method_1344();
        buffer.method_22912(field_22789, 0, 0).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
        buffer.method_22912(0, 0, 0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
        t.method_1350();
        RenderSystem.setShaderTexture(0, 0);
        RenderSystem.enableDepthTest();

        changeUrlButton.method_25394(guiGraphics, mouseX, mouseY, delta);

        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {

        if (changeUrlButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }

        if (browser != null) {
            browser.sendMousePress(mouseX(mouseX), mouseY(mouseY), button);
            browser.setFocus(true);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (browser != null) {
            browser.sendMouseRelease(mouseX(mouseX), mouseY(mouseY), button);
            browser.setFocus(true);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        if (browser != null) {
            browser.sendMouseMove(mouseX(mouseX), mouseY(mouseY));
        }
        super.method_16014(mouseX, mouseY);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (browser != null) {
            browser.sendMouseMove(mouseX(mouseX), mouseY(mouseY));
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (browser != null) {
            browser.sendMouseWheel(
                    (int) mouseX,
                    (int) mouseY,
                    amount,
                    0
            );
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (browser != null) {
            browser.sendKeyPress(keyCode, scanCode, modifiers);
            browser.setFocus(true);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (browser != null) {
            browser.sendKeyRelease(keyCode, scanCode, modifiers);
            browser.setFocus(true);
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25400(char codePoint, int modifiers) {
        if (codePoint == 0 || browser == null) return false;
        browser.sendKeyTyped(codePoint, modifiers);
        browser.setFocus(true);
        return super.method_25400(codePoint, modifiers);
    }
}