package ca.maximilian.bluemap_viewer;

import com.cinemamod.mcef.MCEFBrowser;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_370;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluemapViewer implements ModInitializer {
	public static final String MOD_ID = "bluemap_viewer";
    public static MCEFBrowser browser;

    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
    public static class_310 MINECRAFT_CLIENT;

    public static final class_304 OPEN_BROWSER_KEY = KeyBindingHelper.registerKeyBinding(new class_304(
            "key.bluemap_viewer.open_browser",
            class_3675.class_307.field_1668,
            GLFW.GLFW_KEY_M,
            "key.categories.bluemap_viewer"
    ));

	@Override
	public void onInitialize() {
		LOGGER.info("Loading Bluemap Viewer");
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            LOGGER.warn("Please use this mod on the client it will stop execution now!");
        } else {
            Config.HANDLER.load();
            MINECRAFT_CLIENT = class_310.method_1551();
            LOGGER.info("Loading event handlers");
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                while (OPEN_BROWSER_KEY.method_1436()) {
                    class_310 minecraft = class_310.method_1551();
                    if (minecraft.field_1687 != null && minecraft.field_1687.field_9236 && !minecraft.method_1542()) {
                        class_2561 title = class_2561.method_43470("BlueMap Viewer");
                        minecraft.method_1507(new BasicBrowser(title));
                    }
                    if (minecraft.method_1542()) {
                        class_370.method_27024(class_310.method_1551().method_1566(), class_370.class_371.field_36445,
                                class_2561.method_43471("bluemap_viewer.errors.multiplayer.title"), class_2561.method_43471("bluemap_viewer.errors.multiplayer.desc"));
                    }
                }
            });
        }
	}
}