package ca.maximilian.bluemap_viewer;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import java.util.List;
import net.minecraft.class_2561;

public class ModMenuIntegration implements ModMenuApi {
    @Override
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            // Create the config screen builder directly through YetAnotherConfigLib
            var builder = YetAnotherConfigLib.createBuilder()
                    .title(class_2561.method_43471("bluemap_viewer.configuration.title"))
                    .category(ConfigCategory.createBuilder()
                            .name(class_2561.method_43471("bluemap_viewer.configuration.general"))
                            .group(OptionGroup.createBuilder()
                                    .name(class_2561.method_43471("bluemap_viewer.configuration.serverUrls"))
                                    .option(Option.<String>createBuilder()
                                            .name(class_2561.method_43471("bluemap_viewer.configuration.serverUrls"))
                                            .binding(
                                                    "",
                                                    () -> String.join(", ", Config.HANDLER.instance().serverUrls),
                                                    value -> Config.HANDLER.instance().serverUrls =
                                                            List.of(value.split("\\s*,\\s*"))
                                            )
                                            .controller(StringControllerBuilder::create)
                                            .build())
                                    .build())
                            .build());

            return builder.build().generateScreen(parent);
        };
    }
}
