package ca.maximilian.bluemap_viewer;

import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_7842;

import static ca.maximilian.bluemap_viewer.BluemapViewer.MINECRAFT_CLIENT;
import static ca.maximilian.bluemap_viewer.BluemapViewer.browser;

public class NewServerScreen extends class_437 {
    private class_342 inputBox;
    private class_7842 label;

    protected NewServerScreen(class_2561 title) {
        super(title);
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        if (browser != null) {
            browser.close();
            browser = null;
        }

        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;

        label = new class_7842(class_2561.method_43471("bluemap_viewer.ui.string.enterurl"), field_22793);
        label.method_48229(centerX - 100, centerY - 20);
        this.method_37060(label);

        inputBox = new class_342(field_22793, centerX - 100, centerY - 10, 200, 20, class_2561.method_43471("bluemap_viewer.ui.string.placeholder"));
        inputBox.method_25365(true);
        inputBox.method_1880(2147483647);
        this.method_37060(inputBox);
    }

    @Override
    public void method_25419() {
        if (browser != null) {
            browser.close();
            browser = null; // Prevent potential memory leaks
        }
        super.method_25419();
    }

    @Override
    public boolean method_25422() {
        return true;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        label.method_25394(guiGraphics, mouseX, mouseY, delta);
        inputBox.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    @Override
    public boolean method_25400(char chr, int modifiers) {
        if (inputBox.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Config config = Config.HANDLER.instance();

        if (keyCode == GLFW.GLFW_KEY_ESCAPE) {
            MINECRAFT_CLIENT.method_1507(null);
            return true;
        }

        if (keyCode == GLFW.GLFW_KEY_ENTER && !inputBox.method_1882().isBlank()) {
            List<String> urls = new ArrayList<>(config.serverUrls);
            urls.add(Objects.requireNonNull(class_310.method_1551().method_1558()).field_3761 + "=" + inputBox.method_1882());
            config.serverUrls = urls;
            Config.HANDLER.save();
            MINECRAFT_CLIENT.method_1507(new BasicBrowser(class_2561.method_43470("Bluemap Viewer")));
            return true;
        }

        if (inputBox.method_25404(keyCode, scanCode, modifiers) || inputBox.method_25370()) {
            return true;
        }

        return super.method_25404(keyCode, scanCode, modifiers);
    }

}
