/*
 * Decompiled with CFR 0.152.
 */
package com.timberreplant.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SaplingUtil {
    private static final Map<Block, Block> LOG_TO_SAPLING = new HashMap<Block, Block>();

    public static Block getSaplingForLog(Block logBlock) {
        return LOG_TO_SAPLING.get(logBlock);
    }

    public static boolean plantSapling(Level level, BlockPos pos, Block saplingBlock) {
        if (saplingBlock == null) {
            return false;
        }
        if (!SaplingUtil.canPlantSapling(level, pos, saplingBlock)) {
            return false;
        }
        BlockState saplingState = saplingBlock.m_49966_();
        level.m_7731_(pos, saplingState, 3);
        return true;
    }

    private static boolean canPlantSapling(Level level, BlockPos pos, Block saplingBlock) {
        BlockState currentState = level.m_8055_(pos);
        if (!currentState.m_60795_() && !currentState.m_247087_()) {
            return false;
        }
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        if (belowState.m_60713_(Blocks.f_50493_) || belowState.m_60713_(Blocks.f_50440_) || belowState.m_60713_(Blocks.f_50599_) || belowState.m_60713_(Blocks.f_50546_) || belowState.m_60713_(Blocks.f_152549_) || belowState.m_60713_(Blocks.f_50195_)) {
            return true;
        }
        if (saplingBlock == Blocks.f_220831_) {
            return belowState.m_60713_(Blocks.f_50493_) || belowState.m_60713_(Blocks.f_50440_) || belowState.m_60713_(Blocks.f_50599_) || belowState.m_60713_(Blocks.f_220864_) || belowState.m_60713_(Blocks.f_220834_);
        }
        return false;
    }

    public static void dropSaplingAsItem(Level level, BlockPos pos, Block saplingBlock) {
        if (saplingBlock == null) {
            return;
        }
        ItemStack saplingStack = new ItemStack((ItemLike)saplingBlock.m_5456_());
        ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, saplingStack);
        level.m_7967_((Entity)itemEntity);
    }

    static {
        LOG_TO_SAPLING.put(Blocks.f_49999_, Blocks.f_50746_);
        LOG_TO_SAPLING.put(Blocks.f_50010_, Blocks.f_50746_);
        LOG_TO_SAPLING.put(Blocks.f_50011_, Blocks.f_50746_);
        LOG_TO_SAPLING.put(Blocks.f_50044_, Blocks.f_50746_);
        LOG_TO_SAPLING.put(Blocks.f_50001_, Blocks.f_50748_);
        LOG_TO_SAPLING.put(Blocks.f_50006_, Blocks.f_50748_);
        LOG_TO_SAPLING.put(Blocks.f_50013_, Blocks.f_50748_);
        LOG_TO_SAPLING.put(Blocks.f_50046_, Blocks.f_50748_);
        LOG_TO_SAPLING.put(Blocks.f_50000_, Blocks.f_50747_);
        LOG_TO_SAPLING.put(Blocks.f_50005_, Blocks.f_50747_);
        LOG_TO_SAPLING.put(Blocks.f_50012_, Blocks.f_50747_);
        LOG_TO_SAPLING.put(Blocks.f_50045_, Blocks.f_50747_);
        LOG_TO_SAPLING.put(Blocks.f_50002_, Blocks.f_50749_);
        LOG_TO_SAPLING.put(Blocks.f_50007_, Blocks.f_50749_);
        LOG_TO_SAPLING.put(Blocks.f_50014_, Blocks.f_50749_);
        LOG_TO_SAPLING.put(Blocks.f_50047_, Blocks.f_50749_);
        LOG_TO_SAPLING.put(Blocks.f_50003_, Blocks.f_50750_);
        LOG_TO_SAPLING.put(Blocks.f_50008_, Blocks.f_50750_);
        LOG_TO_SAPLING.put(Blocks.f_50015_, Blocks.f_50750_);
        LOG_TO_SAPLING.put(Blocks.f_50048_, Blocks.f_50750_);
        LOG_TO_SAPLING.put(Blocks.f_50004_, Blocks.f_50751_);
        LOG_TO_SAPLING.put(Blocks.f_50009_, Blocks.f_50751_);
        LOG_TO_SAPLING.put(Blocks.f_50043_, Blocks.f_50751_);
        LOG_TO_SAPLING.put(Blocks.f_50049_, Blocks.f_50751_);
        LOG_TO_SAPLING.put(Blocks.f_220832_, Blocks.f_220831_);
        LOG_TO_SAPLING.put(Blocks.f_220835_, Blocks.f_220831_);
        LOG_TO_SAPLING.put(Blocks.f_220836_, Blocks.f_220831_);
        LOG_TO_SAPLING.put(Blocks.f_220837_, Blocks.f_220831_);
        LOG_TO_SAPLING.put(Blocks.f_271170_, Blocks.f_271334_);
        LOG_TO_SAPLING.put(Blocks.f_271326_, Blocks.f_271334_);
        LOG_TO_SAPLING.put(Blocks.f_271348_, Blocks.f_271334_);
        LOG_TO_SAPLING.put(Blocks.f_271145_, Blocks.f_271334_);
    }
}

