/*
 * Decompiled with CFR 0.152.
 */
package com.example.timberreplant.util;

import com.example.timberreplant.TimberReplant;
import com.example.timberreplant.config.TimberReplantConfig;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3481;

public class TreeDetector {
    private static final class_2350[] HORIZONTAL_DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039};
    private static final class_2350[] ALL_DIRECTIONS = class_2350.values();

    public static TreeStructure detectTree(class_1937 world, class_2338 startPos) {
        TimberReplantConfig config = TimberReplantConfig.getInstance();
        class_2248 startBlock = world.method_8320(startPos).method_26204();
        if (!TreeDetector.isLog(startBlock)) {
            return null;
        }
        if (!TreeDetector.hasNearbyLeaves(world, startPos)) {
            if (config.logFelling) {
                TimberReplant.LOGGER.info("No nearby leaves found at {}, not a natural tree", (Object)startPos);
            }
            return null;
        }
        HashSet<class_2338> visitedLogs = new HashSet<class_2338>();
        HashSet<class_2338> visitedLeaves = new HashSet<class_2338>();
        LinkedList<class_2338> logQueue = new LinkedList<class_2338>();
        logQueue.add(startPos);
        visitedLogs.add(startPos);
        class_2338 basePos = TreeDetector.findTreeBase(world, startPos, startBlock);
        while (!logQueue.isEmpty() && visitedLogs.size() < config.maxTreeSize) {
            class_2338 currentPos = (class_2338)logQueue.poll();
            for (class_2350 direction : ALL_DIRECTIONS) {
                int horizontalDistance;
                class_2248 neighborBlock;
                class_2338 neighborPos = currentPos.method_10093(direction);
                if (visitedLogs.contains(neighborPos) || !TreeDetector.isSameLogType(startBlock, neighborBlock = world.method_8320(neighborPos).method_26204()) || neighborPos.method_10264() - basePos.method_10264() > config.maxTreeHeight || (horizontalDistance = Math.max(Math.abs(neighborPos.method_10263() - basePos.method_10263()), Math.abs(neighborPos.method_10260() - basePos.method_10260()))) > 6 || !TreeDetector.isPartOfNaturalTree(world, neighborPos, visitedLogs)) continue;
                visitedLogs.add(neighborPos);
                logQueue.add(neighborPos);
            }
        }
        if (config.breakLeaves) {
            LinkedList<class_2338> leafQueue = new LinkedList<class_2338>();
            for (class_2338 logPos : visitedLogs) {
                for (class_2350 direction : ALL_DIRECTIONS) {
                    class_2248 neighborBlock;
                    class_2338 neighborPos = logPos.method_10093(direction);
                    if (visitedLeaves.contains(neighborPos) || visitedLogs.contains(neighborPos) || !TreeDetector.isLeaf(neighborBlock = world.method_8320(neighborPos).method_26204()) || !TreeDetector.belongsToThisTree(world, neighborPos, visitedLogs, basePos)) continue;
                    visitedLeaves.add(neighborPos);
                    leafQueue.add(neighborPos);
                }
            }
            while (!leafQueue.isEmpty() && visitedLogs.size() + visitedLeaves.size() < config.maxTreeSize) {
                class_2338 currentPos = (class_2338)leafQueue.poll();
                for (class_2350 direction : ALL_DIRECTIONS) {
                    class_2248 neighborBlock;
                    class_2338 neighborPos = currentPos.method_10093(direction);
                    if (visitedLeaves.contains(neighborPos) || visitedLogs.contains(neighborPos) || !TreeDetector.isLeaf(neighborBlock = world.method_8320(neighborPos).method_26204()) || !TreeDetector.belongsToThisTree(world, neighborPos, visitedLogs, basePos)) continue;
                    visitedLeaves.add(neighborPos);
                    leafQueue.add(neighborPos);
                }
            }
        }
        if (!TreeDetector.isValidNaturalTree(world, visitedLogs, visitedLeaves, basePos)) {
            if (config.logFelling) {
                TimberReplant.LOGGER.info("Tree structure validation failed at {}", (Object)basePos);
            }
            return null;
        }
        if (config.logFelling) {
            TimberReplant.LOGGER.info("Valid natural tree detected: {} logs, {} leaves at {}", new Object[]{visitedLogs.size(), visitedLeaves.size(), basePos});
        }
        return new TreeStructure(visitedLogs, visitedLeaves, basePos, startBlock);
    }

    private static class_2338 findTreeBase(class_1937 world, class_2338 startPos, class_2248 logType) {
        class_2338 belowPos;
        class_2248 belowBlock;
        class_2338 currentPos = startPos;
        while (TreeDetector.isSameLogType(logType, belowBlock = world.method_8320(belowPos = currentPos.method_10074()).method_26204())) {
            currentPos = belowPos;
        }
        return currentPos;
    }

    private static boolean belongsToThisTree(class_1937 world, class_2338 leafPos, Set<class_2338> treeLogs, class_2338 treeBase) {
        int horizontalDistance = Math.max(Math.abs(leafPos.method_10263() - treeBase.method_10263()), Math.abs(leafPos.method_10260() - treeBase.method_10260()));
        if (horizontalDistance > 4) {
            return false;
        }
        int verticalDistance = leafPos.method_10264() - treeBase.method_10264();
        if (verticalDistance < -1 || verticalDistance > 15) {
            return false;
        }
        boolean hasNearbyTreeLog = false;
        for (class_2338 logPos : treeLogs) {
            double distance = logPos.method_10262((class_2382)leafPos);
            if (!(distance <= 25.0)) continue;
            hasNearbyTreeLog = true;
            break;
        }
        if (!hasNearbyTreeLog) {
            return false;
        }
        double closestTreeDistance = Double.MAX_VALUE;
        for (class_2338 logPos : treeLogs) {
            double distance = logPos.method_10262((class_2382)leafPos);
            if (!(distance < closestTreeDistance)) continue;
            closestTreeDistance = distance;
        }
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    double distance;
                    class_2248 checkBlock;
                    class_2338 checkPos = leafPos.method_10069(dx, dy, dz);
                    if (treeLogs.contains(checkPos) || !TreeDetector.isLog(checkBlock = world.method_8320(checkPos).method_26204()) || !((distance = checkPos.method_10262((class_2382)leafPos)) < closestTreeDistance - 1.0)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean hasNearbyLeaves(class_1937 world, class_2338 logPos) {
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -2; dy <= 4; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    class_2338 checkPos = logPos.method_10069(dx, dy, dz);
                    if (!TreeDetector.isLeaf(world.method_8320(checkPos).method_26204())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isPartOfNaturalTree(class_1937 world, class_2338 logPos, Set<class_2338> existingLogs) {
        if (TreeDetector.hasNearbyLeaves(world, logPos)) {
            return true;
        }
        boolean hasVerticalConnection = false;
        for (class_2338 existingLog : existingLogs) {
            int dx = Math.abs(existingLog.method_10263() - logPos.method_10263());
            int dz = Math.abs(existingLog.method_10260() - logPos.method_10260());
            int dy = Math.abs(existingLog.method_10264() - logPos.method_10264());
            if ((dx > 1 || dz > 1 || dy != 1) && (dx != 0 || dz != 0)) continue;
            hasVerticalConnection = true;
            break;
        }
        return hasVerticalConnection;
    }

    private static boolean isValidNaturalTree(class_1937 world, Set<class_2338> logPositions, Set<class_2338> leafPositions, class_2338 basePos) {
        boolean validBase;
        class_2248 belowBase = world.method_8320(basePos.method_10074()).method_26204();
        boolean bl = validBase = belowBase == class_2246.field_10566 || belowBase == class_2246.field_10219 || belowBase == class_2246.field_10253 || belowBase == class_2246.field_10520 || belowBase == class_2246.field_10402 || belowBase == class_2246.field_28685 || belowBase == class_2246.field_10362;
        if (!validBase) {
            return false;
        }
        if (leafPositions.isEmpty()) {
            return false;
        }
        double leafToLogRatio = (double)leafPositions.size() / (double)logPositions.size();
        if (leafToLogRatio < 0.5) {
            return false;
        }
        int verticalLogs = 0;
        for (class_2338 logPos : logPositions) {
            if (logPos.method_10263() != basePos.method_10263() || logPos.method_10260() != basePos.method_10260()) continue;
            ++verticalLogs;
        }
        if (verticalLogs < 2 && logPositions.size() > 3) {
            return false;
        }
        boolean hasLeavesAboveLogs = false;
        for (class_2338 logPos : logPositions) {
            for (int dy = 0; dy <= 3; ++dy) {
                for (int dx = -2; dx <= 2; ++dx) {
                    for (int dz = -2; dz <= 2; ++dz) {
                        class_2338 checkPos = logPos.method_10069(dx, dy, dz);
                        if (!leafPositions.contains(checkPos)) continue;
                        hasLeavesAboveLogs = true;
                        break;
                    }
                    if (hasLeavesAboveLogs) break;
                }
                if (hasLeavesAboveLogs) break;
            }
            if (!hasLeavesAboveLogs) continue;
            break;
        }
        return hasLeavesAboveLogs;
    }

    public static boolean isLog(class_2248 block) {
        return block.method_9564().method_26164(class_3481.field_15475);
    }

    public static boolean isLeaf(class_2248 block) {
        return block.method_9564().method_26164(class_3481.field_15503);
    }

    private static boolean isSameLogType(class_2248 block1, class_2248 block2) {
        if (!TreeDetector.isLog(block1) || !TreeDetector.isLog(block2)) {
            return false;
        }
        String block1Name = block1.toString();
        String block2Name = block2.toString();
        String woodType1 = TreeDetector.getWoodType(block1Name);
        String woodType2 = TreeDetector.getWoodType(block2Name);
        return woodType1.equals(woodType2);
    }

    private static String getWoodType(String blockName) {
        if (blockName.contains("oak")) {
            return "oak";
        }
        if (blockName.contains("birch")) {
            return "birch";
        }
        if (blockName.contains("spruce")) {
            return "spruce";
        }
        if (blockName.contains("jungle")) {
            return "jungle";
        }
        if (blockName.contains("acacia")) {
            return "acacia";
        }
        if (blockName.contains("dark_oak")) {
            return "dark_oak";
        }
        if (blockName.contains("cherry")) {
            return "cherry";
        }
        if (blockName.contains("mangrove")) {
            return "mangrove";
        }
        if (blockName.contains("bamboo")) {
            return "bamboo";
        }
        if (blockName.contains("crimson")) {
            return "crimson";
        }
        if (blockName.contains("warped")) {
            return "warped";
        }
        return "unknown";
    }

    public static class_2248 getSaplingForLog(class_2248 logBlock) {
        if (logBlock == class_2246.field_10431 || logBlock == class_2246.field_10126 || logBlock == class_2246.field_10519 || logBlock == class_2246.field_10250) {
            return class_2246.field_10394;
        }
        if (logBlock == class_2246.field_10511 || logBlock == class_2246.field_10307 || logBlock == class_2246.field_10366 || logBlock == class_2246.field_10204) {
            return class_2246.field_10575;
        }
        if (logBlock == class_2246.field_10037 || logBlock == class_2246.field_10155 || logBlock == class_2246.field_10436 || logBlock == class_2246.field_10558) {
            return class_2246.field_10217;
        }
        if (logBlock == class_2246.field_10306 || logBlock == class_2246.field_10303 || logBlock == class_2246.field_10254 || logBlock == class_2246.field_10084) {
            return class_2246.field_10276;
        }
        if (logBlock == class_2246.field_10533 || logBlock == class_2246.field_9999 || logBlock == class_2246.field_10622 || logBlock == class_2246.field_10103) {
            return class_2246.field_10385;
        }
        if (logBlock == class_2246.field_10010 || logBlock == class_2246.field_10178 || logBlock == class_2246.field_10244 || logBlock == class_2246.field_10374) {
            return class_2246.field_10160;
        }
        if (logBlock == class_2246.field_37545 || logBlock == class_2246.field_37549 || logBlock == class_2246.field_37548 || logBlock == class_2246.field_37550) {
            return class_2246.field_37544;
        }
        if (logBlock == class_2246.field_42729 || logBlock == class_2246.field_42733 || logBlock == class_2246.field_42732 || logBlock == class_2246.field_42730) {
            return class_2246.field_42727;
        }
        if (logBlock == class_2246.field_41072 || logBlock == class_2246.field_41073) {
            return class_2246.field_10108;
        }
        if (logBlock == class_2246.field_22118 || logBlock == class_2246.field_22119) {
            return class_2246.field_22121;
        }
        if (logBlock == class_2246.field_22111 || logBlock == class_2246.field_22112) {
            return class_2246.field_22114;
        }
        return class_2246.field_10394;
    }

    public static class TreeStructure {
        public final Set<class_2338> logPositions;
        public final Set<class_2338> leafPositions;
        public final class_2338 basePosition;
        public final class_2248 logType;

        public TreeStructure(Set<class_2338> logPositions, Set<class_2338> leafPositions, class_2338 basePosition, class_2248 logType) {
            this.logPositions = new HashSet<class_2338>(logPositions);
            this.leafPositions = new HashSet<class_2338>(leafPositions);
            this.basePosition = basePosition;
            this.logType = logType;
        }

        public int getTotalBlocks() {
            return this.logPositions.size() + this.leafPositions.size();
        }
    }
}

