/*
 * Decompiled with CFR 0.152.
 */
package com.osama.timberreplant.event;

import com.osama.timberreplant.TimberReplantMod;
import com.osama.timberreplant.config.TimberReplantConfig;
import com.osama.timberreplant.util.SaplingUtil;
import com.osama.timberreplant.util.TreeDetector;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_47;
import net.minecraft.class_52;

public class TreeFellingEventHandler {
    public boolean onBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        class_1799 mainHand;
        if (world.method_8608()) {
            return true;
        }
        if (player == null) {
            return true;
        }
        if (!TreeDetector.isLog(state)) {
            return true;
        }
        if (!TimberReplantConfig.getEnableTreeFelling()) {
            return true;
        }
        if (TimberReplantConfig.getRequireTool() && ((mainHand = player.method_6047()).method_7960() || !mainHand.method_7951(state))) {
            return true;
        }
        TreeDetector.TreeData treeData = TreeDetector.detectTree(world, pos);
        if (treeData.logs.size() > 1 && TreeDetector.isNaturalTree(treeData)) {
            this.fellEntireTree(world, treeData, player, pos, state.method_26204());
            return false;
        }
        if (treeData.logs.size() > 1) {
            TimberReplantMod.LOGGER.info("Found {} connected logs but not treating as natural tree - allowing normal single-block break", (Object)treeData.logs.size());
        }
        return true;
    }

    private void fellEntireTree(class_1937 world, TreeDetector.TreeData treeData, class_1657 player, class_2338 originalPos, class_2248 logType) {
        class_1799 tool = player.method_6047();
        boolean canDamageTool = !tool.method_7960() && tool.method_7963();
        int logsBroken = 0;
        class_3218 serverWorld = (class_3218)world;
        TimberReplantMod.LOGGER.info("Felling tree with {} logs and {} leaves", (Object)treeData.logs.size(), (Object)treeData.leaves.size());
        for (class_2338 logPos : treeData.logs) {
            class_2680 logState = world.method_8320(logPos);
            if (!TreeDetector.isLog(logState)) continue;
            this.dropBlockLoot(serverWorld, logPos, logState, player);
            world.method_8650(logPos, false);
            ++logsBroken;
            if (!TimberReplantConfig.getPlaySounds()) continue;
            world.method_8396(null, logPos, class_3417.field_15215, class_3419.field_15245, 1.0f, 1.0f);
        }
        if (TimberReplantConfig.getFellLeaves()) {
            for (class_2338 leafPos : treeData.leaves) {
                class_2680 leafState = world.method_8320(leafPos);
                if (!TreeDetector.isLeaf(leafState)) continue;
                this.dropBlockLoot(serverWorld, leafPos, leafState, player);
                world.method_8650(leafPos, false);
                if (!TimberReplantConfig.getPlaySounds() || !(world.method_8409().method_43057() < 0.1f)) continue;
                world.method_8396(null, leafPos, class_3417.field_15037, class_3419.field_15245, 0.5f, 1.2f);
            }
        }
        if (TimberReplantConfig.getEnableSaplingReplanting() && TreeDetector.isNaturalTree(treeData)) {
            class_2248 saplingBlock = SaplingUtil.getSaplingForLog(logType);
            boolean planted = SaplingUtil.plantSapling(world, treeData.basePos, saplingBlock);
            if (planted) {
                if (TimberReplantConfig.getPlaySounds()) {
                    world.method_8396(null, treeData.basePos, class_3417.field_14653, class_3419.field_15245, 1.0f, 1.0f);
                }
                TimberReplantMod.LOGGER.info("Replanted {} at {}", (Object)saplingBlock.method_9539(), (Object)treeData.basePos);
            } else {
                SaplingUtil.dropSaplingAsItem(world, treeData.basePos, saplingBlock);
                TimberReplantMod.LOGGER.info("Dropped sapling item at {} (couldn't plant)", (Object)treeData.basePos);
            }
        } else if (TimberReplantConfig.getEnableSaplingReplanting()) {
            TimberReplantMod.LOGGER.info("Skipped sapling planting - detected structure is not a natural tree (likely placed blocks)");
        }
        if (TimberReplantConfig.getDamageTools() && canDamageTool && logsBroken > 0) {
            if (player instanceof class_3222) {
                tool.method_7970(logsBroken, world.method_8409(), (class_3222)player);
            } else {
                tool.method_7970(logsBroken, world.method_8409(), null);
            }
            TimberReplantMod.LOGGER.debug("Applied {} durability damage to tool for {} logs", (Object)logsBroken, (Object)logsBroken);
        }
    }

    private void dropBlockLoot(class_3218 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_52 lootTable = world.method_8503().method_3857().method_367(state.method_26204().method_26162());
        class_47.class_48 lootContextBuilder = new class_47.class_48(world).method_312(class_181.field_24424, (Object)new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5)).method_312(class_181.field_1229, (Object)player.method_6047()).method_306(class_181.field_1226, (Object)player).method_306(class_181.field_1224, (Object)state);
        class_47 lootContext = lootContextBuilder.method_309(class_173.field_1172);
        ObjectArrayList drops = lootTable.method_319(lootContext);
        for (class_1799 drop : drops) {
            if (drop.method_7960()) continue;
            class_1542 itemEntity = new class_1542((class_1937)world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, drop);
            itemEntity.method_6988();
            world.method_8649((class_1297)itemEntity);
        }
    }
}

