/*
 * Decompiled with CFR 0.152.
 */
package com.example.timberreplant;

import com.example.timberreplant.TimberReplant;
import com.example.timberreplant.config.TimberReplantConfig;
import com.example.timberreplant.util.TreeDetector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;

public class TreeFeller {
    private static final Set<class_2338> processingPositions = new HashSet<class_2338>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fellTree(class_1937 world, class_2338 pos, class_1657 player, class_1799 tool) {
        TimberReplantConfig config = TimberReplantConfig.getInstance();
        if (!config.enabled || world.field_9236 || processingPositions.contains(pos)) {
            return false;
        }
        if (!TreeFeller.canPlayerFellTree(player, tool, config)) {
            return false;
        }
        TreeDetector.TreeStructure tree = TreeDetector.detectTree(world, pos);
        if (tree == null) {
            return false;
        }
        if (config.logFelling) {
            TimberReplant.LOGGER.info("Felling tree at {} with {} log blocks and {} leaf blocks", new Object[]{pos, tree.logPositions.size(), tree.leafPositions.size()});
        }
        processingPositions.addAll(tree.logPositions);
        processingPositions.addAll(tree.leafPositions);
        try {
            if (config.instantBreak) {
                TreeFeller.fellTreeInstantly(world, tree, player, tool);
                if (config.replantSaplings) {
                    TreeFeller.plantSapling(world, tree.basePosition, tree.logType);
                }
            } else {
                TreeFeller.scheduleTreeFelling(world, tree, player, tool, config.replantSaplings ? tree : null);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            processingPositions.removeAll(tree.logPositions);
            processingPositions.removeAll(tree.leafPositions);
        }
    }

    private static boolean canPlayerFellTree(class_1657 player, class_1799 tool, TimberReplantConfig config) {
        if (config.requireAxe && !(tool.method_7909() instanceof class_1743)) {
            return false;
        }
        return !config.requireSneaking || player.method_5715();
    }

    private static void fellTreeInstantly(class_1937 world, TreeDetector.TreeStructure tree, class_1657 player, class_1799 tool) {
        TimberReplantConfig config = TimberReplantConfig.getInstance();
        for (class_2338 logPos : tree.logPositions) {
            TreeFeller.breakBlockWithDrops(world, logPos, player, tool);
            if (!config.consumeDurability || player.method_31549().field_7477) continue;
            TreeFeller.damageToolSafely(tool, 1, player);
        }
        if (config.breakLeaves) {
            for (class_2338 leafPos : tree.leafPositions) {
                TreeFeller.breakBlockWithDrops(world, leafPos, player, tool);
            }
        }
    }

    private static void scheduleTreeFelling(class_1937 world, TreeDetector.TreeStructure tree, class_1657 player, class_1799 tool, TreeDetector.TreeStructure treeForReplanting) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        TimberReplantConfig config = TimberReplantConfig.getInstance();
        ArrayList<class_2338> allPositions = new ArrayList<class_2338>(tree.logPositions);
        if (config.breakLeaves) {
            allPositions.addAll(tree.leafPositions);
        }
        for (int i = 0; i < allPositions.size(); ++i) {
            int index = i;
            class_2338 blockPos = (class_2338)allPositions.get(i);
            boolean isLog = tree.logPositions.contains(blockPos);
            boolean isLastBlock = i == allPositions.size() - 1;
            serverWorld.method_8503().execute(() -> {
                if (world.method_8320(blockPos).method_26215()) {
                    return;
                }
                TreeFeller.breakBlockWithDrops(world, blockPos, player, tool);
                if (isLog && config.consumeDurability && !player.method_31549().field_7477) {
                    TreeFeller.damageToolSafely(tool, 1, player);
                }
                if (isLastBlock && treeForReplanting != null) {
                    serverWorld.method_8503().execute(() -> TreeFeller.plantSapling(world, treeForReplanting.basePosition, treeForReplanting.logType));
                }
            });
        }
    }

    private static void breakBlockWithDrops(class_1937 world, class_2338 pos, class_1657 player, class_1799 tool) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26215()) {
            return;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_2248.method_9511((class_2680)state, (class_1937)world, (class_2338)pos, null, (class_1297)player, (class_1799)tool);
        }
        world.method_8501(pos, class_2246.field_10124.method_9564());
        world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
    }

    private static void plantSapling(class_1937 world, class_2338 basePos, class_2248 logType) {
        boolean validGround;
        if (world.field_9236) {
            return;
        }
        TimberReplantConfig config = TimberReplantConfig.getInstance();
        if (config.logFelling) {
            TimberReplant.LOGGER.info("Attempting to plant sapling for {} at {}", (Object)logType, (Object)basePos);
        }
        class_2680 groundState = world.method_8320(basePos.method_10074());
        class_2680 currentState = world.method_8320(basePos);
        if (config.logFelling) {
            TimberReplant.LOGGER.info("Ground block: {}, Current block: {}", (Object)groundState.method_26204(), (Object)currentState.method_26204());
        }
        if (!currentState.method_26215()) {
            if (config.logFelling) {
                TimberReplant.LOGGER.info("Cannot plant: position is not air");
            }
            return;
        }
        class_2248 groundBlock = groundState.method_26204();
        boolean bl = validGround = groundBlock == class_2246.field_10566 || groundBlock == class_2246.field_10219 || groundBlock == class_2246.field_10253 || groundBlock == class_2246.field_10520 || groundBlock == class_2246.field_10402 || groundBlock == class_2246.field_28685 || groundBlock == class_2246.field_10362 || groundState.method_26212((class_1922)world, basePos.method_10074());
        if (!validGround) {
            if (config.logFelling) {
                TimberReplant.LOGGER.info("Cannot plant: invalid ground block {}", (Object)groundBlock);
            }
            return;
        }
        class_2248 saplingBlock = TreeDetector.getSaplingForLog(logType);
        if (saplingBlock == null || saplingBlock == class_2246.field_10124) {
            if (config.logFelling) {
                TimberReplant.LOGGER.info("Cannot plant: no matching sapling for {}", (Object)logType);
            }
            return;
        }
        class_2680 saplingState = saplingBlock.method_9564();
        if (!saplingState.method_26184((class_4538)world, basePos)) {
            if (config.logFelling) {
                TimberReplant.LOGGER.info("Cannot plant: sapling placement rules failed");
            }
            return;
        }
        world.method_8501(basePos, saplingState);
        if (config.logFelling) {
            TimberReplant.LOGGER.info("Successfully planted {} at {}", (Object)saplingBlock, (Object)basePos);
        } else {
            TimberReplant.LOGGER.info("Planted sapling at {}", (Object)basePos);
        }
    }

    private static void damageToolSafely(class_1799 tool, int damage, class_1657 player) {
        if (tool.method_7960() || !tool.method_7963()) {
            return;
        }
        if (player.method_37908().field_9229.method_43057() < 0.1f) {
            return;
        }
        tool.method_7970(damage, (class_1309)player, player.method_6030().method_7960() ? class_1304.field_6173 : class_1304.field_6171);
    }

    public static boolean isProcessingPosition(class_2338 pos) {
        return processingPositions.contains(pos);
    }
}

