/*
 * Decompiled with CFR 0.152.
 */
package my.osama.timberreplant;

import my.osama.timberreplant.commands.TimberCommand;
import my.osama.timberreplant.config.ConfigManager;
import my.osama.timberreplant.listeners.TreeFellListener;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class TimberReplantPlugin
extends JavaPlugin {
    private static TimberReplantPlugin instance;
    private ConfigManager configManager;
    private TreeFellListener treeFellListener;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.treeFellListener = new TreeFellListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.treeFellListener, (Plugin)this);
        this.getCommand("timber").setExecutor((CommandExecutor)new TimberCommand(this));
        this.getLogger().info("TimberReplant has been enabled! Sustainable forestry is now active.");
    }

    public void onDisable() {
        this.getLogger().info("TimberReplant has been disabled. Thanks for using sustainable forestry!");
    }

    public static TimberReplantPlugin getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public TreeFellListener getTreeFellListener() {
        return this.treeFellListener;
    }

    public void reloadPluginConfig() {
        this.configManager.loadConfig();
        this.getLogger().info("TimberReplant configuration reloaded!");
    }
}

