/*
 * Decompiled with CFR 0.152.
 */
package my.osama.timberreplant.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import my.osama.timberreplant.TimberReplantPlugin;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TimberCommand
implements CommandExecutor,
TabCompleter {
    private final TimberReplantPlugin plugin;

    public TimberCommand(TimberReplantPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                return this.handleReload(sender);
            }
            case "toggle": {
                return this.handleToggle(sender);
            }
            case "info": {
                return this.handleInfo(sender);
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("timberreplant.admin.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        try {
            this.plugin.reloadPluginConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "[TimberReplant] " + String.valueOf(ChatColor.GRAY) + "Configuration reloaded successfully!");
        }
        catch (Exception e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "[TimberReplant] Failed to reload configuration: " + e.getMessage());
        }
        return true;
    }

    private boolean handleToggle(CommandSender sender) {
        if (!sender.hasPermission("timberreplant.admin.toggle")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        this.plugin.getConfig().set("enabled", (Object)(!this.plugin.getConfigManager().isEnabled() ? 1 : 0));
        this.plugin.saveConfig();
        this.plugin.reloadPluginConfig();
        boolean newState = this.plugin.getConfigManager().isEnabled();
        String status = newState ? "enabled" : "disabled";
        ChatColor color = newState ? ChatColor.GREEN : ChatColor.RED;
        sender.sendMessage(String.valueOf(color) + "[TimberReplant] " + String.valueOf(ChatColor.GRAY) + "Plugin has been " + status + "!");
        return true;
    }

    private boolean handleInfo(CommandSender sender) {
        if (!sender.hasPermission("timberreplant.info")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== TimberReplant Info ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Version: " + String.valueOf(ChatColor.WHITE) + this.plugin.getDescription().getVersion());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Enabled: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().isEnabled());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Max Tree Size: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().getMaxTreeSize());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Replanting: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().isReplantEnabled());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Use Durability: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().isUseDurability());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Only Valid Tools: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().isOnlyValidTools());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Require Sneaking: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().isRequireSneaking());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Break Leaves: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().isBreakLeaves());
        if (this.plugin.getConfigManager().isBreakLeaves()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Leaf Search Radius: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().getLeafSearchRadius());
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Drop Leaves: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().isDropLeaves());
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Strict Natural Detection: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().isStrictNaturalDetection());
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== TimberReplant Commands ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/timber help " + String.valueOf(ChatColor.WHITE) + "- Show this help message");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/timber info " + String.valueOf(ChatColor.WHITE) + "- Show plugin information");
        if (sender.hasPermission("timberreplant.admin.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/timber reload " + String.valueOf(ChatColor.WHITE) + "- Reload the plugin configuration");
        }
        if (sender.hasPermission("timberreplant.admin.toggle")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/timber toggle " + String.valueOf(ChatColor.WHITE) + "- Toggle the plugin on/off");
        }
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Plugin by " + (String)this.plugin.getDescription().getAuthors().get(0));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            ArrayList<String> availableCommands = new ArrayList<String>(Arrays.asList("help", "info"));
            if (sender.hasPermission("timberreplant.admin.reload")) {
                availableCommands.add("reload");
            }
            if (sender.hasPermission("timberreplant.admin.toggle")) {
                availableCommands.add("toggle");
            }
            for (String cmd : availableCommands) {
                if (!cmd.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(cmd);
            }
        }
        return completions;
    }
}

