/*
 * Decompiled with CFR 0.152.
 */
package my.osama.timberreplant.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import my.osama.timberreplant.TimberReplantPlugin;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final TimberReplantPlugin plugin;
    private FileConfiguration config;
    private boolean enabled;
    private int maxTreeSize;
    private boolean useDurability;
    private double durabilityMultiplier;
    private List<String> enabledWorlds;
    private boolean replantEnabled;
    private int replantDelayTicks;
    private boolean onlyValidTools;
    private List<String> validTools;
    private boolean requireSneaking;
    private boolean dropItems;
    private boolean breakLeaves;
    private int leafSearchRadius;
    private boolean dropLeaves;
    private boolean showMessages;
    private boolean strictNaturalDetection;
    private double minLeavesToWoodRatio;
    private int maxHorizontalWoodBlocks;
    private Map<Material, Material> woodToSaplingMap;

    public ConfigManager(TimberReplantPlugin plugin) {
        this.plugin = plugin;
        this.woodToSaplingMap = new HashMap<Material, Material>();
        this.setupWoodToSaplingMapping();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.enabled = this.config.getBoolean("enabled", true);
        this.maxTreeSize = this.config.getInt("max-tree-size", 100);
        this.useDurability = this.config.getBoolean("use-durability", true);
        this.durabilityMultiplier = this.config.getDouble("durability-multiplier", 1.0);
        this.enabledWorlds = this.config.getStringList("enabled-worlds");
        this.replantEnabled = this.config.getBoolean("replant.enabled", true);
        this.replantDelayTicks = this.config.getInt("replant.delay-ticks", 20);
        this.onlyValidTools = this.config.getBoolean("tools.only-valid-tools", true);
        this.validTools = this.config.getStringList("tools.valid-tools");
        this.requireSneaking = this.config.getBoolean("require-sneaking", false);
        this.dropItems = this.config.getBoolean("drop-items", true);
        this.breakLeaves = this.config.getBoolean("leaves.break-leaves", true);
        this.leafSearchRadius = this.config.getInt("leaves.search-radius", 6);
        this.dropLeaves = this.config.getBoolean("leaves.drop-leaves", false);
        this.showMessages = this.config.getBoolean("show-messages", false);
        this.strictNaturalDetection = this.config.getBoolean("natural-tree-detection.strict-mode", true);
        this.minLeavesToWoodRatio = this.config.getDouble("natural-tree-detection.min-leaves-ratio", 0.5);
        this.maxHorizontalWoodBlocks = this.config.getInt("natural-tree-detection.max-horizontal-blocks", 6);
        this.plugin.getLogger().info("Configuration loaded successfully!");
    }

    private void setupWoodToSaplingMapping() {
        this.woodToSaplingMap.put(Material.OAK_LOG, Material.OAK_SAPLING);
        this.woodToSaplingMap.put(Material.SPRUCE_LOG, Material.SPRUCE_SAPLING);
        this.woodToSaplingMap.put(Material.BIRCH_LOG, Material.BIRCH_SAPLING);
        this.woodToSaplingMap.put(Material.JUNGLE_LOG, Material.JUNGLE_SAPLING);
        this.woodToSaplingMap.put(Material.ACACIA_LOG, Material.ACACIA_SAPLING);
        this.woodToSaplingMap.put(Material.DARK_OAK_LOG, Material.DARK_OAK_SAPLING);
        this.woodToSaplingMap.put(Material.MANGROVE_LOG, Material.MANGROVE_PROPAGULE);
        this.woodToSaplingMap.put(Material.CHERRY_LOG, Material.CHERRY_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_OAK_LOG, Material.OAK_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_SPRUCE_LOG, Material.SPRUCE_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_BIRCH_LOG, Material.BIRCH_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_JUNGLE_LOG, Material.JUNGLE_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_ACACIA_LOG, Material.ACACIA_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_DARK_OAK_LOG, Material.DARK_OAK_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_MANGROVE_LOG, Material.MANGROVE_PROPAGULE);
        this.woodToSaplingMap.put(Material.STRIPPED_CHERRY_LOG, Material.CHERRY_SAPLING);
        this.woodToSaplingMap.put(Material.OAK_WOOD, Material.OAK_SAPLING);
        this.woodToSaplingMap.put(Material.SPRUCE_WOOD, Material.SPRUCE_SAPLING);
        this.woodToSaplingMap.put(Material.BIRCH_WOOD, Material.BIRCH_SAPLING);
        this.woodToSaplingMap.put(Material.JUNGLE_WOOD, Material.JUNGLE_SAPLING);
        this.woodToSaplingMap.put(Material.ACACIA_WOOD, Material.ACACIA_SAPLING);
        this.woodToSaplingMap.put(Material.DARK_OAK_WOOD, Material.DARK_OAK_SAPLING);
        this.woodToSaplingMap.put(Material.MANGROVE_WOOD, Material.MANGROVE_PROPAGULE);
        this.woodToSaplingMap.put(Material.CHERRY_WOOD, Material.CHERRY_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_OAK_WOOD, Material.OAK_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_SPRUCE_WOOD, Material.SPRUCE_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_BIRCH_WOOD, Material.BIRCH_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_JUNGLE_WOOD, Material.JUNGLE_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_ACACIA_WOOD, Material.ACACIA_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_DARK_OAK_WOOD, Material.DARK_OAK_SAPLING);
        this.woodToSaplingMap.put(Material.STRIPPED_MANGROVE_WOOD, Material.MANGROVE_PROPAGULE);
        this.woodToSaplingMap.put(Material.STRIPPED_CHERRY_WOOD, Material.CHERRY_SAPLING);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxTreeSize() {
        return this.maxTreeSize;
    }

    public boolean isUseDurability() {
        return this.useDurability;
    }

    public double getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }

    public List<String> getEnabledWorlds() {
        return this.enabledWorlds;
    }

    public boolean isReplantEnabled() {
        return this.replantEnabled;
    }

    public int getReplantDelayTicks() {
        return this.replantDelayTicks;
    }

    public boolean isOnlyValidTools() {
        return this.onlyValidTools;
    }

    public List<String> getValidTools() {
        return this.validTools;
    }

    public boolean isRequireSneaking() {
        return this.requireSneaking;
    }

    public boolean isDropItems() {
        return this.dropItems;
    }

    public boolean isBreakLeaves() {
        return this.breakLeaves;
    }

    public int getLeafSearchRadius() {
        return this.leafSearchRadius;
    }

    public boolean isDropLeaves() {
        return this.dropLeaves;
    }

    public boolean isShowMessages() {
        return this.showMessages;
    }

    public boolean isStrictNaturalDetection() {
        return this.strictNaturalDetection;
    }

    public double getMinLeavesToWoodRatio() {
        return this.minLeavesToWoodRatio;
    }

    public int getMaxHorizontalWoodBlocks() {
        return this.maxHorizontalWoodBlocks;
    }

    public Material getSaplingForWood(Material woodType) {
        return this.woodToSaplingMap.get(woodType);
    }

    public boolean isWoodType(Material material) {
        return this.woodToSaplingMap.containsKey(material);
    }
}

