/*
 * Decompiled with CFR 0.152.
 */
package my.osama.timberreplant.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import my.osama.timberreplant.TimberReplantPlugin;
import my.osama.timberreplant.config.ConfigManager;
import my.osama.timberreplant.util.TreeDetection;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TreeFellListener
implements Listener {
    private final TimberReplantPlugin plugin;
    private final ConfigManager configManager;
    private final TreeDetection treeDetection;

    public TreeFellListener(TimberReplantPlugin plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.treeDetection = new TreeDetection(this.configManager);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        Material saplingType;
        boolean isCreative;
        if (!this.configManager.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (!this.configManager.isWoodType(block.getType())) {
            return;
        }
        if (!this.isWorldEnabled(player.getWorld().getName())) {
            return;
        }
        boolean bl = isCreative = player.getGameMode() == GameMode.CREATIVE;
        if (this.configManager.isRequireSneaking() && !player.isSneaking()) {
            return;
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (!this.isValidTool(tool)) {
            return;
        }
        List<Block> treeBlocks = this.treeDetection.getTreeBlocks(block);
        if (treeBlocks.size() <= 1) {
            return;
        }
        if (!this.treeDetection.isNaturalTree(treeBlocks)) {
            return;
        }
        event.setCancelled(true);
        Material originalWoodType = block.getType();
        Block treeBase = this.treeDetection.findTreeBase(treeBlocks);
        List<Block> leafBlocks = new ArrayList<Block>();
        if (this.configManager.isBreakLeaves()) {
            leafBlocks = this.treeDetection.getConnectedLeaves(treeBlocks, originalWoodType);
        }
        this.fellTree(player, treeBlocks, leafBlocks, tool, isCreative);
        if (this.configManager.isReplantEnabled() && treeBase != null && (saplingType = this.configManager.getSaplingForWood(originalWoodType)) != null) {
            this.scheduleReplanting(treeBase, saplingType);
        }
    }

    private boolean isWorldEnabled(String worldName) {
        List<String> enabledWorlds = this.configManager.getEnabledWorlds();
        return enabledWorlds.isEmpty() || enabledWorlds.contains(worldName);
    }

    private boolean isValidTool(ItemStack tool) {
        if (tool == null || tool.getType() == Material.AIR) {
            return !this.configManager.isOnlyValidTools();
        }
        if (!this.configManager.isOnlyValidTools()) {
            return true;
        }
        List<String> validTools = this.configManager.getValidTools();
        return validTools.contains(tool.getType().name());
    }

    private void fellTree(Player player, List<Block> treeBlocks, List<Block> leafBlocks, ItemStack tool, boolean isCreative) {
        Collection drops;
        int woodBlocksBroken = 0;
        int leafBlocksBroken = 0;
        for (Block block : treeBlocks) {
            if (this.configManager.isDropItems()) {
                drops = block.getDrops(tool);
                for (ItemStack drop : drops) {
                    block.getWorld().dropItemNaturally(block.getLocation(), drop);
                }
            } else {
                drops = block.getDrops(tool);
                for (ItemStack drop : drops) {
                    player.getInventory().addItem(new ItemStack[]{drop});
                }
            }
            block.setType(Material.AIR);
            ++woodBlocksBroken;
            if (isCreative || !this.configManager.isUseDurability() || tool == null) continue;
            this.applyDurabilityDamage(tool, player);
            if (tool.getType() != Material.AIR) continue;
            break;
        }
        for (Block leafBlock : leafBlocks) {
            if (this.configManager.isDropLeaves()) {
                if (this.configManager.isDropItems()) {
                    drops = leafBlock.getDrops();
                    for (ItemStack drop : drops) {
                        leafBlock.getWorld().dropItemNaturally(leafBlock.getLocation(), drop);
                    }
                } else {
                    drops = leafBlock.getDrops();
                    for (ItemStack drop : drops) {
                        player.getInventory().addItem(new ItemStack[]{drop});
                    }
                }
            }
            leafBlock.setType(Material.AIR);
            ++leafBlocksBroken;
        }
        if (this.configManager.isShowMessages()) {
            String message = "\u00a7a[TimberReplant] \u00a77Felled tree with " + woodBlocksBroken + " wood blocks";
            if (leafBlocksBroken > 0) {
                message = message + " and " + leafBlocksBroken + " leaf blocks";
            }
            message = message + "!";
            player.sendMessage(message);
        }
    }

    private void applyDurabilityDamage(ItemStack tool, Player player) {
        if (!(tool.getItemMeta() instanceof Damageable)) {
            return;
        }
        Damageable damageable = (Damageable)tool.getItemMeta();
        int currentDamage = damageable.getDamage();
        short maxDurability = tool.getType().getMaxDurability();
        int damageToApply = (int)Math.max(1.0, this.configManager.getDurabilityMultiplier());
        damageable.setDamage(currentDamage + damageToApply);
        tool.setItemMeta((ItemMeta)damageable);
        if (damageable.getDamage() >= maxDurability) {
            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            if (this.configManager.isShowMessages()) {
                player.sendMessage("\u00a7c[TimberReplant] \u00a77Your tool broke!");
            }
        }
    }

    private void scheduleReplanting(Block treeBase, Material saplingType) {
        int delayTicks = this.configManager.getReplantDelayTicks();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Block saplingLocation;
            if ((treeBase.getType() == Material.GRASS_BLOCK || treeBase.getType() == Material.DIRT || treeBase.getType() == Material.COARSE_DIRT || treeBase.getType() == Material.PODZOL || treeBase.getType() == Material.MYCELIUM || treeBase.getType() == Material.ROOTED_DIRT) && (saplingLocation = treeBase.getRelative(0, 1, 0)).getType() == Material.AIR) {
                saplingLocation.setType(saplingType);
                saplingLocation.getWorld().playSound(saplingLocation.getLocation(), Sound.ITEM_HOE_TILL, 0.5f, 1.2f);
            }
        }, (long)delayTicks);
    }
}

